
/*
 *
 * This software is released under the provisions of the GPL version 2.
 * see file "COPYING".  If that file is not available, the full statement 
 * of the license can be found at
 *
 * http://www.fsf.org/licensing/licenses/gpl.txt
 *
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 *
 */

#ifndef _HXPRIVATEIIDS_H_
#define _HXPRIVATEIIDS_H_

/*
 *  File:
 *      hxcorgui.h
 *  Description:
 *      Interfaces used by gui to get info from core
 *  Interfaces:
 *      IID_IHXCoreGuiHook:     {00000000-b4c8-11d0-9995-00a0248da5f0}

 */
DEFINE_GUID_ENUM(IID_IHXCoreGuiHook,    0x00000000, 0xb4c8, 0x11d0, 0x99, 0x95,
0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXInternalReset,    0x00000001, 0xb4c8, 0x11d0, 0x99, 0x95,
0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    hxbdwdth.h
 * Description:
 *    Interface used by raffplin and rmffplin to support 3.0/4.0 style
 *    Bandwidth negotiation.
 * Interfaces:
 *    IID_IHXBandwidthNegotiator: {00000100-b4c8-11d0-9995-00a0248da5f0}
 */

DEFINE_GUID_ENUM(IID_IHXBandwidthNegotiator,    0x00000100, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXBandwidthLister,        0x00000101, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    hxphand.h
 *
 * Description:
 *    Interface for PluginHandler - non-IHX, just gimme the pointer
 *    Bandwidth negotiation.
 * Interfaces:
 *    IID_IHXPluginHandler: {00000200-b4c8-11d0-9995-00a0248da5f0}
 *    IID_IHXPlugin2Handler:{00000201-b4c8-11d0-9995-00a0248da5f0}
 */


#ifndef _HXPLUGN_H_
DEFINE_GUID_ENUM(IID_IHXPluginHandler,  0x00000200, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXPlugin2Handler, 0x00000201, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
#endif
#ifndef _HXPHAND_H_
DEFINE_GUID_ENUM(IID_IHXPlugin2HandlerEnumeratorInterface,      0x00000202, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
#endif

/*
 *  File:
 *      hxrendr.h
 *  Description:
 *      Interfaces related to renderers.
 *  Interfaces:
 *      IID_IHXMediaPushdown            {00000302-0901-11d1-8B06-00A024406D59}
 */

DEFINE_GUID_ENUM(IID_IHXMediaPushdown,      0x00000302, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 * File:
 *    rtspif.h
 * Description:
 *    Interface for resend handling.
 * Interfaces:
 *    IID_IHXPacketResend: {00000400-b4c8-11d0-9995-00a0248da5f0}
 */

DEFINE_GUID_ENUM(IID_IHXPacketResend,     0x00000400, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    rtspif.h
 * Description:
 *    Interface for Context.
 * Interfaces:
 *    IID_IHXRTSPContext: {00000401-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXRTSPContext,     0x00000401, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    rtspif.h
 * Description:
 *    Interface for communicating timestamp.
 * Interfaces:
 *    IID_IHXTimeStampSync: {00000402-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXTimeStampSync,     0x00000402, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    rtspif.h
 * Description:
 *    Interface for servicing synchronization accross transport streams
 * Interfaces:
 *    IID_IHXTransportSyncServer: {16b420d0-f4d0-11d5-aac0-00102051b340}
 */
DEFINE_GUID_ENUM(IID_IHXTransportSyncServer, 0x16b420d0, 0xf4d0, 0x11d5, 0xaa, 0xc0, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)

/*
 *  File: altserv.h
 *
 *  IID_IHXAlternateServerProxy:        {00000403-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXAlternateServerProxy,   0x00000403, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File: altserv.h
 *
 *  IID_IHXAlternateServerProxyResponse:        {00000404-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXAlternateServerProxyResponse, 0x00000404, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    pnupdate.h
 * Description:
 *    Interface for getting file objects to the RealUpdate renderer
 * Interfaces:
 *    IID_IHXUpdateRenderer: {00000500-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXUpdateRenderer, 0x00000500, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
/* From file pnrup/pub/pnrup.h, but related nonetheless. */
DEFINE_GUID_ENUM(IID_IHXCHXRealUpdateResponse, 0x00000501, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXUpdateRendererResponse, 0x00000502, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    hxprefs.h
 * Description:
 *    Interface for deleting prefernces
 * Interfaces:
 *    IID_IHXPreferences3: {0x00000505-9011-11d1-8b60-a024406d59}
 */

#ifndef _HXPREFS_H_
DEFINE_GUID_ENUM(IID_IHXPreferences3, 0x00000505, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

/*
 *  File:
 *      hxpnets.h
 *  Description:
 *      Cloaked HTTP Network Services. Creation of cloaked Client and
 *      Server sockets.
 *  Interfaces:
 *      IID_IHXCloakedNetworkServices   {00000600-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXHTTPProxy                {00000601-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXCloakedTCPSocket {00000602-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXCloakedNetworkServices, 0x00000600, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXHTTPProxy,                  0x00000601, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXCloakedTCPSocket,           0x00000602, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File:
 *      hxmeta.h
 *  Description:
 *      Metafile creation & navigation Interfaces
 *  Interfaces:
 *      IID_IHXMetaTrack:               {00000E01-0901-11d1-8B06-00A024406D59}
 *      IID_IHXMetaGroup:               {00000E02-0901-11d1-8B06-00A024406D59}
 *      IID_IHXMetaLayout:              {00000E03-0901-11d1-8B06-00A024406D59}
 *      IID_IHXMetaTuner:               {00000E04-0901-11d1-8B06-00A024406D59}
 *      IID_IHXMetaFileFormatObject:    {00000E05-0901-11d1-8B06-00A024406D59}
 *      IID_IHXMetaFileFormatResponse:  {00000E06-0901-11d1-8B06-00A024406D59}
 *      IID_IHXSiteLayout:              {00000E07-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXMetaTrack,                  0x00000E01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMetaGroup,                  0x00000E02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMetaLayout,                 0x00000E03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMetaTuner,                  0x00000E04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMetaFileFormatObject,   0x00000E05, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMetaFileFormatResponse, 0x00000E06, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteLayout,                 0x00000E07, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *      hxsrc.h
 *  Description:
 *      Interfaces related to raw sources and sinks
 *  Interfaces:
 *      IID_IHXRawSourceObject: {00001000-0901-11d1-8B06-00A024406D59}
 *      IID_IHXRawSinkObject:           {00001001-0901-11d1-8B06-00A024406D59}
 *      IID_IHXSourceFinderObject:      {00001002-0901-11d1-8B06-00A024406D59}
 *      IID_IHXSourceFinderResponse:    {00001003-0901-11d1-8B06-00A024406D59}
 *      IID_IHXSourceFinderFileResponse:   {00001004-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXRawSourceObject, 0x00001000, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRawSinkObject, 0x00001001, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSourceFinderObject, 0x00001002, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSourceFinderResponse, 0x00001003, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSourceFinderFileResponse, 0x00001004, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *      hxtbuf.h
 *  Description:
 *      Interface related TimeStamped IHXBuffers
 *  Interfaces:
 *      IID_IHXTimeStampedBuffer:       {00000700-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXTimeStampedBuffer, 0x00000700, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File:
 *      hxsmbw.h
 *  Description:
 *      Interface related the ASM Bandwidth Manager
 *  Interfaces:
 *      IID_IHXBandwidthManager:                {00000800-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXSourceBandwidthInfo:             {00000801-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXBandwidthManagerInput:           {00000802-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXStreamBandwidthNegotiator:       {00000803-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXStreamBandwidthBias:             {00000804-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXThinnableSource:         {00000805-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXBandwidthNudger:         {00000806-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXASMProps:                        {00000807-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXAtomicRuleChange:                {00000808-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXAtomicRuleGather:                {00000809-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXPlayerState:                     {0000080A-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXBandwidthManager, 0x00000800, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXSourceBandwidthInfo, 0x00000801, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXBandwidthManagerInput, 0x00000802, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXStreamBandwidthNegotiator, 0x00000803, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXStreamBandwidthBias, 0x00000804, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXThinnableSource, 0x00000805, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXBandwidthNudger, 0x00000806, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXASMProps, 0x00000807, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXAtomicRuleChange, 0x00000808, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXAtomicRuleGather, 0x00000809, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXPlayerState,      0x0000080A, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File:
 *      rmavctrl.c
 *  Description:
 *      Video Control Interface
 *  Interface:
 *      IID_IHXVideoControl:       {00000900-b4c8-11d0-9995-00a0248da5f0}
 *
 */
DEFINE_GUID_ENUM(IID_IHXVideoControl, 0x00000900, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File:
 *      hxxres.h
 *  Description:
 *      Cross platform resource reading class. Reads resources directly
 *      from Win32 DLL's and EXEs on any platform.
 *
 *  Interfaces:
 *      IID_IHXXResFile             {00000A00-b4c8-11d0-9995-00a0248da5f0}
 *      IID_IHXXResource                    {00000A01-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXXResFile,               0x00000A00, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXXResource,              0x00000A01, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File:
 *      hxrasyn.h
 *  Description:
 *      RealAudio Synchronization interface
 *
 *  Interfaces:
 *      IID_IHXRealAudioSync                {00000B00-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXRealAudioSync,  0x00000B00, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File:
 *      hxshtdn.h
 *  Description:
 *      Shut down all the plugins
 *
 *  Interfaces:
 *      IID_IHXShutDownEverything           {00000C00-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXShutDownEverything, 0x00000C00, 0xb4c8, 0x11d0, 0x99,
                                        0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    hxgroup.h
 * Description:
 *    Interface for precache manager
 * Interfaces:
 *    IID_IHXPreCacheMgr: {00000E00-b4c8-11d0-9995-00a0248da5f0}
 */

DEFINE_GUID_ENUM(IID_IHXPreCacheGroupMgr,    0x00000E00, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    hxdataf.h
 * Description:
 *    Interface for basic data file operations
 * Interfaces:
 *    IID_IHXDataFileFactory:   {00000F00-b4c8-11d0-9995-00a0248da5f0}
 *    IID_IHXDataFile:          {00000F01-b4c8-11d0-9995-00a0248da5f0}
 */

DEFINE_GUID_ENUM(IID_IHXDataFileFactory,        0x00000F00, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXDataFile,               0x00000F01, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXAsyncDataFile,          0x972bacc0, 0xaff, 0x11d7, 0xac, 0x45, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)
#ifdef _SYMBIAN
DEFINE_GUID_ENUM(IID_IHXSymbFileSessionManager, 0x8a5c6080, 0xb16, 0x11d7, 0xac, 0x45, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)
#endif // _SYMBIAN

/*
 * File:
 *    memfsys.h
 * Description:
 *    Interface for basic data file operations
 * Interfaces:
 *    IID_IHXMemoryFileContext: {00001000-b4c8-11d0-9995-00a0248da5f0}
 *    IID_IHXMemoryFileSystem:          {00001001-b4c8-11d0-9995-00a0248da5f0}
 */

DEFINE_GUID_ENUM(IID_IHXMemoryFileContext,      0x00001000, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXMemoryFileSystem,       0x00001001, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXMemoryFileSystem2,      0x00001002, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    hxrsdbf.h
 * Description:
 *    Interface for resend buffer management
 * Interfaces:
 *    IID_IHXResendBufferControl:       {00002B00-b4c8-11d0-9995-00a0248da5f0}
 *    IID_IHXResendBufferControl2:      {D3103F1E-738F-4161-9B39-1DE7BC60E0E3}
 */

DEFINE_GUID_ENUM(IID_IHXResendBufferControl,    0x00002B00, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXResendBufferControl2,   0xd3103f1e, 0x738f, 0x4161, 0x9b, 0x39, 0x1d, 0xe7, 0xbc, 0x60, 0xe0, 0xe3)

/*
 * File:
 *    hxtset.h
 * Description:
 *    Timeout settings interface
 * Interfaces:
 *    IID_IHXTimeoutSettings:   {950A6ED6-36D5-11d2-8F78-0060083BE561}
 */
#ifndef _HXTSET_H_
DEFINE_GUID_ENUM(IID_IHXTimeoutSettings,        0x950a6ed6, 0x36d5, 0x11d2, 0x8f, 0x78, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x61)
#endif
/*
 * File:
 *    hxspriv.h
 * Description:
 *    Interface for descriptor registration
 * Interfaces:
 *    IID_IHXDescriptorRegistration:  {00001100-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXDescriptorRegistration, 0x00001100, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 * File:
 *    hxxrsmg.h
 * Description:
 *    Interface for external resource manager
 * Interfaces:
 *    IID_IHXExternalResourceManager:  {00001200-b4c8-11d0-9995-00a0248da5f0}
 *    IID_IHXExternalResourceReader:   {00001201-b4c8-11d0-9995-00a0248da5f0}
 */
DEFINE_GUID_ENUM(IID_IHXExternalResourceManager, 0x00001200, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)
DEFINE_GUID_ENUM(IID_IHXExternalResourceReader,  0x00001201, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

/*
 *  File:
 *      hxcredc.h
 *  Description:
 *      Interface for credential(username/password) cache
 *
 *  Interfaces:
 *      IID_IHXCredentialsCache         {00002B00-0901-11d1-8B06-00A024406D59}
 */

DEFINE_GUID_ENUM(IID_IHXCredentialsCache,       0x00002B00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)


/*
 *  File:
 *      hxxml.h
 *  Description:
 *      Interface for XML parser
 *
 *  Interfaces:
 *      IID_IHXXMLParser                {00002D00-0901-11d1-8B06-00A024406D59}
 *      IID_IHXXMLParserResponse        {00002D01-0901-11d1-8B06-00A024406D59}
 *      IID_IHXXMLNamespaceParser       {00002D02-0901-11d1-8B06-00A024406D59}
 *      IID_IHXXMLNamespaceResponse     {00002D03-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXXMLParser,              0x1a39e773, 0xfe28, 0x4ca9, 0x93, 0x18, 0x9d, 0x21, 0xee, 0x85, 0xe4, 0x7a)
DEFINE_GUID_ENUM(IID_IHXXMLParserResponse,      0x00002D01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXXMLNamespaceParser,     0x00002D02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXXMLNamespaceResponse,0x00002D03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *    {0000150*-***************************} DEPRECATED
 *    {0000150*-***************************} DEPRECATED
 */


/*
 * File:
 *    clbwcont.h
 * Description:
 *   Interface for controlling client bandwidth usage from the server
 *
 * Interfaces:
 *   IID_IHXClientBandwidthController: {00001600-b4c8-11d0-9995-00a0248da5f0
}
 */

DEFINE_GUID_ENUM(IID_IHXClientBandwidthController, 0x00001600, 0xb4c8, 0x11d0, 0x99 , 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)


/* File:
 *      embdsvcs.h
 *
 * Description:
 *
 *  IRCAEmbeddedServices - RCA embedded player services
 */

DEFINE_GUID_ENUM(IID_IRCAEmbeddedServices,
    0x00003807, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)


/* This IID is just reserved here, there is no interface for it */
DEFINE_GUID_ENUM(IID_ServerPacket, 0x00001700, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

#ifndef _HXPHOOK_H_

DEFINE_GUID_ENUM(IID_IHXPacketHookSink, 0x00002004, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRecordTimeline, 0x00002005, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

#endif

/* File:
 *      Used by licrequest.cpp
 *
 * Description:
 *
 *  IHXLicenseRequestResponse - Response interface for async license
 *  request
 */
// {b8676e90-625c-11d4-968500c0f031f80f}
DEFINE_GUID_ENUM( IID_IHXLicenseRequestResponse,
    0xb8676e90, 0x625c, 0x11d4, 0x96, 0x85, 0x00, 0xc0, 0xf0, 0x31, 0xf8, 0x0f)

/* File:
 *      Used by inetwork.cpp
 *
 * Description:
 *
 *      IHXBufferedSocket - buffered writes for higher performing
 *      TCP
 *
 */

#ifndef _HXENGIN_H_
DEFINE_GUID_ENUM(IID_IHXBufferedSocket,
    0x00001402, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif /* _HXENGIN_H_ */
/* File:
 *      Used by propreadonly.*(server)
 *
 * Description:
 *
 *  IHXInternalSetPropReadOnly - Set/Unset registry properties to be read only
 */
// {b8676e90-625c-11d4-968500c0f0320910}
DEFINE_GUID_ENUM(IID_IHXInternalSetPropReadOnly,
    0xb8676e90, 0x625c, 0x11d4, 0x96, 0x85, 0x00, 0xc0, 0xf0, 0x32, 0x09, 0x10)



/* File:
 *      hxcore.h
 *
 * Description:
 *
 *  IHXClientStatisticsGranularity - Experimental interface to allow setting the rate at which statictics are generated
 *  IHXPlayerPresentation - Control over the player's current presentation
 *  IHXCoreMutex - Control the core mutex
 *  IHXMacBlitMutex - control Mac blitting to ensure no reentrancy
 */
// {b8676e90-625c-11d4-968500c0f0320910}
#ifndef _HXCORE_H_
DEFINE_GUID_ENUM(IID_IHXClientStatisticsGranularity, 0x00000417, 0x901, 0x11d1, 0x8b, 0x6, 0x0,
                        0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerPresentation, 0x6de011a7, 0xef05, 0x417b, 0x93, 0x67, 0x6f, 0xe0, 0xe5, 0x43, 0x2, 0xd3)
DEFINE_GUID_ENUM(IID_IHXCoreMutex, 0x6de011a7, 0xef05, 0x417b, 0x93, 0x67, 0x6f, 0xe0, 0xe4, 0x44, 0x4, 0xd4)
DEFINE_GUID_ENUM(IID_IHXMacBlitMutex, 0x294e6de4,  0xfbc6,  0x4c06,  0xbb,  0x94,  0x95, 0xa9,  0x69,  0x37,  0x3b,  0x4d)
#endif /* _HXCORE_H_ */

/*
 * File:
 *    hxpreftr.h
 *
 * Description:
 *
 *      IHXPreferredTransportManager
 *      IHXPreferredTransport
 *      IHXPreferredTransportSink
 *
 * Interfaces:
 *    IID_IHXPreferredTransportManager:             {00003700-0901-11d1-8B06-00A024406D59}
 *    IID_IHXPreferredTransport:                    {00003701-0901-11d1-8B06-00A024406D59}
 *    IID_IHXPreferredTransportSink:                {00003702-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXPreferredTransportManager,  0x00003700, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPreferredTransport,         0x00003701, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPreferredTransportSink,     0x00003702, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 * File:
 *    used by inetwork.cpp, rtspserv.cpp
 *
 * Description:
      An IID to distiguish LocalBoundSocket from IHXTCPSocket
 */
DEFINE_GUID_ENUM(IID_IHXPLocalBoundSocket, 0xc1f00ad1, 0x61e7, 0x11d5, 0xa5, 0x30,
                    0x0, 0x2, 0xb3, 0x6, 0xdc, 0x93)

/*
 * File:
 *    http.cpp, adminfo.cpp
 *
 * Description:
 *    File object interface to support out of band http post data
 */
#ifndef _HXFILES_H_
DEFINE_GUID_ENUM(IID_IHXPostDataHandler, 0x0222a1b5, 0x49fc, 0x47e2, 0xb6,
        0x90, 0x98, 0xbe, 0xfa, 0x0a, 0x58, 0x8e)
#endif

/*
 * File:
 *    ihxlist.h - COM list containers
 *
 * Description:
 *
 * Interfaces:
 *    IID_IHXList
 *    IID_IHXListIterator
 */
#ifndef _IHXLIST_H_
DEFINE_GUID_ENUM(IID_IHXList, 0x1599cb17, 0x9db4, 0x4f8a, 0x86, 0x5a, 0x78, 0xa5, 0x4e, 0xff, 0xbc, 0x60)
DEFINE_GUID_ENUM(IID_IHXListIterator, 0xe7ad1443, 0xf6bf, 0x4b0e, 0xbc, 0x00, 0x8f, 0x03, 0xc0, 0xb1, 0x27, 0x24)
#endif /* _IHXLIST_H_ */


/*
 * File:
 *    hxrtsp2.h - New RTSP stuff (tommy's new parser, etc.)
 *
 * Description:
 *    The faster and more efficient (memcpy-wise) RTSP parser, MIME header
 * handler and related clases.
 *
 * Interfaces:
 *    IID_IHXMIMEParameter
 *    IID_IHXMIMEField
 *    IID_IHXMIMEHeader
 *    IID_IHXRTSPMessage
 *    IID_IHXRTSPRequestMessage
 *    IID_IHXRTSPResponseMessage
 *    IID_IHXRTSPConsumer
 *    IID_IHXRTSPProtocolResponse
 *    IID_IHXRTSPProtocol
 */
#ifndef _HXRTSP2_H_
DEFINE_GUID_ENUM(IID_IHXMIMEParameter,  0x8ae57afa, 0x902c, 0x4327, 0x8c, 0x00, 0x31, 0x57, 0x85, 0xcd, 0xc2, 0x43)
DEFINE_GUID_ENUM(IID_IHXMIMEField,              0x946eed6, 0x0501, 0x4fc3, 0x94, 0xbb, 0x30, 0x23, 0xa0, 0xe5, 0x23, 0xc7)
DEFINE_GUID_ENUM(IID_IHXMIMEHeader,     0x97e681a3, 0xbd71, 0x4b81, 0x8f, 0xa0, 0x81, 0x19, 0x9e, 0x79, 0x9a, 0xe7)
DEFINE_GUID_ENUM(IID_IHXRTSPMessage,    0x1bff98ab, 0xe5c9, 0x459d, 0x80, 0xee, 0xb8, 0x0d, 0x20, 0xe4, 0xf3, 0x0e)
DEFINE_GUID_ENUM(IID_IHXRTSPRequestMessage,     0xddb0e73f, 0x0d5a, 0x4fd1, 0xbd, 0xc8, 0x95, 0x7f, 0x0d, 0x87, 0x2a, 0x33)
DEFINE_GUID_ENUM(IID_IHXRTSPResponseMessage, 0x876baec2, 0xec9e, 0x41dc, 0x8c, 0xb6, 0xe8, 0x74, 0xb6, 0x0f, 0xba, 0xd6)
DEFINE_GUID_ENUM(IID_IHXRTSPInterleavedPacket, 0x4d737eff, 0x8218, 0x4762, 0xac, 0xe3, 0xfc, 0xf2, 0x7c, 0x08, 0xf9, 0x16)
DEFINE_GUID_ENUM(IID_IHXRTSPConsumer,   0xda62eb99, 0x2120, 0x410a, 0x98, 0x66, 0x90, 0xf7, 0xec, 0x9c, 0xc1, 0x5d)
DEFINE_GUID_ENUM(IID_IHXRTSPProtocol,   0x29d8eebf, 0x5597, 0x410b, 0xa2, 0x90, 0x81, 0x81, 0xbe, 0x1e, 0x24, 0x30)
DEFINE_GUID_ENUM(IID_IHXRTSPProtocolResponse, 0xbf646cd4, 0x922c, 0x4b9c, 0xac, 0x92, 0x96, 0xe7, 0x74, 0xde, 0x56, 0x39)
#endif

/*
 * File:
 *    hxsdp.h - New SDP stuff
 *
 * Description:
 *    The faster and more efficient (memcpy-wise) SDP parser
 * handler and related clases.
 *
 * Interfaces:
 *    IID_IHXSDPAttrib
 *    IID_IHXSDPTimeDesc
 *    IID_IHXSDPMedia
 *    IID_IHXSDP
 */
#ifndef _HXSDP_H_
DEFINE_GUID_ENUM(IID_IHXSDPAttrib, 0x538d82b4, 0xa284, 0x4527, 0xae, 0xf5, 0x47, 0xce, 0x87, 0xd8, 0x31, 0xcc)
DEFINE_GUID_ENUM(IID_IHXSDPTimeDesc, 0xffc46a97, 0x965d, 0x41cb, 0xa3, 0x50, 0xde, 0x2c, 0x48, 0x6e, 0x72, 0x90)
DEFINE_GUID_ENUM(IID_IHXSDPMedia, 0x30069090, 0xa6dc, 0x47c5, 0x89, 0x1f, 0x9e, 0xea, 0x9c, 0x86, 0x0a, 0x6b)
DEFINE_GUID_ENUM(IID_IHXSDP, 0x6fe2a32b, 0x36fa, 0x4fd4, 0x88, 0x09, 0x1c, 0x5a, 0xda, 0x9b, 0xea, 0x15)
#endif

#ifndef _HXLISTP_H_
DEFINE_GUID_ENUM(IID_IHXListIteratorPrivate, 0x2d3f1b24, 0x6e4e, 0x4fdc, 0x9e, 0x53, 0x4b, 0x9b, 0xd7, 0x3f, 0x3f, 0xed)
DEFINE_GUID_ENUM(IID_IHXVectorIteratorPrivate, 0x58b7d31f, 0x2261, 0x4608, 0xa6, 0x34, 0x4e, 0x98, 0xdc, 0x8f, 0xa8, 0x4f)
DEFINE_GUID_ENUM(IID_IHXRingBufferIteratorPrivate, 0x87d7ca44, 0x7a75, 0x11d7, 0x8b, 0x4a, 0x00, 0xd0, 0xb7, 0x10, 0x35, 0xfe)
#endif

/*
 * File:
 *    hxmms.h - MMS protocol
 *
 * Description:
 *    MMS (Windows Media) protocol.
 *
 * Interfaces:
 *    IID_
 */
#ifndef _HXMMS2_H_
DEFINE_GUID_ENUM(IID_IHXMMSMessage, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x00)
DEFINE_GUID_ENUM(IID_IHXMMSConsumer, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x01)
DEFINE_GUID_ENUM(IID_IHXMMSMessageClientHello, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x02)
DEFINE_GUID_ENUM(IID_IHXMMSMessageServerHello, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x03)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup1, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x04)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup2, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x05)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup3, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x06)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup4, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x07)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup5, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x08)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup6, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x09)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup7, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x0a)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSetup8, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x0b)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSubscribe, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x0c)
DEFINE_GUID_ENUM(IID_IHXMMSMessageSubscribeAck, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x0d)
DEFINE_GUID_ENUM(IID_IHXMMSMessagePlay, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x0e)
DEFINE_GUID_ENUM(IID_IHXMMSMessagePlayAck, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x0f)
DEFINE_GUID_ENUM(IID_IHXMMSMessageStop, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x10)
DEFINE_GUID_ENUM(IID_IHXMMSMessageEndData, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x11)
DEFINE_GUID_ENUM(IID_IHXMMSMessageFastPlay, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x12)
DEFINE_GUID_ENUM(IID_IHXMMSMessageFastPlayAck, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x13)
DEFINE_GUID_ENUM(IID_IHXMMSMessageStats, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x14)
DEFINE_GUID_ENUM(IID_IHXMMSMessageGoodbye, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x15)
DEFINE_GUID_ENUM(IID_IHXMMSMessagePing, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x16)
DEFINE_GUID_ENUM(IID_IHXMMSFileHeader, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x17)
DEFINE_GUID_ENUM(IID_IHXMMSInterleavedPacket, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x18)
DEFINE_GUID_ENUM(IID_IHXMMSProtocol, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x19)
DEFINE_GUID_ENUM(IID_IHXMMSProtocolResponse, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x1a)
DEFINE_GUID_ENUM(IID_IHXWM60PlayerLiveHack, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x1b)
DEFINE_GUID_ENUM(IID_IHXMMSMessageLiveHeader, 0x3cb3f6dc, 0xcb9a, 0x4a37, 0x99, 0x3a, 0xd1, 0x81, 0x7a, 0xdd, 0x91, 0x1c)
#endif

/*
 *
 *  File:
 *      hxstktrc.h -- Stack Trace interface for debugging
 *
 *  Description:
 *      This interface provides the user the ability to get the stack
 *      trace at any point in the program by a call to GetTrace().
 */
DEFINE_GUID_ENUM(IID_IHXStackTrace, 0x00004702, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *      hxformt.h
 *  Description:
 *      Interfaces related to file and broadcast format plugins.
 *  Interfaces:
 *      IID_IHXSetPlayParam            {0x503c212c-413f-478b-9fc8daa7b145b8a9}
 *      IID_IHXSetPlayParamResponse    {0x750008af-5588-4838-85faaa203a32c799}
 *      IID_IHXSeekByPacket            {0x171c3c4e-c4ea-46fd-b47b-c3b82dbb9517}
 *  IID_IHXSeekByPacketResponse        {0xe978476d-6c99-4dc6-9279-7525c693dc34}
 */
#ifndef _HXFORMT_H_
DEFINE_GUID_ENUM(IID_IHXSetPlayParam,       0x503c212c, 0x413f, 0x478b, 0x9f, 0xc8, 0xda, 0xa7, 0xb1, 0x45, 0xb8, 0xa9)
DEFINE_GUID_ENUM(IID_IHXSetPlayParamResponse,   0x750008af, 0x5588, 0x4838, 0x85, 0xfa, 0xaa, 0x20, 0x3a, 0x32, 0xc7, 0x99)

DEFINE_GUID_ENUM(IID_IHXSeekByPacket,          0x171c3c4e, 0xc4ea, 0x46fd, 0xb4, 0x7b, 0xc3, 0xb8, 0x2d, 0xbb, 0x95, 0x17)
DEFINE_GUID_ENUM(IID_IHXSeekByPacketResponse,  0xe978476d, 0x6c99, 0x4dc6, 0x92, 0x79, 0x75, 0x25, 0xc6, 0x93, 0xdc, 0x34)
#endif

/*
 *
 *  File:
 *      hxpac.h
 *
 */
DEFINE_GUID_ENUM(IID_IHXProxyAutoConfig,                0x00004800, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXProxyAutoConfigCallback,        0x00004801, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXProxyAutoConfigAdviseSink,      0x00004802, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *
 *  File:
 *      hxfwmgr.h
 *
 */
DEFINE_GUID_ENUM(IID_IHXFirewallControlManager,         0x00004900, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *
 *  File:
 *      mmsrsend.h
 *
 */
#ifndef MMSRSEND_H
DEFINE_GUID_ENUM(IID_IHXMMSResendManager, 0x4676c245, 0xad4e, 0x45b9, 0xa8, 0xdd, 0x60, 0xa8, 0xe4, 0x7b, 0xf6, 0x05)
DEFINE_GUID_ENUM(IID_IHXMMSResendResponse, 0xa581f3a4, 0xc508, 0x4800, 0xba, 0xdc, 0xb4, 0xf1, 0xcd, 0x11, 0x07, 0xb6)
#endif


/*
 *
 *  File:
 *      hxdist_lic_requester.h
 *
 */
DEFINE_GUID_ENUM(IID_IHXDistributedLicenseRequester, 0x00005702, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDistributedLicenseRequestStatus, 0x00005703, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 * File: hxauto.h
 */
DEFINE_GUID_ENUM(IID_IHXHTTPAutoStream,
    0x60b68af1, 0x9f0, 0x11d3, 0x8b, 0x57, 0x0, 0x90, 0x27, 0x42, 0xc8, 0xa7)

/*
 * File: hxflche.h
 */
DEFINE_GUID_ENUM(IID_IHXFileSystemCache,
    0x18d8a780, 0xf90d, 0x11d2, 0xad, 0x55, 0x0, 0xc0, 0xf0, 0x31, 0xc2, 0x36)

/*
 * File: ihxident.h
 */
DEFINE_GUID_ENUM(IID_IHXProductIdentity,
    0xae7eb8a0, 0x32dc, 0x11d2, 0x8a, 0xc0, 0x0, 0xc0, 0x4f, 0xee, 0x3a, 0x97)
DEFINE_GUID_ENUM(IID_IHXProductIdentity2,
    0xae7eb8a0, 0x32dc, 0x11d2, 0x7a, 0xc0, 0x0, 0xc0, 0x4f, 0xee, 0x3a, 0x98)

/*
 * File: ihxperplex.h
 */
DEFINE_GUID_ENUM(IID_IHXPerplex,
    0xb0f17ee1, 0xdd86, 0x11d2, 0xb3, 0x39, 0x0, 0xc0, 0xf0, 0x31, 0x87, 0x98)

/*
 * File: ihxdefpackethookhlp.h
 */
DEFINE_GUID_ENUM(IID_IHXDefaultPacketHookHelper,
    0x50540475, 0x79e8, 0x471e, 0xb6, 0x89, 0x3, 0xc4, 0x20, 0xea, 0xc5, 0xe1)

/*
 * File: rvsink.h
 */
DEFINE_GUID_ENUM(IID_IRVSinkMgr,
    0xa57fd431, 0x4599, 0x11d4, 0xb4, 0x23, 0x0, 0x90, 0x27, 0x43, 0xf, 0x4c)

/*
 * File: hxpcmkr.h
 */
DEFINE_GUID_ENUM(IID_IHXPaceMaker,
    0x1223eff0, 0x4dad, 0x11d5, 0xa9, 0x38, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)

DEFINE_GUID_ENUM(IID_IHXPaceMakerResponse,
    0xb4d81b50, 0x4dac, 0x11d5, 0xa9, 0x38, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)


/*
 * File: hxfswch.h
 */
DEFINE_GUID_ENUM(IID_IHXFileSwitcher,
    0x55cc55b0, 0x1ba, 0x11d4, 0x95, 0x23, 0x0, 0x90, 0x27, 0x42, 0xc9, 0x23)

/*
 * File: hxatmzr.h
 */
DEFINE_GUID_ENUM(IID_IHXAtomizationCommander,
    0xafdcd230, 0x4b, 0x11d4, 0x95, 0x23, 0x0, 0x90, 0x27, 0x42, 0xc9, 0x23)

DEFINE_GUID_ENUM(IID_IHXAtomizerResponse,
    0x72bc0330, 0x41, 0x11d4, 0x95, 0x23, 0x0, 0x90, 0x27, 0x42, 0xc9, 0x23)

#if defined(_STATICALLY_LINKED) && defined(WIN32) && !defined(_NO_COM)
/*
 * File: ddraw.h
 */
//DEFINE_GUID_ENUM(IID_IDirectDraw2,
//    0xB3A6F3E0, 0x2B43, 0x11CF, 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56)

#endif

/*
 * File: hxacodec.h
 */
DEFINE_GUID_ENUM(IID_IHXAudioDecoder,
    0x26139eda, 0x98d8, 0x437b, 0x92, 0x29, 0x94, 0x9d, 0x3b, 0xef, 0x25, 0x51)

DEFINE_GUID_ENUM(IID_IHXAudioEncoder,
    0x56ff66f4, 0xa6c5, 0x42aa, 0xb2, 0x67, 0xc2, 0x96, 0xdd, 0x7, 0x5d, 0xa3)

DEFINE_GUID_ENUM(IID_IHXAudioEncoderConfigurator,
    0xb9919b52, 0x54ff, 0x4099, 0x98, 0x4a, 0x53, 0x3e, 0x75, 0xb5, 0x78, 0xb9)

DEFINE_GUID_ENUM(IID_IHXCodecOldStyleAuthenticate,
    0xeae2fec7, 0xac4b, 0x4d15, 0xb1, 0xdc, 0xa, 0x94, 0x54, 0x9c, 0xf2, 0xc9)

DEFINE_GUID_ENUM(IID_IQueryDecoderUnit,
    0x5720a4df, 0x7b79, 0x47ae, 0x84, 0x94, 0x6b, 0x46, 0x52, 0xf2, 0xd4, 0xad)

/*
 * File: ihxsimpleencryptionservice.h
 */
DEFINE_GUID_ENUM(IID_IHXSimpleEncryptionService,
    0x2a3e75dd, 0xe43e, 0x41f3, 0xad, 0xe3, 0xac, 0x9b, 0x95, 0xc2, 0x79, 0xd1)

/*
 * File: rmacrptg.h
 */
DEFINE_GUID_ENUM(IID_IHXCryptograph,
    0x78b12021, 0x9250, 0x11d4, 0x8f, 0x56, 0xe0, 0xde, 0x51, 0xc1, 0x0, 0x0)


#ifdef HELIX_FEATURE_HTTP_SERVICE
/*
 * File: hxhttp.h
 */
DEFINE_GUID_ENUM(IID_IHXHttp,
                 0xe7ddb0b0, 0x9846, 0x11d1, 0xa5, 0xfe, 0x0, 0x60, 0x97, 0xe5, 0x7c, 0x78);
DEFINE_GUID_ENUM(IID_IHXHttp2,
                 0xe7ddb0b0, 0x9846, 0x11d1, 0xb5, 0xfe, 0x0, 0x60, 0x97, 0xe5, 0x7c, 0x87);
DEFINE_GUID_ENUM(IID_IHXHttpResponse,
                 0xbdf0bb0, 0x9847, 0x11d1, 0xa5, 0xfe, 0x0, 0x60, 0x97, 0xe5, 0x7c, 0x78);
DEFINE_GUID_ENUM(IID_IHXHttpResponse2,
                 0xe7ddb0b0, 0x9846, 0x11d1, 0xb5, 0xfe, 0x0, 0x60, 0x95, 0xe5, 0x7d, 0x87);
DEFINE_GUID_ENUM(IID_IHXHttpInitialize,
                 0x083912d6, 0x6c54, 0x4e13, 0xa6, 0x99, 0xc5, 0xb3, 0x06, 0xd7, 0x61, 0xae);
#endif


/*
 * File: ihxhurl.h
 */
DEFINE_GUID_ENUM(IID_IHXHurl,
    0xb16c0330, 0xb2ec, 0x11d1, 0x8e, 0xfd, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x61)

/*
 * File: icmdbcst.h
 */
DEFINE_GUID_ENUM(IID_IHXCmdBroadcaster,
    0x00000700, 0x6050, 0x1450, 0x7c, 0xea, 0x7, 0x0b, 0x18, 0xf8, 0x6a, 0x71)

DEFINE_GUID_ENUM(IID_IHXCmdObserver,
    0x00000700, 0x6050, 0x1450, 0x7c, 0xea, 0x7, 0x0b, 0x18, 0xa8, 0x6a, 0x72)

/*
 * File: dunitprvt.h
 */
DEFINE_GUID_ENUM(IID_IPrepareDecoderUnit,
    0x655dd923, 0x3ab, 0x45b2, 0xb9, 0x1e, 0xf, 0x46, 0x57, 0xec, 0x9d, 0xc3)

/*
 * pxffmcod.h
 */
DEFINE_GUID_ENUM(IID_IHXRealPixFileFormatCodec,
    0x309f2d21, 0xcc0a, 0x11d2, 0x8a, 0x53, 0x10, 0xf, 0xf0, 0x0, 0x0, 0x0)

/*
 * pxrndcod.h
 */
DEFINE_GUID_ENUM(IID_IHXRealPixRendererCodec,
    0x10552e61, 0xc6f1, 0x11d2, 0x8a, 0x4f, 0x28, 0x90, 0x9a, 0x0, 0x0, 0x0)

/*
 * File:     hxrtsp2.h
 */
DEFINE_GUID_ENUM(IID_IHXRTSPAggregateEventStats, 0x4ed8aabe, 0x5597, 0x410b, 0xa2, 0x90, 0x81, 0x81, 0xbe, 0x1e, 0x24, 0x01)
DEFINE_GUID_ENUM(IID_IHXRTSPEventsSink, 0x26a03092, 0x49d6, 0x483a, 0xa1, 0x2d, 0x4d, 0x69, 0xe2, 0x88, 0x56, 0xd0)
DEFINE_GUID_ENUM(IID_IHXRTSPEventsManager, 0x84988f28, 0x9264, 0x46ba, 0x8b, 0x5a, 0xb2, 0x6b, 0xd6, 0xf1, 0x63, 0x72)

/*
 * File:     rtspif.h
 */
DEFINE_GUID_ENUM(IID_IHXRTSPServerPauseResponse, 0xbf646cd4, 0x922c, 0x4b9c, 0xac, 0x92, 0x96, 0xe7, 0x74, 0xde, 0x56, 0x02)

/*
 * File:        hxsdp.h
 */
DEFINE_GUID_ENUM(IID_IHXSDPAggregateStats, 0x4ed8aabe, 0x5597, 0x410b, 0xa2, 0x90, 0x81, 0x81, 0xbe, 0x1e, 0x24, 0x03)

/*
 * File:        hxrecord.h
 */
DEFINE_GUID_ENUM(IID_IHXRecordManager, 0x9b7854dd, 0x92c8, 0x42c6, 0x93, 0x6c, 0x56, 0x5e, 0xc3, 0x73, 0xe2, 0xad)
DEFINE_GUID_ENUM(IID_IHXRecordService, 0xf2f8c09a, 0xa607, 0x40c9, 0x9c, 0x26, 0x48, 0x3b, 0xbb, 0xc4, 0xa0, 0x86)
DEFINE_GUID_ENUM(IID_IHXRecordSource, 0xe007f531, 0x4ec9, 0x4555, 0x8e, 0xc5, 0x1d, 0x58, 0x49, 0x99, 0x4, 0xdf)


/*
 * File:        hxstats.h
 */

DEFINE_GUID_ENUM(IID_IHXSessionStats, 0x3c02c47f, 0x6f44, 0x47fd, 0xb6, 0x25, 0xc8, 0x1a, 0x2b, 0xf0, 0x5d, 0x4f)
DEFINE_GUID_ENUM(IID_IHXClientStats, 0x83ce47e8, 0x3ebe, 0x450a, 0xbf, 0x49, 0x66, 0xd8, 0x80, 0x94, 0xe5, 0x16)
DEFINE_GUID_ENUM(IID_IHXClientStats2, 0x5dad23df, 0xa442, 0x4fe9, 0x89, 0xcd, 0x39, 0xb1, 0x3d, 0xa5, 0xca, 0x51)
DEFINE_GUID_ENUM(IID_IHXClientStatsSink, 0xfdc6d1aa, 0xd78e, 0x40b0, 0xa3, 0xe6, 0xb7, 0xd6, 0xdf, 0x30, 0x38, 0x3b)
DEFINE_GUID_ENUM(IID_IHXClientStatsManager, 0xe0ece2b8, 0xa94b, 0x4eb4, 0xaf, 0xd, 0x17, 0x7d, 0x5, 0x3b, 0x2e, 0xd6)

/*
 * File:        server_stats.h
 */

DEFINE_GUID_ENUM(IID_IHXClientStatsTimerControl, 0x793ab631, 0xb654, 0x4aae, 0x99, 0xa3, 0xd, 0xf8, 0x72, 0x58, 0xc3, 0x63)

/*
 * File:        ihxplayerstateobserver.h
 */

DEFINE_GUID_ENUM(IID_IHXPlayerStateObserver, 0x466c7e42, 0x81d1, 0x4746, 0xa6, 0xd4, 0x9e, 0x9f, 0x99, 0xba, 0x7b, 0xb5)


/*
 * File:        hxqosinfo.h
 */

DEFINE_GUID_ENUM(IID_IHXQoSTransportAdaptationInfo, 0x213645c5, 0x3a56, 0x4945, 0xa8, 0xa9, 0x67, 0x2, 0xbb, 0x56, 0x4, 0xb6)
DEFINE_GUID_ENUM(IID_IHXQoSSessionAdaptationInfo, 0xaed09295, 0xa71, 0x4520, 0x9d, 0x7f, 0xbf, 0xa9, 0xb5, 0xa9, 0x72, 0x45)
DEFINE_GUID_ENUM(IID_IHXQoSApplicationAdaptationInfo, 0x207e23e5, 0xf71f, 0x4a18, 0xb7, 0xd0, 0xf4, 0xf8, 0x65, 0xa2, 0x5, 0x8b)

/*
 * File:	hxcache2.h
 */

DEFINE_GUID_ENUM(IID_IHXCacheObjectResponse,
    0x00002E11, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59) 
DEFINE_GUID_ENUM(IID_IHXCache2,
    0x00002E0E, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXCacheObject,
    0x00002E10, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
/*
 * File:        hxrssmgr.h
 */

DEFINE_GUID_ENUM(IID_IHXRSSReport, 0xbd2f1e35, 0x83e4, 0x4459, 0x94, 0x30, 0x2e, 0xb6, 0x37, 0xad, 0xbe, 0x17)
DEFINE_GUID_ENUM(IID_IHXRSSManager, 0x66fb8dc5, 0xd3d4, 0x4aaf, 0x8f, 0x88, 0x56, 0xb3, 0xc8, 0xa7, 0xd3, 0x1f)

/*
 * File:        hxlogoutputs.h
 */
DEFINE_GUID_ENUM(IID_IHXLogOutput, 0x88ec448c, 0x136c, 0x4733, 0x94, 0x3, 0xdc, 0x43, 0x40, 0x9d, 0xca, 0x29)
DEFINE_GUID_ENUM(IID_IHXLogFileOutput, 0xc5c9c037, 0x53fa, 0x4478, 0x8b, 0xfd, 0xe4, 0x9e, 0x58, 0x8b, 0xf2, 0x1f)

/* File:
 *      hxbufctl.h
 *
 * Description:
 *      Client buffer control interfaces
 */
DEFINE_GUID_ENUM(IID_IHXBufferControl, 0x68b2aef9, 0x1384, 0x46ec, 0xa4, 0xd0, 0x0, 0x68, 0xa, 0x7d, 0xbb, 0xae)
DEFINE_GUID_ENUM(IID_IHXWatermarkBufferControl, 0x68b2aef9, 0x1384, 0x46ec, 0xa4, 0xd0, 0x0, 0x68, 0xa, 0x7d, 0xbb, 0xaf)
DEFINE_GUID_ENUM(IID_IHXTransportBufferLimit, 0x68b2aef9, 0x1384, 0x46ec, 0xa4,0xd0, 0x0, 0x68, 0xa, 0x7d, 0xbb, 0xb0)

/* File:
 *      ihxaccesspoint.h
 *
 * Description:
 *      Access Point interfaces
 */
DEFINE_GUID_ENUM(IID_IHXAccessPointConnectResponse, 0x9e9ca2d6, 0xcbfe, 0x40f8, 0x94, 
		 0xfd, 0x38, 0xf4, 0xeb, 0x5d, 0xf8, 0xf)
DEFINE_GUID_ENUM(IID_IHXAccessPointManager, 0x9e9ca2d6, 0xcbfe, 0x40f8, 0x94, 
		 0xfd, 0x38, 0xf4, 0xeb, 0x5d, 0xf8, 0x10)
DEFINE_GUID_ENUM(IID_IHXAccessPointSelectorResponse, 
		 0x9e9ca2d6, 0xcbfe, 0x40f8, 0x94, 
		 0xfd, 0x38, 0xf4, 0xeb, 0x5d, 0xf8, 0x11)
DEFINE_GUID_ENUM(IID_IHXAccessPointSelector, 0x9e9ca2d6, 0xcbfe, 0x40f8, 0x94,
		 0xfd, 0x38, 0xf4, 0xeb, 0x5d, 0xf8, 0x12)

/* File:
 *      ihxrateadaptctl.h
 *
 * Description:
 *      Rate adaptation control interfaces
 */
DEFINE_GUID_ENUM(IID_IHXClientRateAdaptControl, 0x44f5ac8c, 0x654c, 0x414e, 0x9d, 
                 0x18, 0xe7, 0xa4, 0x80, 0x90, 0x70, 0x9)

/* File:
 *      ihxtranstime.h
 *
 * Description:
 *      Transport time interfaces
 */
DEFINE_GUID_ENUM(IID_IHXTransportTimeSink, 
0xdb838ab3, 0x4637, 0x41e0, 0xbc, 0x3f, 0xed, 0x3, 0xb6, 0xa6, 0x84, 0xc1)

DEFINE_GUID_ENUM(IID_IHXTransportTimeManager, 
0xd0a5ba01, 0xedfb, 0x4741, 0xb7, 0x9, 0x88, 0x4e, 0x68, 0x5d, 0x2d, 0x8)

/* File:
 *      ihx3gpp.h
 *
 * Description:
 *      Interfaces for 3GPP functionality
 */
DEFINE_GUID_ENUM(IID_IHX3gppNADU, 
0x8069baaf, 0x777a, 0x4cf0, 0x90, 0x3, 0xd2, 0x6d, 0x68, 0xb8, 0xd7, 0x86)

/* File:
 *      hxservnet.h
 *
 * Description:
 *      Interfaces for server-specific networking services.
 */

DEFINE_GUID_ENUM(IID_IHXLocalBoundNetServices, 
                 0x669b1aaa, 0xdda3, 0x4892, 0x8d, 0x58, 0x6d, 0xc, 0xd5, 0xea, 0xcb, 0x19)


/* File:
 *      hxprivstats.h
 *
 * Description:
 *      Private client stats functionality interfaces.
 */
DEFINE_GUID_ENUM(IID_IHXPrivateClientStats, 
0x2399cc75, 0x3c38, 0x4680, 0xac, 0xa5, 0xcd, 0x66, 0x3a, 0x64, 0x70, 0x1a)

#endif /* _HXPRIVATEIIDS_H_ */


