#ifndef __GMPC_LYRICS_H__
#define __GMPC_LYRICS_H__

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <glib.h>
#include <glib/gstdio.h>

#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xmlstring.h>

#include <curl/curl.h>

#include <libmpd/debug_printf.h>

#include <gmpc/plugin.h>
#include <gmpc/gmpc_easy_download.h>

/** 
 * We need gmpc's threading abstraction.
 */

#define PLUGIN_AUTH "GMPC+Lyrics+Plugin"
#define USER_AGENT "User-Agent: GmpcSoapLyrics/0.1"

typedef struct _post_message_struct {
	gchar *url;
	/* all necessary headers must be set here, should be set like this: 
	 * with add_post_header(&post_message, "Header: new_header"); 
	 */
	struct curl_slist *headers; 
	GString *body; /* this will be insterted as the body */
	GString *response; /* the response from the server will be put here */
	long	response_code; /* response code from the server will be put here */
} post_message;  

/* Lyrics plugin */
struct lyrics_api
{
  gchar *name;
  gchar *host; /* slightly different meaning for SOAP and normal, when soap it *must* be the full url */

  gboolean  soap; /* 0 to indicate using normal hid-search/retrieval and 1 to use soap api */

  gchar *search_full;
  gchar *search_title;

  gchar *lyrics_uri;

  gchar *(*get_id)(xmlDocPtr results_doc, gchar *artist, gchar *songtitle, int exact);
  gchar *(*get_lyrics)(gmpc_easy_download_struct *dl); /* should return the lyrics if availble or NULL else */
  int (*get_soap_message)(post_message* msg, gchar *artist, gchar *songtitle); /* just return 1 on success */
  gchar *(*get_soap_lyrics)(xmlDocPtr result, int exact); /* should return the lyrics if availble or NULL else */
  
};

void lyrics_init (void);
void lyrics_enable_toggle (GtkWidget *wid);
void lyrics_api_changed (GtkWidget *wid);
void lyrics_construct (GtkWidget *container);
void lyrics_destroy (GtkWidget *container);


/* post apis */
int do_post(post_message *msg);
void add_post_header(post_message *msg, gchar *header);
void init_post_message(post_message *msg); 
void free_post_message(post_message *msg);

/* XML Parsing */
xmlNodePtr get_node_by_name (xmlNodePtr node, xmlChar *name);

/* LeosLyrics API */
gchar *__leoslyrics_get_id (xmlDocPtr results_doc, gchar *artist, gchar *songtitle, int exact);
gchar *__leoslyrics_get_lyrics (gmpc_easy_download_struct *dl);

/* LyricTracker API */
gchar *__lyrictracker_get_id (xmlDocPtr results_doc, gchar *artist, gchar *songtitle, int exact);
gchar *__lyrictracker_get_lyrics (gmpc_easy_download_struct *dl);

/* LyricWiki API */
int __lyricwiki_get_soap_message(post_message * msg, gchar *artist, gchar *songtitle);
gchar *__lyricwiki_get_soap_lyrics(xmlDocPtr xml, int exact);

#endif
