/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2005 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvddesktop.cpp,v 1.1 2003/05/08 03:22:25 sander Exp $
*/


extern "C" {
#include <X11/Xlib.h>
#ifdef HAVE_DPMS
#include <X11/extensions/dpms.h>
#endif
}


#include <fx.h>
#include "dvddesktop.h"


FXScreenSaver::FXScreenSaver(FXApp * app){
  application=app;
  set=FALSE;
  }

FXScreenSaver::~FXScreenSaver(){
  restore();
  application=NULL;
  set=FALSE;
  }

void FXScreenSaver::disable(){
  Display* dpy = (Display*)application->getDisplay();
  XGetScreenSaver(dpy,&orig_timeout,&orig_interval,&orig_blanking,&orig_exposure);
  if (orig_timeout>0){
    XSetScreenSaver(dpy,0,orig_interval,orig_blanking,orig_exposure);
    set=TRUE;
    }
  }

FXbool FXScreenSaver::restore(){
  if (!set) return FALSE;
  Display* dpy = (Display*)application->getDisplay();
  XSetScreenSaver(dpy,orig_timeout,orig_interval,orig_blanking,orig_exposure);
  set=FALSE;
  return TRUE;
  }

void FXScreenSaver::update(){
  FXint t,i,b,e;
  if (set){ /// if we disable it...
    Display* dpy = (Display*)application->getDisplay();
    XGetScreenSaver(dpy,&t,&i,&b,&e);
    /// Disable if some roque app has turned it on again.
    if (t>0) XSetScreenSaver(dpy,0,i,b,e);
    }
  }


FXDPMS::FXDPMS(FXApp * app){
  application=app;
  enabled=FALSE;
  set=FALSE;
  }

FXDPMS::~FXDPMS(){
  restore();
  enabled=FALSE;
  set=FALSE;
  }

FXbool FXDPMS::isAvailable(){
#ifdef HAVE_DPMS
  FXint    d1;
  Display* dpy = (Display*)application->getDisplay();
  if ( DPMSQueryExtension(dpy,&d1,&d1) && DPMSCapable(dpy)) return TRUE;
#endif
  return FALSE;
  }


void FXDPMS::restore(){
#ifdef HAVE_DPMS
  Display* dpy = (Display*)application->getDisplay();
  if (set && enabled) DPMSEnable(dpy);
  set=FALSE;
  enabled=FALSE;
#endif
  }

void FXDPMS::disable(){
#ifdef HAVE_DPMS
  FXushort d2;

  Display* dpy = (Display*)application->getDisplay();
  if (isAvailable()) {
    DPMSInfo(dpy,&d2,&enabled);
    if (enabled) DPMSDisable(dpy);
    set=TRUE;
    }
#endif
  }

void FXDPMS::update(){
#ifdef HAVE_DPMS
  FXbool e;
  FXushort d2;
  Display* dpy = (Display*)application->getDisplay();
  if (set) {
    DPMSInfo(dpy,&d2,&e);
    if (e) DPMSDisable(dpy);
    }
#endif
  }
