#include <ctype.h>
#include <string.h>
#include <stdlib.h>

/*
 * This is a function from my mime library.  I imported it so that the cgiparse
 * library can compile and run without the need for all of mime.
 */
int ct_cmpct(const char *ct, const char *fct);

int
ct_cmpct(const char *ct, const char *fct)
{
	char *semicolon;

	while (isspace(*ct))
		ct++;

	if ((semicolon = strchr(ct, ';')) == NULL)
		semicolon = strchr(ct, '\x0');

	while (isspace(*(semicolon - 1)))
		semicolon--;

	if (strlen(fct) != semicolon - ct)
		return -1;

	return strncasecmp(ct, fct, semicolon - ct);
}
