/* matchbox-nest - a graphical wrapper around xnest
 *
 *  Copyright 2004 Matthew Allum
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

#include "fakedev.h"

static int
keys_xnest_connect(FakeApp *app)
{
  int trys = 10;

  do 
    {
      if (--trys < 0) return 0;

      sleep(1); /* Sleep for a second to give Xnest a chance to start */

      app->xnest_dpy = XOpenDisplay(app->xnest_dpy_name);
    }
  while ( app->xnest_dpy == NULL );

  return 1;
}

void 
keys_send_key(FakeApp *app, KeySym keysym, int key_direction)
{
  KeyCode character;

  character = XKeysymToKeycode(app->xnest_dpy, keysym);

  switch (key_direction)
    {
    case KEYDOWN:
      XTestFakeKeyEvent(app->xnest_dpy, (unsigned int) character, True, 0);
      break;
    case KEYUP:
      XTestFakeKeyEvent(app->xnest_dpy, (unsigned int) character, False, 0);
      break;
    case KEYUPDOWN:
      XTestFakeKeyEvent(app->xnest_dpy, (unsigned int) character, False, 0);
      XTestFakeKeyEvent(app->xnest_dpy, (unsigned int) character, True, 0);
      break;
    }

  /* Make sure the event gets sent */
  XFlush(app->xnest_dpy);

}

int
keys_init(FakeApp *app)
{
  int event, error;
  int major, minor;

  if (keys_xnest_connect(app))
    {
      if (!XTestQueryExtension(app->xnest_dpy, &event, &error, &major, &minor))
	{
	  fprintf(stderr, "XTest extension not supported on server \"%s\"\n.", DisplayString(app->xnest_dpy));
	  return 0;
	}

      return 1;

    }

  fprintf(stderr, "Failed to connect to Xnest Display\n");  

  return 0;
}
