#!/usr/bin/env python
# -*- coding: utf-8 -*-

# La premire ligne doit commencer par #! et contenir python.
# Elle sera adapte au systme de destination automatiquement

""" This is a part of Beremiz project.

    Post installation script for win32 system
    
    This script creat a shortcut for plcopeneditor.py in the desktop and the
    start menu, and remove them at the uninstallation
    
"""

import os
import sys

# Ce script sera aussi lanc lors de la dsinstallation.
# Pour n'excuter du code que lors de l'installation :
if sys.argv[1] == '-install':
    # On rcupre le dossier o mes fichiers seront installs (dossier o python est aussi install sous windows)
    python_path = sys.prefix
    # On rcupre le chemin de pythonw.exe (l'excutable python qui n'affiche pas de console).
    # Si vous voulez une console, remplacez pythonw.exe par python.exe
    pyw_path = os.path.abspath(os.path.join(python_path, 'pythonw.exe'))
    # On rcupre le dossier coincoin
    defeditor_dir = os.path.abspath(os.path.join(python_path,'LOLITech', 'defeditor'))
    
    # On rcupre les chemins de coincoin.py, et de coincoin.ico
    # (Ben oui, l'icone est au format ico, oubliez le svg, ici on en est encore  la prhistoire.
    # Heureusement que the GIMP sait faire la conversion !)
    ico_path = os.path.join(defeditor_dir, 'defeditor.ico')
    script_path = os.path.join(defeditor_dir, 'defeditor.py')
    
    # Cration des raccourcis
    # Pour chaque raccourci, on essaye de le faire pour tous les utilisateurs (Windows NT/2000/XP),
    # sinon on le fait pour l'utilisateur courant (Windows 95/98/ME)
    
    # Raccourcis du bureau
    # On essaye de trouver un bureau
    try:
        desktop_path = get_special_folder_path("CSIDL_COMMON_DESKTOPDIRECTORY")
    except OSError:
        desktop_path = get_special_folder_path("CSIDL_DESKTOPDIRECTORY")
    
    # On cr le raccourcis
    create_shortcut(pyw_path, # programme  lancer
                    "Editor", # Description
                    os.path.join(desktop_path, 'defeditor.lnk'),  # fichier du raccourcis (gardez le .lnk)
                    script_path, # Argument (script python)
                    defeditor_dir, # Dossier courant
                    ico_path # Fichier de l'icone
                    )
    # On va cafter au programme de dsinstallation qu'on a fait un fichier, pour qu'il soit supprim
    # lors de la dsinstallation
    file_created(os.path.join(desktop_path, 'defeditor.lnk'))
    
    # Raccourcis dans le menu dmarrer (idem qu'avant)
    try:
        start_path = get_special_folder_path("CSIDL_COMMON_PROGRAMS")
    except OSError:
        start_path = get_special_folder_path("CSIDL_PROGRAMS")
    
    

    # Cration du dossier dans le menu programme
    programs_path = os.path.join(start_path, "LOLITech")
    try :
        os.mkdir(programs_path)

    except OSError:

        pass
    directory_created(programs_path)
    
    create_shortcut(pyw_path, # Cible
                    "Editor", #Description
                    os.path.join(programs_path, 'defeditor.lnk'),  # Fichier
                    script_path, # Argument
                    defeditor_dir, # Dossier de travail
                    ico_path # Icone
                    )
    file_created(os.path.join(programs_path, 'defeditor.lnk'))
    
    # End (youpi-message)
    # Ce message sera affich (trs) furtivement dans l'installateur.
    # Vous pouvez vous en servir comme moyen de communication secret, c'est trs in.
    sys.stdout.write("Shortcuts created.")
    # Fin du bidule
    sys.exit()
