/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 *  util.h
 *  generic usefull stuff
 *
 */

#include<gtk/gtk.h>
#include "contact.h"
#include "service.h"
#include "account.h"
#include "chat_room.h"

extern GtkWidget *statuswindow;
gint clean_pid(void * dummy);
char * get_local_addresses();

enum
{
	TOKEN_NORMAL,
	TOKEN_HTTP,
	TOKEN_FTP,
	TOKEN_EMAIL,
	TOKEN_CUSTOM
	
};


gchar * linkify( gchar * input );

eb_local_account * find_suitable_local_account( eb_local_account * first,
											   gint second );
eb_account * can_offline_message( struct contact * con );

eb_account * find_suitable_remote_account( eb_account * first,
											struct contact * rest );
eb_account * find_suitable_file_transfer_account( eb_account * first,
		                                           struct contact * rest );
eb_chat_room * find_chat_room_by_id( gchar * id );
eb_chat_room * find_chat_room_by_name( gchar * name, gint service_id );
grouplist * find_grouplist_by_nick(gchar * nick);
grouplist * find_grouplist_by_name(gchar * name);
struct contact * find_contact_by_handle( gchar * handle );
struct contact * find_contact_by_nick( gchar * nick);
eb_account * find_account_by_handle( gchar * handle, gint type );
eb_account * find_account_by_handle_normalized( gchar * handle, gint type );
eb_local_account * find_local_account_by_handle( gchar * handle );
void strip_html(gchar * text);
void remove_account( eb_account * a );
void remove_contact( struct contact * c );
void remove_group( grouplist * g );
void add_group( gchar * name );
struct contact * add_new_contact( gchar * group, gchar * con, gint type );
void add_unknown( eb_account * ea );
void add_account( gchar * contact, eb_account * account );
void move_contact( gchar * group, struct contact * c);
void import_gaim_accounts();
void import_gnomeicu_accounts();
void invite_dialog( eb_local_account * ela, char * user, char * chat_room,
		                    void * id );
void make_safe_filename(gchar *buff, gchar *name);

#ifndef NAME_MAX
#define NAME_MAX 4096
#endif
