/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include "service.h"
#include "yahoo.h"
#include "icq.h"
#include "aim.h"
#include "msn.h"
#include "jabber.h"
#include "globals.h"
#include "account.h"

#ifdef HAVE_MIT_SAVER_EXTENSION
#include <X11/extensions/scrnsaver.h>
#endif /* HAVE_MIT_SAVER_EXTENSION */


static guint idle_timer;
static time_t lastsent = 0;
static int is_idle = 0;
static int scrnsaver_ext = 0;


/* Following chunk will be moved to a 'real' code file */
struct service eb_services[] = {
    { "AIM", AIM_PROTOCOL_ID, FALSE, TRUE, FALSE, NULL },
	{ "ICQ", ICQ_PROTOCOL_ID, TRUE, TRUE, FALSE, NULL},
    { "Yahoo", YAHOO_PROTOCOL_ID, TRUE, FALSE, FALSE,  NULL },
    { "MSN", MSN_PROTOCOL_ID, FALSE, FALSE, FALSE, NULL },
    { "Jabber", JABBER_PROTOCOL_ID, TRUE, TRUE, FALSE, NULL },
};

void services_init()
{
	eb_services[ICQ_SERVICE_ID].sc = icq_query_callbacks();
	eb_services[AIM_SERVICE_ID].sc = aim_query_callbacks();
	eb_services[YAHOO_SERVICE_ID].sc = yahoo_query_callbacks();
	eb_services[MSN_SERVICE_ID].sc =  eb_msn_query_callbacks();
	eb_services[JABBER_SERVICE_ID].sc =  eb_jabber_query_callbacks();
	add_idle_check();
}

gint get_service_id( gchar * servicename )
{
	int i;
	for (i=0; i < NUM_SERVICES; i++ )
	{
		if(strcmp(eb_services[i].name,servicename)==0)
		{
			return i;	
		}
	}
    printf("warning: unknown servicename %s\n", servicename);
	return -1;
}

gchar *get_service_name( gint service_id )
{
    int i;
#if 0
    for (i=0; i< NUM_SERVICES; i++)
    {
        if ( eb_services[i].protocol_id == service_id )
        {
            return eb_services[i].name;
        }
    }
#endif
	if(service_id < NUM_SERVICES)
		return eb_services[service_id].name;
    printf("warning: unknown service id: %d\n", service_id);
    return "unknown";
}

GList * get_service_list()
{
	GList * newlist = NULL;
	int i;
	for( i = 0; i < NUM_SERVICES; i++ )
	{
		newlist = g_list_append( newlist, eb_services[i].name );
	}
	return newlist;
}

void serv_touch_idle()
{
    /* Are we idle?  If so, not anymore */
    if (is_idle > 0) {
		GList * node;
        is_idle = 0;
		for(node = accounts; node; node = node->next )
		{
			if(((eb_local_account *)(node->data))->connected)
			{
				if(RUN_SERVICE(((eb_local_account*)(node->data)))->set_idle)
				{
					RUN_SERVICE(((eb_local_account*)node->data))->set_idle(
								 (eb_local_account*)node->data, 0);
				}
			}
		}
    }
    time(&lastsent);
}

static guint idle_time = 0;

static gint report_idle()
{
	GList * node;

	if (!is_idle)
		return FALSE;

	for(node = accounts; node; node = node->next )
	{
		if(((eb_local_account *)node->data)->connected)
		{
			if(RUN_SERVICE(((eb_local_account*)node->data))->set_idle)
			{
				RUN_SERVICE(((eb_local_account*)node->data))->set_idle(
						(eb_local_account*)node->data, idle_time);
			}
		}
	}
	return TRUE;
}

static gint check_idle()
{
	gint idle_reporter = -1;

#ifdef HAVE_MIT_SAVER_EXTENSION
	if (scrnsaver_ext) {
		static XScreenSaverInfo * mit_info = NULL;
		mit_info = XScreenSaverAllocInfo();
		XScreenSaverQueryInfo(gdk_display, DefaultRootWindow(gdk_display), mit_info);
		idle_time = mit_info->idle/1000;
		free(mit_info);
	} else
#endif
	{
    	time_t t;

    	if (is_idle)
        	return TRUE;
    	time(&t);
		
		idle_time = t - lastsent;
	}
	if ((idle_time >= 600) && do_send_idle_time) {
		if (is_idle == 0) {
			GList * node;
			idle_reporter = gtk_timeout_add(60000, (GtkFunction)report_idle, NULL);
			for(node = accounts; node; node = node->next )
			{
				if(((eb_local_account *)node->data)->connected)
				{
					if(RUN_SERVICE(((eb_local_account*)node->data))->set_idle)
					{
						RUN_SERVICE(((eb_local_account*)node->data))->set_idle(
								(eb_local_account*)node->data, idle_time);
					}
				}
			}
		}
		is_idle = 1;
	} else if ((idle_time < 600) && do_send_idle_time && (is_idle == 1)) {
		if (idle_reporter != -1)
			gtk_idle_remove(idle_reporter);
		serv_touch_idle();
	}
    return TRUE;

}

void add_idle_check()
{
	int eventnum, errornum;
	idle_timer = gtk_timeout_add(5000, (GtkFunction)check_idle, NULL);
	serv_touch_idle();
#ifdef HAVE_MIT_SAVER_EXTENSION
	if (XScreenSaverQueryExtension(gdk_display, &eventnum, &errornum)) {
		scrnsaver_ext = 1;
	}
#endif
}

void rename_nick_log(char *oldnick, char *newnick)
{
   gchar oldnicklog[255], newnicklog[255];
   strcpy(oldnicklog, config_dir);
   strcat(oldnicklog, "logs/");
   strcpy(newnicklog, oldnicklog);
   strcat(oldnicklog, oldnick);
   strcat(newnicklog, newnick);
   rename(oldnicklog, newnicklog);
   printf("Renamed log from %s to %s\n", oldnicklog, newnicklog);
}
     
