/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __DIALOG__
#define __DIALOG__
#include <gtk/gtk.h>

typedef struct _list_dialog_data {
	void (*callback)(char *value, void *data);
	void *data;
} list_dialog_data;

/*dialog.c*/
GtkWidget *eb_button(const char *text, int *value, GtkWidget *page);
void do_error_dialog(char *message, char *title);
void eb_icon(GdkWindow *);
void do_dialog( gchar * message, gchar * title, void (*action)(GtkWidget * widget, gpointer data), gpointer data );
void do_list_dialog( gchar * message, gchar * title, char **list, void (*action)(char * text, gpointer data), gpointer data );

/*prefs.c*/
void write_prefs();
void eb_read_prefs();
void build_prefs();

/*editcontacts.c*/
void eb_new_user();

/*progress_window.c*/
void progress_window_new( char * filename, unsigned long size );
void update_progress(unsigned long progress);
void progress_window_close();


#endif
