#!/bin/sh

# configuration options
prefix=/usr
incprefix=$prefix/include
batinc=$incprefix/bat

# start the uninstallation process
rm -f uninstall.log >/dev/null 2>&1

echo
echo "*** uninstalling bsd-airtools source-mods v0.2 ***"
echo "*** by h1kari - (c) 2001 Dachb0den Labs ***"
echo

echo -n "checking for host os... "

if (test $1); then
  hostos=$1
else
  hostos=`(uname -sr) 2>/dev/null`
fi

# set configuration options based on the os
case $hostos in
  "NetBSD"*)
    hostos="netbsd"; echo $hostos ;;
  "OpenBSD 2.9"*)
    hostos="openbsd-2.9"; echo $hostos ;;
  "OpenBSD 3.0"*)
    hostos="openbsd-3.0"; echo $hostos ;;
  "FreeBSD 4.4"*)
    hostos="freebsd-4.4"; echo $hostos ;;
  *)
    hostos="unsupported"; echo $hostos;
    echo
    echo "** unable to determine host os **"
    echo "the uninstallation script was either unable to determine your os, or "
    echo "your current os isn't supported. if your system is supported, try "
    echo "specifying it when running $0 <os>."
    echo
    exit 2 ;;
esac

echo -n "uninstalling common.h from $batinc... "
rm -f $batinc/common.h >>uninstall.log 2>&1
rmdir $batinc >>uninstall.log 2>&1
echo "done"

# patch sources
PATCHDIR=$PWD

# grab definitions for operating system
. $hostos/config.sh

echo -n "unpatching kernel sources... "
if(! patch -d /usr/src -R -p1 < $PATCHDIR/$hostos/kernel.diff >>uninstall.log 2>&1); then
  echo
  echo "** unable to unpatch kernel sources **"
  echo "the kernel patches did not reverse cleanly. please check the"
  echo "uninstall.log for errors."
  echo
  exit 2
fi
echo "done"

echo -n "unpatching $WICONF sources... "
if(! patch -d /usr/src -R -p1 < $PATCHDIR/$hostos/$WICONF.diff >>uninstall.log 2>&1); then
  echo
  echo "** unable to unpatch $WICONF sources **"
  echo "the $WICONF patches did not reverse cleanly. please check the "
  echo "uninstall.log for errors."
  echo
  exit 2
fi
echo "done"

# rebuild wiconfig
echo -n "rebuilding $WICONF... "
sh -c "(cd $WICONFPATH; $MAKECMD)" >>uninstall.log 2>&1
echo "done"

# inform user to rebuild kernel
echo
echo "** your system has been successfully unpatched for bsd-airtools **"
echo "you must now rebuild your kernel if you are currently running the"
echo "kernel source mods."
echo
