/*
 * prism2dump v0.01 [frames.h]
 * by h1kari - (c) Dachb0den Labs 2001
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * definitions
 */
#define SNAPLEN   4096
#define TOMS      256
#define PROTO_PRE "  "

/*
 * macros
 */
#ifdef __FreeBSD__
#define le16toh(x) (x)
#define le32toh(x) (x)
#else
#ifdef __OpenBSD__
#define le16toh(x) letoh16(x)
#define le32toh(x) letoh32(x)
#endif
#endif
#define MACIT(x) x[0], x[1], x[2], x[3], x[4], x[5]

/*
 * declarations
 */
int prism2, verbose;
char *device;
pcap_t *p;


/*
 * prism2dump.c
 */
void usage(char *);
int main(int, char **);
void startloop(void);

/*
 * misc.c
 */
void printsol(int);
void printeol(int);

/*
 * decode_80211.c
 */
void decode_80211(struct wi_rx_frame *);

/*
 * decode_data.c
 */
void decode_data(struct wi_rx_frame *, u_char *);

/*
 * decode_mgmt.c
 */
void decode_mgmt_asreq(struct wi_rx_frame *, u_char *);
void decode_mgmt_asresp(struct wi_rx_frame *, u_char *);
void decode_mgmt_reasreq(struct wi_rx_frame *, u_char *);
void decode_mgmt_reasresp(struct wi_rx_frame *, u_char *);
void decode_mgmt_probereq(struct wi_rx_frame *, u_char *);
void decode_mgmt_proberesp(struct wi_rx_frame *, u_char *);
void decode_mgmt_beacon(struct wi_rx_frame *, u_char *);
void decode_mgmt_atim(struct wi_rx_frame *, u_char *);
void decode_mgmt_disas(struct wi_rx_frame *, u_char *);
void decode_mgmt_auth(struct wi_rx_frame *, u_char *);
void decode_mgmt_deauth(struct wi_rx_frame *, u_char *);

/*
 * decode_ctl.c
 */
void decode_ctl_pspoll(struct wi_rx_frame *, u_char *);
void decode_ctl_rts(struct wi_rx_frame *, u_char *);
void decode_ctl_cfend(struct wi_rx_frame *, u_char *);
void decode_ctl_cfendcfack(struct wi_rx_frame *, u_char *);
void decode_ctl_cts(struct wi_rx_frame *, u_char *);
void decode_ctl_ack(struct wi_rx_frame *, u_char *);

/*
 * fields_80211.c
 */
void print_80211_status(u_int16_t);
void print_80211_addrs(u_int8_t *, u_int8_t *, u_int8_t *);
void print_80211_ts(u_int16_t, u_int16_t);
void print_80211_frame_ctl(u_int16_t);
void print_80211_id(u_int16_t);
void print_80211_seq_ctl(u_int16_t);
void print_80211_addr4(u_int8_t *);
void print_80211_dat_len(u_int16_t);

/*
 * fields_data.c
 */
void print_data_snap(u_int16_t *);
void print_data_type(u_int16_t);

/*
 * fields_mgmt.c
 */
void print_mgmt_algo(u_int16_t);
void print_mgmt_seq(u_int16_t);
void print_mgmt_interval(u_int16_t);
void print_mgmt_capinfo(u_int16_t);
void print_mgmt_currap(u_int8_t *);
void print_mgmt_reason(u_int16_t);
void print_mgmt_aid(u_int16_t);
void print_mgmt_status(u_int16_t);
void print_mgmt_ts(u_int32_t, u_int32_t);
void print_mgmt_var(u_char *, int, u_int16_t, u_int8_t *, int);
void print_mgmt_var_ssid(u_char *, u_int8_t);
void print_mgmt_var_srates(u_char *data, u_int8_t);
void print_mgmt_var_fh(u_char *data, u_int8_t);
void print_mgmt_var_ds(u_char *data, u_int8_t);
void print_mgmt_var_cf(u_char *data, u_int8_t);
void print_mgmt_var_ibss(u_char *data, u_int8_t);
void print_mgmt_var_tim(u_char *data, u_int8_t);
void print_mgmt_var_chal(u_char *data, u_int8_t);
