/*
 * prism2dump v0.01 [decode_mgmt.c]
 * by h1kari - (c) Dachb0den Labs 2001
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/types.h>

#include <pcap.h>

#include "frames.h"
#include "prism2dump.h"


#define ASREQ_VAR_LEN 2
void
decode_mgmt_asreq(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[ASREQ_VAR_LEN] = { WI_VAR_SSID, WI_VAR_SRATES };
  struct wi_mgmt_asreq_hdr *wi_asreq_h;

  wi_asreq_h = (struct wi_mgmt_asreq_hdr *)data;

  printsol(1);
  printf("** mgmt-asreq ** ");

  print_mgmt_capinfo(wi_asreq_h->wi_capinfo);
  print_mgmt_interval(wi_asreq_h->wi_interval);

  printeol(1);

  print_mgmt_var(data, sizeof(struct wi_mgmt_asreq_hdr), wi_h->wi_dat_len,
   var, ASREQ_VAR_LEN);

  return;
}

#define ASRESP_VAR_LEN 1
void
decode_mgmt_asresp(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[ASRESP_VAR_LEN] = { WI_VAR_SRATES };
  struct wi_mgmt_asresp_hdr *wi_asresp_h;

  wi_asresp_h = (struct wi_mgmt_asresp_hdr *)data;

  printsol(1);
  printf("** mgmt-asresp ** ");

  print_mgmt_capinfo(wi_asresp_h->wi_capinfo);
  print_mgmt_status(wi_asresp_h->wi_status);
  print_mgmt_aid(wi_asresp_h->wi_aid);

  printeol(1);

  print_mgmt_var(data, sizeof(struct wi_mgmt_asresp_hdr), wi_h->wi_dat_len,
   var, ASRESP_VAR_LEN);

  return;
}

#define REASREQ_VAR_LEN 2
void
decode_mgmt_reasreq(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[REASREQ_VAR_LEN] = { WI_VAR_SSID, WI_VAR_SRATES };
  struct wi_mgmt_reasreq_hdr *wi_reasreq_h;

  wi_reasreq_h = (struct wi_mgmt_reasreq_hdr *)data;

  printsol(1);
  printf("** mgmt-reasreq ** ");

  print_mgmt_capinfo(wi_reasreq_h->wi_capinfo);
  print_mgmt_interval(wi_reasreq_h->wi_interval);
  print_mgmt_currap(wi_reasreq_h->wi_currap);

  printeol(1);

  print_mgmt_var(data, sizeof(struct wi_mgmt_reasreq_hdr), wi_h->wi_dat_len,
   var, REASREQ_VAR_LEN);

  return;
}

#define REASRESP_VAR_LEN 1
void
decode_mgmt_reasresp(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[REASRESP_VAR_LEN] = { WI_VAR_SRATES };
  struct wi_mgmt_reasresp_hdr *wi_reasresp_h;

  wi_reasresp_h = (struct wi_mgmt_reasresp_hdr *)data;

  printsol(1);
  printf("** mgmt-reasresp ** ");

  print_mgmt_capinfo(wi_reasresp_h->wi_capinfo);
  print_mgmt_status(wi_reasresp_h->wi_status);
  print_mgmt_aid(wi_reasresp_h->wi_aid);

  printeol(1);

  print_mgmt_var(data, sizeof(struct wi_mgmt_reasresp_hdr), wi_h->wi_dat_len,
   var, REASREQ_VAR_LEN);

  return;
}

#define PROBEREQ_VAR_LEN 2
void
decode_mgmt_probereq(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[PROBEREQ_VAR_LEN] = { WI_VAR_SSID, WI_VAR_SRATES };
 
  printsol(1);
  printf("** mgmt-probereq **");
  printeol(1);

  print_mgmt_var(data, 0, wi_h->wi_dat_len, var, PROBEREQ_VAR_LEN);

  return;
}

#define PROBERESP_VAR_LEN 6
void
decode_mgmt_proberesp(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[PROBERESP_VAR_LEN] = { WI_VAR_SSID, WI_VAR_SRATES, WI_VAR_FH,
   WI_VAR_DS, WI_VAR_CF, WI_VAR_IBSS };
  struct wi_mgmt_proberesp_hdr *wi_proberesp_h;

  wi_proberesp_h = (struct wi_mgmt_proberesp_hdr *)data;

  printsol(1);
  printf("** mgmt-proberesp ** ");

  print_mgmt_ts(wi_proberesp_h->wi_ts0, wi_proberesp_h->wi_ts1);
  print_mgmt_interval(wi_proberesp_h->wi_interval);
  print_mgmt_capinfo(wi_proberesp_h->wi_capinfo);

  printeol(1);

  print_mgmt_var(data, sizeof(struct wi_mgmt_proberesp_hdr), wi_h->wi_dat_len,
   var, PROBERESP_VAR_LEN); 

  return;
}

#define BEACON_VAR_LEN 7
void
decode_mgmt_beacon(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[BEACON_VAR_LEN] = { WI_VAR_SSID, WI_VAR_SRATES, WI_VAR_FH,
   WI_VAR_DS, WI_VAR_CF, WI_VAR_IBSS, WI_VAR_TIM };
  struct wi_mgmt_beacon_hdr *wi_beacon_h;

  wi_beacon_h = (struct wi_mgmt_beacon_hdr *)data;

  wi_beacon_h->wi_ts0 = le32toh(wi_beacon_h->wi_ts0);
  wi_beacon_h->wi_ts1 = le32toh(wi_beacon_h->wi_ts1);
  wi_beacon_h->wi_interval = le16toh(wi_beacon_h->wi_interval);
  wi_beacon_h->wi_capinfo = le16toh(wi_beacon_h->wi_capinfo);

  printsol(1);
  printf("** mgmt-beacon ** ");

  print_mgmt_ts(wi_beacon_h->wi_ts0, wi_beacon_h->wi_ts1);
  print_mgmt_interval(wi_beacon_h->wi_interval);
  print_mgmt_capinfo(wi_beacon_h->wi_capinfo);

  printeol(1);

  print_mgmt_var(data, sizeof(struct wi_mgmt_beacon_hdr), wi_h->wi_dat_len,
   var, BEACON_VAR_LEN);

  return;
}

void
decode_mgmt_atim(struct wi_rx_frame *wi_h, u_char *data)
{
  printsol(1);
  printf("** mgmt-atim **");
  printeol(1);

  return;
}

void
decode_mgmt_disas(struct wi_rx_frame *wi_h, u_char *data)
{
  struct wi_mgmt_disas_hdr *wi_disas_h;

  wi_disas_h = (struct wi_mgmt_disas_hdr *)data;

  printsol(1);
  printf("** mgmt-disas ** ");

  print_mgmt_reason(wi_disas_h->wi_reason);

  printeol(1);

  return;
}

#define AUTH_VAR_LEN 1
void
decode_mgmt_auth(struct wi_rx_frame *wi_h, u_char *data)
{
  u_int8_t var[AUTH_VAR_LEN] = { WI_VAR_CHAL };
  struct wi_mgmt_auth_hdr *wi_auth_h;

  wi_auth_h = (struct wi_mgmt_auth_hdr *)data;

  printsol(1);
  printf("** mgmt-auth ** ");

  print_mgmt_algo(wi_auth_h->wi_algo);
  print_mgmt_seq(wi_auth_h->wi_seq);
  print_mgmt_status(wi_auth_h->wi_status);

  printeol(1);

  print_mgmt_var(data, sizeof(struct wi_mgmt_auth_hdr), wi_h->wi_dat_len,
   var, AUTH_VAR_LEN);

  return;
}

void
decode_mgmt_deauth(struct wi_rx_frame *wi_h, u_char *data)
{
  struct wi_mgmt_deauth_hdr *wi_deauth_h;

  wi_deauth_h = (struct wi_mgmt_deauth_hdr *)data;

  printsol(1);
  printf("** mgmt-deauth ** ");

  print_mgmt_reason(wi_deauth_h->wi_reason);

  printeol(1);

  return;
}
