/*
 * dwepcrack v0.4 [dwepcrack.h]
 * by h1kari - (c) Dachb0den Labs 2002
 */

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <sys/types.h>
#include <pcap.h>

#include <bat/common.h>

/*
 * definitions
 */
#define LOW_KEY_SIZE  5
#define HIGH_KEY_SIZE 13
#define WEP_KEY_KEYS  4
#define WEP_KEY_SIZE  (strong ? HIGH_KEY_SIZE : LOW_KEY_SIZE)
#define WEP_KEY_STORE (LOW_KEY_SIZE * WEP_KEY_KEYS)
#define WEP_KEYS_SIZE (strong ? HIGH_KEY_SIZE : WEP_KEY_STORE)
#define IV_SIZE       3
#define SNAP_SIZE     8
#define IV_OFF        60
#define MIN_PKT_SIZE  20
#define MAX_PKT_SIZE  2304
#define PROB_THRESH   4 /* probability threshold */
#define DEFAULT_SNAP  { 0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00 }
#define SAMPLES_SIZE  { 768, 131328, 197376, 197120, 328703, /* 40-bit */ \
                        328192, 459520, 459264, 590592, \
                        590336, 721664, 721408, 852736 } /* 104-bit */

#define BANNER \
 "* dwepcrack v0.4 by h1kari <h1kari@dachb0den.com> *\n" \
 "* Copyright (c) Dachb0den Labs 2002 [http://dachb0den.com] *\n"

#define PROGRESS      "progress: "
#define PROG_OFFSET   13 /* lucky number */

/*
 * macros
 */
#ifdef __FreeBSD__
#define htole16(x) (x)
#define le16toh(x) (x)
#define le8toh(x)  (x)
#else
#ifdef __OpenBSD__
#define le16toh(x) letoh16(x)
#define le8toh(x)  letoh8(x)
#endif
#endif

#ifndef MAX
#define MAX(x, y) ((x) > (y) ? (x) : (y))
#endif
#ifndef MIN
#define MIN(x, y) ((x) < (y) ? (x) : (y))
#endif
#ifndef SWAP
#define SWAP(x, y) { if(x != y) x ^= y ^= x ^= y; }
#endif
#ifndef AMOD /* absolute value modulus, so we don't reference neg values */
#define AMOD(x, y) ((x) % (y) < 0 ? ((x) % (y)) + (y) : (x) % (y))
#endif

/*
 * declarations
 */
int jobs, brute, entire, weakksa, strong, fudge, children;
int max_lines, max_cols; 
int small_len, verify_len;
u_char small_pkt[MAX_PKT_SIZE], verify_pkt[MAX_PKT_SIZE];
pcap_t *p;

/*
 * dwepcrack.c
 */
void usage(char *);
int main(int, char **);
void chld_handler(int);

/*
 * brute.c
 */
void brutecrack(char *);
int try_optimized_keys(int, int);
int try_entire_keys(int, int);
int try_recurs_keys(int, u_char *);

/*
 * weakksa.c
 */
void weakksacrack(char *);
int grindsamples(int, u_char *);
int grindvotes(int, u_char *, int *, int, int, int);
void grindforkvotes(int, u_char *, int *, int);
u_char reversekey(u_char, int, int, u_char *);

/*
 * wordfile.c
 */
void wordcrack(char *, char *);
int try_wordfile_keys(FILE *, int, int, int);

/*
 * wep.c
 */
void wep_init(u_char *, int, int);
int wep_try_key(u_char *, int, int);
int wep_try_verify_key(u_char *, int, u_char *, int);
void wep_seedkeygen40(int, u_char *);
void wep_keygen40(char *, u_char *);
void wep_keygen104(char *, u_char *);

/*
 * misc.c
 */
u_int bufcrc(u_char *, int);
void getscrmaxyx(void);
int getsmallpkt(char *);
void report_crack(u_char *, int, int);
