static char* sccs_main_c = "%W%%G%"; 

/* 
 * Copyright 1992 Bruce. R. Ingram.
 * University of Kent at Canterbury, UK
 *
 * Permission  to   use, copy, modify  and  distribute  this  software  and its
 * documentation   for any purpose is hereby granted without fee, provided that
 * the   above  copyright  notice  appear  in  all  copies  and  that both that
 * copyright  notice   and  this   permission   notice  appear  in   supporting
 * documentation,  and  that  the name  of the author and The University  of
 * Kent  at  Canterbury  not be  used in advertising or publicity pertaining to
 * distribution  of  the  software  without specific, written prior permission.
 * The   author  and   The   University   of   Kent at   Canterbury   make  no
 * representations  about  the  suitability  of this  software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * THE   AUTHOR  AND  THE  UNIVERSITY  OF KENT  AT   CANTERBURY  DISCLAIMS ALL
 * WARRANTIES  WITH  REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED  WARRANTIES
 * OF   MERCHANTABILITY  AND  FITNESS,  IN NO  EVENT  SHALL THE AUTHOR  OR THE
 * UNIVERSITY  OF KENT  AT  CANTERBURY  BE LIABLE FOR ANY SPECIAL, INDIRECT  OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF USE,
 * DATA  OR  PROFITS,  WHETHER  IN  AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:
 *
 * Mr  B. R. Ingram email bri@ukc.ac.uk
*/

#include "gen.h"
#include "widgets.h"


/*  Forward  references  */

extern	void	GetPath PROTO((char *));
extern	void	PositionButtons PROTO((int,int)), ManageButtons();
extern  void    set_popup PROTO((Widget,XEvent *,String *,Cardinal *));
extern	void	delay PROTO((Widget,XEvent *,String *,Cardinal *));
extern	void	Quit PROTO((Widget,XtPointer,XtPointer));
static	void	AddResource PROTO((char *, char *, int));
extern	int	ProcessFile PROTO((Info*, char*));

#include "trans.h"

/*
	We set various default resources for the various widgets.
*/
String fallback_resources[] = {
"*borderColor:		black",
"*box.background:	gray",
NULL,
};


/*
	We store our application's resources in a structure of 
	the following type.
*/
typedef struct
{
	int	button_w;
	int	button_h;
	int 	no_of_cols;
	char	*icon_file;
	char	*help_file;
	char	*icon_dirs;
	Boolean	default_buttons;
} AppData, *AppDataPtr;


/* The description of our application's resources. */
static XtResource resources[] = {
	{ "button_w", "Button_w", XtRInt, sizeof (int),
	  XtOffset(AppDataPtr, button_w), XtRString, "75" },
	{ "button_h", "Button_h", XtRInt, sizeof (int),
	  XtOffset(AppDataPtr, button_h), XtRString, "60" },
	{ "no_of_cols", "No_of_cols",XtRInt,sizeof (int),
	  XtOffset(AppDataPtr,no_of_cols),XtRString,"18" },
	{ "icon_file", "Icon_file", XtRString, sizeof(char *),
	  XtOffset(AppDataPtr,icon_file),XtRString,"./.briconsrc" },
	{ "help_file", "Help_file", XtRString, sizeof(char *),
	  XtOffset(AppDataPtr,help_file),XtRString, "bricons.txt" },
	{ "icon_dirs", "Icon_dis", XtRString, sizeof(char *),
	  XtOffset(AppDataPtr,icon_dirs), XtRString, "" },
	{ "default_buttons", "Default_buttons", XtRBoolean, sizeof(Boolean),
	XtOffset(AppDataPtr, default_buttons),XtRString,"True" },

};

/* Reading command line options. */
XrmOptionDescRec options[] = {
	{ "-bw", "*button_w", XrmoptionSepArg, NULL },
	{ "-bh", "*button_h", XrmoptionSepArg, NULL },
	{ "-col", "*no_of_cols", XrmoptionSepArg, NULL },
	{ "-file", "*icon_file", XrmoptionSepArg, NULL },
	{ "-help", "*help_file", XrmoptionSepArg, NULL },
	{ "-bmdir", "*icon_dirs", XrmoptionSepArg, NULL },
	{ "-default", "default_buttons", XrmoptionSepArg, NULL }
};


XtAppContext    app_context;

int 
main(argc,argv)
unsigned int argc;
char **argv;
{
	int		string_len = 0;
	char		bm_dirs[MAXPATHLEN];
	char		*editor_type = NULL;
	Boolean		default_editor = False;
	Info		*data;	
	AppData		Rdata;

	/* create a shell widget for this application */
	toplevel = XtVaAppInitialize(
                &app_context,           /* Application context */
                "Xbricons",             /* Application class name */
                options, 		/* Command line option list */
		XtNumber(options),  
                &argc, argv,            /* Command line args */
		/*fallback_resources,  	 use fallback_resources or */
		NULL,		 	/* app_defaults file */
                NULL);			/* terminate varargs list */	

	/* Retrieve the application resources */
	XtVaGetApplicationResources(toplevel,&Rdata,resources,
			XtNumber(resources),NULL);

	if(strlen(Rdata.icon_dirs) == 0)
	{
		(void)getcwd(bm_dirs, MAXPATHLEN);
		AddResource(argv[0], bm_dirs, True);
	}
	else
		AddResource(argv[0], Rdata.icon_dirs, False); 

	/* add the menu actions to the global action list */
	XtAppAddActions(app_context,(XtActionList) menu_actions,
				XtNumber(menu_actions));

	/* create a form widget which is used to hold all the buttons */
	box = XtVaCreateManagedWidget("box",	/* widget name */
		formWidgetClass,		/* widget class */
		toplevel,			/* parent widget */
		NULL);				/* terminate varargs list */

/*
	allocate some memory for data structure holding number of buttons,
	the name of the icon file etc.
*/
	data = (struct info *) malloc(sizeof(struct info));
	if(data == NULL)
	{
		(void) fprintf(stderr,"%s: out of memory when creating Info data structure. In function main\n",argv[0]);
		exit(1);
	}	

	/* find out what editor the user is using */
	editor_type = getenv("EDITOR");
	if(!editor_type)
		default_editor = True;
	else if(strcmp(editor_type, "vi") == 0)
		default_editor = True;
	if(default_editor)
	{
		if((data->editor = malloc(strlen(EDITOR) + 4)) == NULL)
		{
			fprintf(stderr,"%s: malloc out of memory\n",argv[0]);
			exit(1);
		}
		strcpy(data->editor, EDITOR);
		strcat(data->editor, "vi ");
	}
	else
	{
		if((data->editor = malloc(strlen(editor_type) + 2)) == NULL)
		{
			fprintf(stderr,"%s: malloc out of memory\n",argv[0]);
			exit(1);
		}
		strcpy(data->editor, editor_type);
		strcat(data->editor, " ");
	}	
			

	string_len = 0;
	string_len = strlen(Rdata.icon_file);
	if((data->icon_file = malloc(strlen(Rdata.icon_file) +1)) == NULL)
	{
		(void) fprintf(stderr,"%s: out of memory reading icon file name.  In function main\n",argv[0]);
		exit(1);
	}
	strcpy(data->icon_file,Rdata.icon_file);

	string_len = 0;
	if((data->help_file = malloc(strlen(Rdata.help_file) +1)) == NULL)
	{
		(void) fprintf(stderr,"%s: out of memory reading icon file name.  In function main\n",argv[0]);
		exit(1);
	}
	strcpy(data->help_file,Rdata.help_file);

	data->button_w = Rdata.button_w;
	data->button_h = Rdata.button_h;
	data->no_of_columns = Rdata.no_of_cols;
	data->default_buttons = Rdata.default_buttons;

	/* read contents of icon file & create buttons */
	data->no_of_buttons = ProcessFile(data, argv[0]);

	/* position buttons according to number of columns */
	PositionButtons(data->no_of_buttons, data->no_of_columns); 

	ManageButtons(); 

	/* create windows for widgets and map them. */
	XtRealizeWidget(toplevel);

	/* loop for events */
	XtAppMainLoop(app_context);
	return(0);
}



static	void
AddResource(prog_name, bmap_dirs, default_bm)
char *prog_name;
char	*bmap_dirs;
Boolean	default_bm;
{
	int		string_len, len;
	char		*bitmap_dir;	
	char		tmp_string[300];
	char		*res_name_ptr;
	char		current_dir[MAXPATHLEN];
	char		*dummy;
	XrmDatabase	resource_db;
	XrmDatabase	*dbPtr;
	XrmValue	value;
	XrmValue	*vPtr;
	Bool		found;

	resource_db = XtDatabase(XtDisplay(toplevel));


	string_len = strlen(RESOURCE_NAME);
	string_len += strlen(RESOURCE_VALUE);
	string_len += strlen(bmap_dirs);
	res_name_ptr = malloc((string_len) + 1);
	if(res_name_ptr == NULL)
	{
		(void) fprintf(stderr,"\nOut of memory error\n");
		exit(1);
	}

	(void) sprintf(tmp_string,"%s.bitmapFilePath",prog_name);
	found = XrmGetResource(resource_db, tmp_string, 
			"Xbricons.BitmapFilePath", &dummy, &value);
	dbPtr = &resource_db;
	vPtr = &value;
	if(!found)
	{
		strcpy(res_name_ptr,RESOURCE_NAME);
		strcat(res_name_ptr,bmap_dirs);
		if(default_bm)
			strcat(res_name_ptr,RESOURCE_VALUE);
		(void) fprintf(stderr,"\n.bitmapFilePath not defined in resource file");
		(void) fprintf(stderr,"\nAdding default: %s\n",res_name_ptr);
		XrmPutLineResource(dbPtr, res_name_ptr); 
	}
	else
	{
		len  = strlen(vPtr->addr);
		len += strlen(bmap_dirs);
		len += strlen(RESOURCE_NAME);
		len += strlen(RESOURCE_VALUE);
		bitmap_dir = malloc(len + 4);
		if(bitmap_dir == NULL)
		{
			(void) fprintf(stderr,"\nOut of memory error\n");
			exit(1);
		}
		strcpy(bitmap_dir, RESOURCE_NAME);
		strcat(bitmap_dir,vPtr->addr);
		strcat(bitmap_dir,":");
		strcat(bitmap_dir, bmap_dirs);
		strcat(bitmap_dir, RESOURCE_VALUE);
		XrmPutLineResource(dbPtr, bitmap_dir); 
	}
}
