static char* sccs_buttons_c = "%W%%G%";

#include "gen.h"
#include "widgets.h"


extern void	CreateSubButton PROTO((Info*, int, int, char*));
extern	void	CreateMainMenuButton PROTO((Info*, int, int, char*, char*));
static	void	CreateDefaultSubButton PROTO((Info*, int, char*, int));
extern  void    Quit PROTO((Widget,XtPointer,XtPointer)),
		SingleAction PROTO((Widget,XtPointer,XtPointer)),
		MultiAction PROTO((Widget,XtPointer,XtPointer)),
                ReadALine PROTO((FILE*,char **)),
                Source PROTO((Widget,XtPointer,XtPointer));
extern  void    set_popup PROTO((Widget,XEvent *,String *,Cardinal *));
extern	void	delay PROTO((Widget,XEvent *,String *,Cardinal *));

static  void    SetButton PROTO((Info*, int,char *,int));
static  void    ErrorMessage PROTO((int, char*, char*));
static  void    SetSubMenuButton PROTO((Info*, int, char *, int));
static	void	CreatePopupShell PROTO((int));
extern	void	CreateSubMenuButton PROTO((Info*, int, char *, int, char*));
extern	void	DefaultButtons PROTO((Info *,int));

#include "trans.h"


extern void
CreateSubButton(data, button_no, is_icon, label)
Info	*data;
int		button_no;
int		is_icon;
char	*label;
{
	char	w_buffer[80];
	char	ptrans[250];

	/* 
		create translations for the button that 
		pops up the sub menu
	*/
	(void) sprintf(ptrans, pb_Trans, button_no, popup_menu_name);

	/* create main menu button that will popup sub menu */
	(void) sprintf(w_buffer, "action%d", button_no);
	action[button_no] = XtVaCreateWidget(
			w_buffer,
			commandWidgetClass,
			box,
			NULL);

	XtVaSetValues(action[button_no],
			XtNtranslations,
			XtParseTranslationTable(ptrans),
			NULL);

	SetButton(data, is_icon, label, button_no);
	CreatePopupShell(button_no);
}


extern void
CreateMainMenuButton(data, button_no, is_icon, label, command)
Info	*data;
int	button_no;
int	is_icon;
char	*label;
char	*command;
{
		char	w_buffer[80];

		(void) sprintf(w_buffer, "action%d", button_no);

		action[button_no] = XtVaCreateWidget(
				w_buffer, 	     /* widget name */	
				commandWidgetClass,  /* widget class */
				box,	            /* parent widget */
				NULL);	   /* terminate varargs list */

		SetButton(data, is_icon, label, button_no);

		/* add callback for this button */
		if((is_icon == TEXT) || (is_icon == ICON) ||
			(is_icon == PIXMAP))
			XtAddCallback(action[button_no],XtNcallback,
					SingleAction,command);
		else
			XtAddCallback(action[button_no],XtNcallback,
					MultiAction,command);
}

static	void
SetButton(data, is_icon, icon, button_num)
Info	*data;
int	is_icon;
char	*icon;
int	button_num;
{
	int             screen;
	int             ErrorStatus;
	Display*        display;
	XpmAttributes   attributes;
	Pixmap          mask;

	/* if button title is a string then */
	if((is_icon == TEXT) || (is_icon == TEXTPLUS))
	{
		XtVaSetValues(
			action[button_num],
			XtNwidth,
			data->button_w,
			XtNheight,
			data->button_h,
			XtNlabel,
			icon,	/* button title */
			NULL);
	}
	/* if button title is a bitmap then */
	if((is_icon == ICON) || (is_icon == ICONPLUS))	
	{
		XtVaSetValues(
			action[button_num],
			XtNwidth,
			data->button_w,
			XtNheight,
			data->button_h,
			XtVaTypedArg,
			XtNbitmap,
			XtRString,
			icon,	/* button title (bitmap) */
			strlen(icon) +1,
			NULL);
	}
        if((is_icon == PIXMAP) || (is_icon == PIXMAPPLUS))      
        {
                display = XtDisplay(action[button_num]);
                screen = XRootWindowOfScreen(XtScreen(action[button_num]));
                c_pix.attributes.valuemask = XpmReturnExtensions;

                ErrorStatus = XpmReadFileToPixmap(
                        display,
                        screen,
                        icon, &c_pix.pixmap, &c_pix.mask, 
                        &c_pix.attributes);

                ErrorMessage(ErrorStatus, "Read", icon);
                if(ErrorStatus == XpmFileInvalid)
                {
                        if(c_pix.pixmap)
                                XFreePixmap(display, c_pix.pixmap);
                        if(c_pix.mask)
                                XFreePixmap(display, c_pix.mask);
                        XpmFreeAttributes(&c_pix.attributes);
                }
                if(ErrorStatus != XpmSuccess)
                {
                        XtVaSetValues(
                                action[button_num],
                                XtNlabel, icon,
                                NULL);
                }
                else
                {
                        XtVaSetValues(
                                action[button_num],
				XtNwidth,
				data->button_w,
				XtNheight,
				data->button_h,
				XtNbitmap,
				c_pix.pixmap,
				NULL);
                }
        }
}

static	void
SetSubMenuButton(data, is_icon,icon,button_num)
Info	*data;
int	is_icon;
char	*icon;
int	button_num;
{
	int             screen;
	int             ErrorStatus;
	Display*        display;
	XpmAttributes   attributes;
	Pixmap          mask;

	/* if button title is a string then */
	if((is_icon == TEXT) || (is_icon == TEXTPLUS))
	{
		XtVaSetValues(
			sub_action[button_num],
			XtNwidth,
			data->button_w,
			XtNheight,
			data->button_h,
			XtNlabel,
			icon,	/* button title */
			NULL);
	}
	/* if button title is a bitmap then */
	if((is_icon == ICON) || (is_icon == ICONPLUS))	
	{
		XtVaSetValues(
			sub_action[button_num],
			XtNwidth,
			data->button_w,
			XtNheight,
			data->button_h,
			XtVaTypedArg,
			XtNbitmap,
			XtRString,
			icon,	/* button title (bitmap) */
			strlen(icon) +1,
			NULL);
	}
        if((is_icon == PIXMAP) || (is_icon == PIXMAPPLUS))      
        {
                display = XtDisplay(action[button_num]);
                screen = XRootWindowOfScreen(XtScreen(action[button_num]));
                c_pix.attributes.valuemask = XpmReturnExtensions;

                ErrorStatus = XpmReadFileToPixmap(
                        display,
                        screen,
                        icon, &c_pix.pixmap, &c_pix.mask, 
                        &c_pix.attributes);

                ErrorMessage(ErrorStatus, "Read", icon);
                if(ErrorStatus == XpmFileInvalid)
                {
                        if(c_pix.pixmap)
                                XFreePixmap(display, c_pix.pixmap);
                        if(c_pix.mask)
                                XFreePixmap(display, c_pix.mask);
                        XpmFreeAttributes(&c_pix.attributes);
                }
                if(ErrorStatus != XpmSuccess)
                {
                        XtVaSetValues(
                                sub_action[button_num],
                                XtNlabel, icon,
                                NULL);
                }
                else
                {
                        XtVaSetValues(
                                sub_action[button_num],
				XtNwidth,
				data->button_w,
				XtNheight,
				data->button_h,
				XtNbitmap,
				c_pix.pixmap,
				NULL);
                }
        }
	if(button_num > 0)
		XtVaSetValues(sub_action[button_num], XtNfromVert,
				sub_action[button_num - 1],NULL);
}

/*
	The function PositionButtons places each button next to the 
	previous button one until the number of buttons equals the 
	number of columns.  Then a new row is started.
*/
extern void
PositionButtons(i,columns)
int	i;
int	columns;
{
	int	button_no;
	int	position = 0;

	button_no = 1;
	while((button_no < columns) && (button_no <= i))
	{
		XtVaSetValues(action[button_no],
			XtNfromHoriz,action[button_no - 1], NULL);
		button_no++;
	}
	position = columns;
	while(button_no <= i)
	{
		if(position == columns)
		{
			XtVaSetValues(action[button_no],
				XtNfromVert,action[button_no - columns],NULL);
			position = 0;
		}
		else
		{
			XtVaSetValues(action[button_no],
				XtNfromVert,action[button_no - columns],NULL);
			XtVaSetValues(action[button_no],
				XtNfromHoriz,action[button_no -1],NULL);
		}
		position++;
		button_no++;
	}
}

/*
	Once all the buttons have been created then make sure they are 
	managed.
*/
extern void
ManageButtons()
{
	WidgetList      w_list;
	Cardinal        num_childern, i;

	XtVaGetValues(box,
		XtNchildren,
		&w_list,
		XtNnumChildren,
		&num_childern,
		NULL);

	for(i = 0; i < num_childern; i++)
		XtManageChild(w_list[i]);
}

static	void
CreatePopupShell(shell_no)
int	shell_no;
{

	popup_shell = XtCreatePopupShell(
			"popup_menu",
			overrideShellWidgetClass,
			action[shell_no],
			NULL,
			0);

	XtVaSetValues(popup_shell,
			XtNtranslations,
			XtParseTranslationTable(pm_Trans),
			NULL);

	popup_layout = XtCreateManagedWidget(
			"popup_layout",
			formWidgetClass,
			popup_shell,
			NULL,
			0);
}

static	void
CreateDefaultSubButton(data, key_word, button_name, button_num)
Info	*data;
int     key_word;
char    *button_name;
int     button_num;
{
        char    w_buffer[80];

        (void) sprintf(w_buffer,"sub_action%d",button_num);
        sub_action[button_num] = XtVaCreateManagedWidget(
                        w_buffer,
                        menuButtonWidgetClass,
                        popup_layout,
                        NULL);

        SetSubMenuButton(data, key_word, button_name, button_num); 
}

extern	void
CreateSubMenuButton(data, key_word, button_name, button_num, command)
Info	*data;
int	key_word;
char	*button_name;
int	button_num;
char	*command;
{
	char	w_buffer[80];

	(void) sprintf(w_buffer,"sub_action%d", button_num);
	sub_action[button_num] = XtVaCreateManagedWidget(
			w_buffer,
			menuButtonWidgetClass,
			popup_layout,
			NULL);

	SetSubMenuButton(data, key_word, button_name, button_num); 

	if((key_word == TEXT) || (key_word == ICON) || (key_word == PIXMAP))
		XtAddCallback(sub_action[button_num],
			XtNcallback,SingleAction,command);
	else
		XtAddCallback(sub_action[button_num],
			XtNcallback,MultiAction,command);

	XtVaSetValues(sub_action[button_num],
			XtNtranslations,
			XtParseTranslationTable(cb_Trans),
			NULL);
}

extern	void
set_popup(w,event,params,num_params)
Widget	w;
XEvent	*event;	/* unused */
String	*params;
Cardinal	*num_params;
{
	/*
		position the menu, whose name was passed as the first and
		only parameter at position (20,5) relative to the widget w.
	*/
	Widget	a_shell;
	Position	x,y;

	if(*num_params != 1)
		XtError("Wrong parameter count passed to set_popup()");
	
	/* get the internal Widget id of the named shell */
	a_shell = XtNameToWidget(toplevel,params[0]);
	if(a_shell == NULL)
		XtError("FATAL ERROR: Wrong shell name passed to set_popup()\n\
			please check icon file is correct");
	XtTranslateCoords(w,(Position) 5,(Position) 5, &x,&y);
	XtVaSetValues(a_shell,XtNx,x,XtNy,y,NULL);
}

extern	void
delay(w,event,params,num_params)
Widget  w;
XEvent  *event; /* unused */
String  *params;
Cardinal        *num_params;
{
	(void) sleep(1);
}

extern	void
DefaultButtons(data,last_button)
Info	*data;
int	last_button;
{
	int	string_length;
	char	w_buffer[80];
	char	ptrans[250];
	char	*edit_file, *h_file;

	/* create default sub menu which will contain source, edit & quit */
	/* buttons.  Default menu button is called Manage  */

	/* create main menu button */
	(void) sprintf(ptrans,pb_Trans,last_button,popup_menu_name);

	(void) sprintf(w_buffer,"action%d",last_button);
	action[last_button] = XtVaCreateWidget(
			w_buffer,
			commandWidgetClass,
			box,
			NULL);

	XtVaSetValues(action[last_button],XtNtranslations,
			XtParseTranslationTable(ptrans),NULL);

	SetButton(data, TEXT,"Edit\nIcons",last_button);

	/* create popup shell */
	CreatePopupShell(last_button);

	CreateDefaultSubButton(data, TEXT, "Source", 0);

	XtAddCallback(sub_action[0],XtNcallback,Source,data);

	XtVaSetValues(sub_action[0],XtNtranslations,
				XtParseTranslationTable(cb_Trans),NULL);

	CreateDefaultSubButton(data, TEXT, "Edit", 1);

	string_length = strlen(data->editor);
	string_length += strlen(data->icon_file);
	if((edit_file = malloc(string_length + 1)) == NULL)
	{
		(void) fprintf(stderr,"ERROR: out of memory for string edit_file.  In function CreateButtons.\n");
		exit(1);
	}
	strcpy(edit_file,data->editor);
	strcat(edit_file,data->icon_file);

	XtAddCallback(sub_action[1],XtNcallback,SingleAction,edit_file);

	XtVaSetValues(sub_action[1],XtNtranslations,
				XtParseTranslationTable(cb_Trans),NULL);

	CreateDefaultSubButton(data, TEXT, "Help", 2);

	string_length = 0;
	string_length = strlen(FORMATTER);
	string_length += strlen(HELP_VIEWER);
	string_length += strlen(data->help_file);
	if((h_file = malloc(string_length +1)) == NULL)
	{
		(void) fprintf(stderr,"ERROR: out of memory for string edit_file.  In function CreateButtons.\n");
		exit(1);
	}
	strcpy(h_file,FORMATTER);
	strcat(h_file,data->help_file);
	strcat(h_file,HELP_VIEWER);
	XtAddCallback(sub_action[2],XtNcallback,SingleAction,h_file);

	XtVaSetValues(sub_action[2],XtNtranslations,
				XtParseTranslationTable(cb_Trans),NULL);

	CreateDefaultSubButton(data, TEXT, "Quit", 3);

	XtAddCallback(sub_action[3],XtNcallback,Quit,NULL);

	XtVaSetValues(sub_action[3],XtNtranslations,
				XtParseTranslationTable(cb_Trans),NULL);
}

static  void
ErrorMessage(ErrorStatus, tag, file)
int     ErrorStatus;
char    *tag;
char    *file;
{
        char *error = NULL;
        char *warning = NULL;

        switch (ErrorStatus) 
        {
                case XpmSuccess:
                        return;
                case XpmColorError:
                        warning = "Could not parse or alloc requested color";
                        break;
                case XpmOpenFailed:
                        warning = "Cannot open file";
                        break;
                case XpmFileInvalid:
                        warning = "Invalid XPM file";
                        break;
                case XpmNoMemory:
                        error = "Not enough memory";
                        break;
                case XpmColorFailed:
                        warning = "Failed to parse or alloc some color";
                        break;
        }
        if (warning)
                fprintf(stderr, "\n%s Xpm Warning: %s: %s\n", tag, 
                        warning, file);

        if (error) 
        {
                fprintf(stderr, "\n%s Xpm Warning: %s: %s\n", tag, 
                        warning, file);
                exit(1);
        }
}

