#include "gen.h"
#include "widgets.h"
#include <signal.h>
#include <sys/wait.h>
#include <stdio.h>

extern	XtAppContext	app_context;

static void 	catch_child();
static void	ResetButton PROTO((XtPointer,XtIntervalId *));
extern  int     ProcessFile PROTO((Info*, char*));
extern  void    PositionButtons PROTO((int,int));
extern	void	ManageButtons();

extern void 
Quit(widget, client_data,call_data)
Widget          widget;
XtPointer       client_data;
XtPointer       call_data;
{
	/* exit graciously */
	XtDestroyWidget(toplevel);
        exit(0);
}


extern void 
MultiAction(widget,client_data,call_data)
Widget          widget;
XtPointer       client_data;
XtPointer       call_data;
{
	char	*command = (char*) client_data;
	int	pid;
	static	bool_t first_time = TRUE;
	char	*exec_command;	/* for "exec " + command */

#define PREPEND "exec "

        if (first_time) 
	{
        	first_time = FALSE;
		if ((int) signal(SIGCHLD, catch_child) == -1) 
		{
			(void) fprintf(stderr,"unable to install child catcher");
			exit(1);
		}
	}

	switch(pid = fork())
	{
		case -1:
			(void) fprintf(stderr,"ERROR: Process cannot fork\n");
			(void) fprintf(stderr,"Sorry unable to execute command\n");
			break;
		case 0:
			/* child */
			exec_command = malloc((unsigned) sizeof(PREPEND) +
				strlen(command) + 1);
			if(exec_command == NULL)
			{
				(void) fprintf(stderr,"ERROR: out of memory\n");
				exit(1);
			}
			strcpy(exec_command,PREPEND);
			strcat(exec_command,command);
			(void)execlp("/bin/sh","sh","-c",exec_command,(char *) 0);
			exit(127);
			break;
	}
}


extern void 
SingleAction(widget,client_data,call_data)
Widget          widget;
XtPointer       client_data;
XtPointer       call_data;
{
	char	*command = (char*) client_data;
	int	pid;
	int	i = 0;
	static	bool_t first_time = TRUE;
	char	*exec_command;	/* for "exec " + command */

#define PREPEND "exec "

/*
	This section of code was taken from xalias written by Godfrey Paul
        First time only, arrange for SIGCHLD to be called.
*/
        if (first_time) 
	{
        	first_time = FALSE;
		if ((int) signal(SIGCHLD, catch_child) == -1) 
		{
			(void) fprintf(stderr,"unable to install child catcher");
			exit(1);
		}
	}

	switch(pid = fork())
	{
		case -1:
			(void) fprintf(stderr,"ERROR: Process cannot fork\n");
			(void) fprintf(stderr,"Sorry unable to execute command\n");
			break;
		case 0:
			/* child */
			exec_command = malloc((unsigned) sizeof(PREPEND) +
				strlen(command) + 1);
			if(exec_command == NULL)
			{
				(void) fprintf(stderr,"ERROR: out of memory\n");
				exit(1);
			}
			strcpy(exec_command,PREPEND);
			strcat(exec_command,command);
			(void)execlp("/bin/sh","sh","-c",exec_command,(char *) 0);
			exit(127);
			break;
	}
	while((ci_ptr[i].child_id != 0) && (i < MAXPROCS))
			i++;
	if(i < MAXPROCS)
	{
		ci_ptr[i].child_id = pid;
		ci_ptr[i].w_id = widget;
		XtSetSensitive(widget,False);
	}
	else
		(void) printf("\nWarning: unable to deactivate selected button\n");

}

/* ----------------------------- the sysV catch_child----------------------- */
/* written by Peter Pregler RISC, University of Linz, Austria. Thanks!! */

#ifdef SYSV
static void
catch_child()
{
int           pid;
int           i = 0;
int stat_loc;

	(void) signal(SIGCHLD, SIG_IGN);

	/* first  check known processes */
	for (i=0; i<MAXPROCS; i++) 
	{
		if (ci_ptr[i].child_id !=0) 
		{
			pid = waitpid(ci_ptr[i].child_id, &stat_loc, WNOHANG);
			if(pid!=0 && (WIFEXITED(stat_loc) || 
				WIFSIGNALED(stat_loc))) 
			{
				XtAppAddTimeOut(app_context,50,ResetButton,
					ci_ptr[i].child_id);
			}
		}
	}
	/* now catch rest - reaper :) */

	while (waitpid(-1, (int *)0, WNOHANG) > 0);
	/* reinstall handler */
	(void) signal(SIGCHLD, catch_child);
	return;
}
#endif

/*
	This section of code was taken from xalias written by Godfrey Paul
*/
#ifndef SYSV
static void
catch_child()
{
        int     	pid;
	int		i = 0;
        union wait      status;


        /*
         * waitpid() returns -1 if the are no children left, or 0
         * if there are no exited children.
         */
	while ((pid = waitpid((pid_t) -1, &status, WNOHANG)) > 0)
	{

		while((ci_ptr[i].child_id != pid) && (i < MAXPROCS))
				i++;
		if(ci_ptr[i].child_id == pid)
		{
			XtAppAddTimeOut(app_context,50,ResetButton,pid);
		}
	}
        return;
}
#endif

extern void
Source(widget,client_data,call_data)
Widget          widget;
XtPointer       client_data;
XtPointer       call_data;
{
	Info    *data = (Info*) client_data;

	int		x = 0;
	WidgetList	w_list;
	Cardinal	num_childern, i;
	if(data->no_of_buttons >= 0)
	{
		while(x < MAXPROCS)
		{
			ci_ptr[x].child_id = 0;
			ci_ptr[x].w_id = NULL;
			x++;
		}
		XtUnmanageChild(box);
		XtVaGetValues(
			box,
			XtNchildren,
			&w_list,
			XtNnumChildren,
			&num_childern,
			NULL);

		for(i = 0; i < num_childern; i++)
		{
			XtDestroyWidget(w_list[i]);
		}
		data->no_of_buttons = 0;
		data->no_of_buttons = ProcessFile(data, "bricons");
		PositionButtons(data->no_of_buttons,data->no_of_columns);
		ManageButtons();
		XtManageChild(box);
	}
}

static void
ResetButton(client_data,id)
XtPointer       client_data;
XtIntervalId	*id;
{
	int	c_pid = (int) client_data;
	int	i = 0;
	while((ci_ptr[i].child_id != c_pid) && (i < MAXPROCS))
			i++;
	if(ci_ptr[i].child_id == c_pid)
	{
		XtSetSensitive(ci_ptr[i].w_id,True);
		ci_ptr[i].child_id = 0;
	}
}
