
#include "UmlFragment.h"
#include "FileOut.h"
#include "UmlItem.h"
#include "UmlSequenceMessage.h"
#include "UmlClassInstanceReference.h"

#include "UmlFragmentCompartment.h"
void UmlFragment::write(FileOut & out, UmlItem * diagram, QList< UmlSequenceMessage > & msgs) {
  QCString oper = name();
  
  if ((oper != "alt") &&
      (oper != "opt") &&
      (oper != "loop") &&
      (oper != "break") &&
      (oper != "par") &&
      (oper != "seq") &&
      (oper != "strict") &&
      (oper != "neg") &&
      (oper != "critical") &&
      (oper != "assert") &&
      (oper != "ignore") &&
      (oper != "consider"))
    oper = "";
  else {
    static int rank = 0;
    
    out.indent();
    out << "<fragment xmi:type=\"uml:CombinedFragment\"";
    out.id_prefix(diagram, "COMBINEDFRAGMENT", ++rank);

    if (! covered.isEmpty()) {
      out << " covered=\"";
      
      UmlClassInstanceReference * lifeline = covered.first();

      for (;;) {
	out.ref_only(diagram, lifeline->lifeline());
	lifeline = covered.next();
	if (lifeline == 0)
	  break;
	out << ' ';
      }
      
      out << '"';
    }
    
    out << " interactionOperator=\"" << oper << "\">\n";
    out.indent(+1);
  }

  const QVector<UmlFragmentCompartment> & subs = compartments();
  unsigned n = subs.size();
  
  for (unsigned i = 0; i != n; i += 1)
    subs.at(i)->write(out, diagram, msgs, oper);
  
  if (!oper.isEmpty()) {
    out.indent(-1);
    out.indent();
    out << "</fragment>\n";
  }
}

void UmlFragment::cover(UmlSequenceMessage * msg) {
  if (covered.findRef(msg->from()) == -1)
    covered.append(msg->from());
  if (covered.findRef(msg->to()) == -1)
    covered.append(msg->to());

  if (container() != 0)
    container()->fragment()->cover(msg);
}

