/* $Id: maint.h,v 1.6 2004/05/02 16:37:09 relson Exp $ */

#ifndef MAINT_H
#define MAINT_H

#include <time.h>

#include "datastore.h"

#define	AGE_IS_YDAY
#undef	AGE_IS_YDAY
#undef	AGE_IS_YYYYMMDD
#define	AGE_IS_YYYYMMDD

extern	uint32_t thresh_count;
extern	YYYYMMDD thresh_date;
extern	size_t   size_min, size_max;
extern	bool     timestamp_tokens;
extern	bool     replace_nonascii_characters;
extern	bool     upgrade_wordlist_version;

/* Function Prototypes */
void maintain_wordlists(void);
int  maintain_wordlist_file(const char *db_file);

bool discard_token(word_t *token, dsv_t *info);

bool do_replace_nonascii_characters(byte *, size_t);

void set_today(void);
void set_date(YYYYMMDD date);
time_t long_to_date(long l);
YYYYMMDD string_to_date(const char *s);

#endif	/* MAINT_H */
