// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com




#define BX_BIOS_MESSAGE_SIZE 80


#if BX_USE_UM_SMF
#  define BX_UM_SMF  static
#  define BX_UM_THIS bx_unmapped.
#else
#  define BX_UM_SMF
#  define BX_UM_THIS this->
#endif



class bx_unmapped_c {
public:
  bx_unmapped_c(void);
  ~bx_unmapped_c(void);
  BX_UM_SMF void   init(bx_devices_c *d);

private:

  static Bit32u read_handler(void *this_ptr, Bit32u address, unsigned io_len);
  static void   write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len);
#if !BX_USE_UM_SMF
  Bit32u read(Bit32u address, unsigned io_len);
  void   write(Bit32u address, Bit32u value, unsigned io_len);
#endif

  struct {
    Bit8u port80;
    Bit8u port8e;

    Bit8u bios_message[BX_BIOS_MESSAGE_SIZE];
    unsigned int bios_message_i;
    } s;  // state information

  bx_devices_c *devices;
  };

#if BX_USE_UM_SMF
extern bx_unmapped_c bx_unmapped;
#endif
