// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com


#ifndef _PCDMA_H
#define _PCDMA_H


#define BX_KBD_ELEMENTS 16
#define BX_MOUSE_BUFF_SIZE 48


#if BX_USE_DMA_SMF
#  define BX_DMA_SMF  static
#  define BX_DMA_THIS bx_dma.
#else
#  define BX_DMA_SMF
#  define BX_DMA_THIS this->
#endif



class bx_dma_c {
public:

  bx_dma_c();
  ~bx_dma_c(void);

  BX_DMA_SMF void     init(bx_devices_c *);
  BX_DMA_SMF void     DRQ(unsigned channel, Boolean val);
  BX_DMA_SMF void     raise_HLDA(bx_pc_system_c *pc_sys);

private:

  static Bit32u read_handler(void *this_ptr, Bit32u address, unsigned io_len);
  static void   write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len);
#if !BX_USE_DMA_SMF
  Bit32u   read( Bit32u   address, unsigned io_len);
  void     write(Bit32u   address, Bit32u   value, unsigned io_len);
#endif
  struct {
    Boolean mask[4];
    Boolean flip_flop;
    Bit8u   status_reg;
    Bit8u   command_reg;
    Bit8u   request_reg;
    Bit8u   temporary_reg;
    struct {
      struct {
        Bit8u mode_type;
        Bit8u address_decrement;
        Bit8u autoinit_enable;
        Bit8u transfer_type;
        } mode;
      Bit16u  base_address;
      Bit16u  current_address;
      Bit16u  base_count;
      Bit16u  current_count;
      Bit8u   page_reg;
      } chan[4]; /* DMA channels 0..3 */
    } s;  // state information

  bx_devices_c *devices;
  };

#if BX_USE_DMA_SMF
extern bx_dma_c bx_dma;
#endif

#endif  // #ifndef _PCDMA_H
