// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com





#if BX_USE_CMOS_SMF
#  define BX_CMOS_SMF  static
#  define BX_CMOS_THIS bx_cmos.
#else
#  define BX_CMOS_SMF
#  define BX_CMOS_THIS this->
#endif


class bx_cmos_c {
public:
  bx_cmos_c(void);
  ~bx_cmos_c(void);

  BX_CMOS_SMF void init(bx_devices_c *);
  BX_CMOS_SMF void checksum_cmos(void);
  BX_CMOS_SMF void reset(void);

  struct {
    int     periodic_timer_index;
    Bit32u  periodic_interval_usec;
    int     one_second_timer_index;
    time_t  timeval;
    Bit8u   cmos_mem_address;

    Bit8u   reg[BX_NUM_CMOS_REGS];
    } s;  // state information

private:
  bx_devices_c *devices;

  static Bit32u read_handler(void *this_ptr, Bit32u address, unsigned io_len);
  static void   write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len);
#if !BX_USE_CMOS_SMF
  Bit32u read(Bit32u address, unsigned io_len);
  void   write(Bit32u address, Bit32u value, unsigned len);
#endif

public:
  static void periodic_timer_handler(void *);
  static void one_second_timer_handler(void *);
private:
  BX_CMOS_SMF void update_clock(void);
  BX_CMOS_SMF void CRA_change(void);
  };


#if BX_USE_CMOS_SMF
extern bx_cmos_c bx_cmos;
#endif
