/* Bluefish HTML Editor
 * wizards.c - much magic is contained within
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 * Copyright (C) 1999 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"

#include <locale.h>

#include "cap.h"
#include "wizards.h" 	/* myself */

#include "bluefish.h"
#include "gtk_easy.h" /* spinbutwithvalue and stuff*/
#include "bf_lib.h"  /* bf_str_repeat() */
#include "html_diag.h"
#include "document.h"			/* insert_dbl_text() */

static void table_wizard_ok_lcb(GtkWidget * widget, Thtml_diag *dg) {

	gint rows, cols;
	gchar *tablerowstart, *rowdata, *tablerow, *tablecontent, *finalstring;
	/* gtk forces the value of one if nothing is entered */
	rows = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dg->spin[1]));
	cols = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dg->spin[2]));

	if (GTK_TOGGLE_BUTTON(dg->check[1])->active) {
		if (GTK_TOGGLE_BUTTON(dg->check[2])->active) {
			tablerowstart = cap("\t<TR>");
		} else {
			tablerowstart = cap("<TR>");
		}
		rowdata = bf_str_repeat(cap("<TD></TD>"), cols);
	} else {
		tablerowstart = cap("<TR>\n");
		if (GTK_TOGGLE_BUTTON(dg->check[2])->active) {
			rowdata = bf_str_repeat(cap("\t<TD></TD>\n"), cols);
		} else {
			rowdata = bf_str_repeat(cap("<TD></TD>\n"), cols);
		}
	}
	tablerow = g_strconcat(tablerowstart, rowdata, cap("</TR>\n"), NULL);
	tablecontent = bf_str_repeat(tablerow, rows);
	g_free(tablerow);
	finalstring = g_strconcat(cap("<TABLE>\n"), tablecontent, cap("</TABLE>"), NULL);
	g_free(tablecontent);

	insert_dbl_text(finalstring, NULL);
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}

void tablewizard(GtkWidget *widget, gpointer data) {
	GtkWidget *dgtable;
	Thtml_diag *dg;
	dg = html_diag_new(_("Table Wizard"));

	dgtable = gtk_table_new(2, 10, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->spin[1] = spinbut_with_value(NULL, 1, 100, 1.0, 5.0);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Number of rows")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->spin[1], 1, 5, 0, 1);

	dg->spin[2] = spinbut_with_value(NULL, 1, 100, 1.0, 5.0);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Number of Columns per row")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->spin[2], 1, 5, 1, 2);

	dg->check[1] = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Tablerows on one line")), 5, 8, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->check[1], 8, 10, 0, 1);

	dg->check[2] = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Indent table code")), 5, 8, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->check[2], 8, 10, 1, 2);

	html_diag_finish(dg, table_wizard_ok_lcb);
}

static void frame_wizard_ok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	gchar *title, *thestring, *frameset, *frames, *sizes, *dtd, *finalstring;
	gint i, count;
	gboolean need_comma=FALSE;

	if (GTK_TOGGLE_BUTTON(dg->check[0])->active) {
		dtd = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\n\t\"http://www.w3.org/TR/html4/frameset.dtd\">";
	} else {
		dtd = "";
	}
	title = gtk_editable_get_chars(GTK_EDITABLE(dg->entry[12]), 0, -1);
	thestring = g_strconcat(dtd
			, cap("<HTML>\n<HEAD>\n<TITLE>")
			, title
			, cap("</TITLE>\n</HEAD>\n"), NULL);
	g_free(title);
	
	count = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dg->spin[1]));
	frames = g_strdup("");
	sizes = g_strdup("");
	for (i = 0; i < count ; i++) {
		gchar *tmpstr, *size, *name, *source;
		size = gtk_editable_get_chars(GTK_EDITABLE(dg->entry[i]), 0, -1);
		name = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(dg->combo[i])->entry), 0, -1);
		source = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(dg->combo[i+5])->entry), 0, -1);
		if (main_v->props.xhtml == 1) {
			tmpstr = g_strconcat(frames, cap("<FRAME NAME=\""), name, cap("\" SRC=\""), source, "\" />\n", NULL);
		} else {
			tmpstr = g_strconcat(frames, cap("<FRAME NAME=\""), name, cap("\" SRC=\""), source, "\">\n", NULL);
		}
		g_free(frames);
		frames = tmpstr;

		if (need_comma) {
			tmpstr = g_strconcat(sizes, ",", size, NULL);
		} else {
			tmpstr = g_strconcat(sizes, size, NULL);
		}
		g_free(sizes);
		sizes = tmpstr;

		need_comma = TRUE;

		g_free(size);
		g_free(name);
		g_free(source);
	}
	
	if (GTK_TOGGLE_BUTTON(dg->radio[1])->active) {
		frameset = g_strconcat(cap("<FRAMESET COLS=\""), sizes, "\">\n", NULL);
	} else {
		frameset = g_strconcat(cap("<FRAMESET ROWS=\""), sizes, "\">\n", NULL);
	}

	finalstring = g_strconcat(thestring, frameset, frames, cap("<NOFRAMES>\n\n</NOFRAMES\n</FRAMESET>\n</HTML>"), NULL);
	g_free(sizes);
	g_free(frameset);
	g_free(frames);
	g_free(thestring);
	insert_dbl_text(finalstring, NULL);
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}

static void frame_wizard_num_changed(GtkWidget *widget, Thtml_diag *dg) {
	gint num,i;
	num = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dg->spin[1]));
	for (i = 0; i < MAX_FRAMES_IN_FRAMEWIZARD ; i++) {
		if (i < num) {
			gtk_widget_show(dg->clist[i]);
		} else {
			gtk_widget_hide(dg->clist[i]); 
		}
	}
}

void framewizard(GtkWidget * widget, gpointer data) {

	GtkWidget *dgtable, *frame, *vbox;
	Thtml_diag *dg;
	gint i;

	dg = html_diag_new(_("Frame Wizard"));

	dgtable = gtk_table_new(8, 5, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->entry[12] = entry_with_text(NULL, 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Title")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[12], 1, 5, 0, 1);

	dg->check[0] = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Use DTD")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->check[0], 1, 2, 1, 2);

	dg->radio[1] = radiobut_with_value(_("Horizontal"), 0, NULL);
	dg->radio[2] = radiobut_with_value(_("Vertical"), 0, GTK_RADIO_BUTTON(dg->radio[1]));
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->radio[1], 0, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->radio[2], 0, 2, 3, 4);

	dg->spin[1] = spinbut_with_value("2", 1, MAX_FRAMES_IN_FRAMEWIZARD, 1.0, 2.0);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Number of Frames")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->spin[1], 1, 2, 4, 5);
	gtk_signal_connect(GTK_OBJECT(dg->spin[1]), "changed", frame_wizard_num_changed, dg);
	frame = gtk_frame_new(_("Frame's"));
	gtk_table_attach_defaults(GTK_TABLE(dgtable), frame, 2, 5, 1, 8);
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	for (i = 0; i < MAX_FRAMES_IN_FRAMEWIZARD ; i++) {
		GtkWidget *file_but;
	/* since there are no clists in this dialog we can use it freely :) */
		dg->clist[i] = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), dg->clist[i], FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(dg->clist[i]), gtk_label_new(_("Name")), TRUE, TRUE, 0);
		dg->combo[i] = boxed_combo_with_popdown(NULL, main_v->current_project.targetlist, 1, dg->clist[i]);
		gtk_box_pack_start(GTK_BOX(dg->clist[i]), gtk_label_new(_("Source")), TRUE, TRUE, 0);
		dg->combo[i+5] = boxed_combo_with_popdown(NULL, main_v->current_project.urllist, 1, dg->clist[i]);
		file_but = file_but_new(GTK_WIDGET(GTK_COMBO(dg->combo[i+5])->entry), dg->dialog, 0);
		gtk_box_pack_start(GTK_BOX(dg->clist[i]), file_but, TRUE, TRUE, 0);		
		gtk_box_pack_start(GTK_BOX(dg->clist[i]), gtk_label_new(_("Size")), TRUE, TRUE, 0);
		dg->entry[i] = boxed_entry_with_text(NULL, 100, dg->clist[i]);

	}
	html_diag_finish(dg, frame_wizard_ok_lcb);
	frame_wizard_num_changed(NULL, dg);

}


