/* Bluefish HTML Editor
 * document.c - this file contains the document code
 *
 * Copyright (C) 2000 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __DOCUMENT_H_
#define __DOCUMENT_H_

typedef struct {
	gint currentp;
	gshort selection;
	gint startp;
	gint endp;
	gfloat adj;
} Ttext_positions;

void document_set_fonts(gchar * textfontstring, gchar * labelfontstring, Tdocument * document);
void document_set_wrap(gint word_wrap, gint line_wrap, Tdocument * document);
void document_force_def_style(Tdocument *doc, gint do_force);
void doc_need_highlighting(Tdocument * whichdoc);
void doc_save_selection(Tdocument *doc);
void doc_restore_selection(Tdocument *doc);
gint find_filename_in_documentlist(gchar *filename);
gint position_to_linenum(gint position);
void go_to_line(gint linenum, gint select_line);
void copy_cb(GtkWidget * w, gpointer data);
void paste_cb(GtkWidget * w, gpointer data);
void cut_cb(GtkWidget * w, gpointer data);
void sel_all_cb(GtkWidget * w, gpointer data);
void selection_to_uppercase_cb(GtkWidget * w, gpointer data);
void selection_to_lowercase_cb(GtkWidget * w, gpointer data);
void all_documents_update_links(Tdocument * curdoc, gchar * oldfilename,gchar * newfilename);
Ttext_positions get_positions(GtkWidget * textbox);
void restore_positions(Ttext_positions positions, GtkWidget * textbox);

void doc_replace_text(const gchar * newstring, gint pos, gint end, Tdocument *doc);
void replace_text(const gchar * newstring, gint pos, gint end);
void insert_dbl_text(const gchar * before, const gchar * after);
void doc_insert_text(Tdocument *document, const gchar * newstring);

void file_move_to_cb(GtkWidget * widget, gpointer data);
void iso8859_1_replace_cb(GtkWidget * widget, gpointer data);
gint doc_xy_to_cursor_pos(Tdocument *doc, gint x, gint y);
void go_to_line_win_cb(GtkWidget * widget, gpointer data);
void ascii_replace_cb(GtkWidget * widget, gpointer data);
void escape_quotes_replace_cb(GtkWidget * widget, gpointer data);
void doc_textbox_to_file(Tdocument *doc, gchar * filename);
Tdocument *doc_new(void);
void doc_new_with_file(gchar * filename);
void docs_new_from_files(GList *file_list);
void doc_destroy(Tdocument * doc);
void doc_save(Tdocument * doc, gint do_save_as, gint do_move);
gint doc_close(Tdocument *doc, gint warn_only);
void file_save_cb(GtkWidget * widget, gpointer data);
void file_save_as_cb(GtkWidget * widget, gpointer data);
void file_move_to_cb(GtkWidget * widget, gpointer data);
void file_open_cb(GtkWidget * widget, gpointer data);
void file_open(gchar * filename);
void file_insert_cb(GtkWidget * widget, gpointer data);
void file_new_cb(GtkWidget * widget, gpointer data);
void file_close_cb(GtkWidget * widget, gpointer data);
gint test_only_empty_doc_left(Tdocument *doc);
void file_close_all_cb(GtkWidget * widget, gpointer data);
void file_save_all_cb(GtkWidget * widget, gpointer data);
void file_print_cb(GtkWidget * widget, gpointer data);

#endif
