/* Bluefish HTML Editor
 * bluefish.h - global prototypes live here
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __BLUEFISH_H_
#define __BLUEFISH_H_

#include <glib.h>
#include <gtk/gtkwidget.h>

/* needed to see if WITH_SPC is defined */
#include "config.h"

#define WITH_MSG_QUEUE

#ifdef WITH_MSG_QUEUE
#define BLUEFISH_MSG_QUEUE 9723475
#define MSQ_QUEUE_SIZE 1024
#define MSQ_QUEUE_SMALL_SIZE 7
#define MSQ_QUEUE_CHECK_TIME 300
#define MSG_QUEUE_SEND_ALIVE 46064
#define MSG_QUEUE_OPENFILE 46063
#define MSG_QUEUE_ASK_ALIVE 46062

#endif

/* the saved selection in a document */
typedef struct {
	gboolean saved;
	guint start_pos;
	guint end_pos;
	guint has_selection : 1;
} TSelection;

/* This is the type of each document */
typedef struct {
	gchar *filename;
	gint modified;
	unsigned del_txt_id;		/* Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com> */
	unsigned ins_txt_id;		/* undo/redo part is copied from gnotepad code */
	GList *undolist;
	GList *undotail;
	GList *redolist;
	GList *redotail;
	GtkWidget *textbox;
	GtkWidget *tab_label;
	gint highlightstate;
	gint need_highlighting;		/* +1 means a '"' is added, +2 means a '<' is added, 4 means a '>' is added */
	TSelection saved_sel;
} Tdocument;

/* This is the current project */
typedef struct {
	gint modified;
	gchar *filename;
	gchar *basedir;
	gchar *webdir;
	gchar *template;
	GList *fontlist;
	GList *urllist;
	GList *targetlist;
	GList *colorlist;
	GList *dtd_cblist;
	GList *classlist;
	GList *headerlist;
	GList *filenames;
} Tproject;

typedef struct {
	gint v_html_tb;				/* view html toolbar */
	gint v_custom_tb;			/* view custom menubar */
	gint v_main_tb;				/* view main toolbar */
	gint transient_htdialogs;  /* set html dialogs transient ro the main window */
	gint main_window_h;			/* main window height */
	gint main_window_w;			/* main window width */
	gint main_filelist_size; 	/* width of filelist */
	gint max_recent_files;	/* length of Open Recent list */
	gint max_dir_history;	/* length of directory history */
	gchar *filelist_filter;	/* filelist filter type */
	gchar *filebrowser_filter_image; /* the image type */
	gchar *filebrowser_filter_php; /* the php type */
	gchar *filebrowser_filter_html; /* the html type */
	gchar *filebrowser_filter_jscript; /* the jscript type */
	gchar *filebrowser_filter_css; /* the css type */
	gchar *filebrowser_filter_other; /* the other type */
	gchar *cfg_browser_cline;	/* browser commandline */
	gchar *cfg_weblint_cline;	/* weblint command line */
	gchar *cfg_editor_font;		/* editor font */
	gint cfg_editor_tabwidth;	/* editor tabwidth */
	gchar *cfg_tab_pos;			/* notebook tabs positioning */
	gchar *cfg_tab_font;		/* notebook tabs font */
	gchar *cfg_thumbnailstring;	/* string to append to thumbnail filenames */
	gchar *cfg_thumbnailtype;	/* fileformat to use for thumbnails */
	gint full_p;				/* use </p> */
	gint full_li;				/* use </li> */
	gint allow_css;				/* CSS allowed */
	gint allow_dep;				/* allow <FONT>... */
	gint format_by_context; 	/* use <strong> instead of <b>, <emphasis instead of <i> etc. (W3C reccomendation) */
	gint xhtml;					/* write <br /> */
	gint allow_ruby;			/* allow <ruby> */
	gint allow_h4;				/* allow <Q>... */
	gint allow_frames;			/* allow <FRAME> */
	gint force_dtd;				/* write <!DOCTYPE...> */
	gint dtd_url;				/* URL in DTD */
	gint xml_start;				/* <?XML...> */
	gint lowercase_tags;		/* use lowercase tags */
	gint word_wrap;				/* use wordwrap */
	gint autoindent;			/* autoindent code */
	gint line_wrap;				/* use line wrap */
	gint fontset;				/* load fontset (0 = load font) */
	gint force_def_style;  /* force white editor background */
	gint drop_at_drop_pos; 	/* drop at drop position instead of cursor position */
	gint link_management; 	/* perform link management */
	gint defaulthighlight;		/* highlight documents by default */
	gint cont_highlight_full; 	/* if you want to highlight the full text or just the line */
	gint cont_highlight_update;	/* update the syntax highlighting continuous */
	gchar *html_ver;
	GList *external_filters;	/* external filter in list */
	GList *external_commands;	/* external filter in list */
	GList *cust_menu; 		/* entries in the custom menu */
	GList *syntax_configstrings;	/* the strings containing the colors and patters */

#ifdef WITH_SPC
	/* spell checker options */
	gchar *cfg_spc_cline      ;  /* spell checker command line */
	gchar *cfg_spc_lang       ;  /* language */
	gint  spc_accept_compound ;  /* accept compound words ? */
	gint  spc_use_esc_chars   ;  /* specify aditional characters that
                                     may be part of a word ? */
	gchar* spc_esc_chars      ;  /* which ones ? */
	gint   spc_use_pers_dict  ;  /* use a personal dictionary */
	gchar* spc_pers_dict      ;  /* which one ? */
   gint   spc_use_input_encoding ;  /* use input encoding */
   gchar* spc_input_encoding     ;  /* wich one ? */
   gint   spc_output_html_chars  ; /* output html chars ? (like &aacute;)*/
#endif
	gchar *backup_filestring;  /* the string to append to the backup file */
	gint backup_file; 			/* wheather to use a backup file */
	gint allow_multi_instances; /* allow multiple instances of the same file */

	/* key conversion */
	gint conv_ctrl_enter;		/* convert control-enter key press */
	gchar *ctrl_enter_text;		/* inserted text */
	gint conv_shift_enter;		/* convert shift-enter key press */
	gchar *shift_enter_text;	/* inserted text */
	gint conv_special_char;		/* convert ctrl-'<','>','&' */
#ifdef WITH_MSG_QUEUE
	gint open_in_running_bluefish; /* open commandline documents in already running session*/
#endif /* WITH_MSG_QUEUE */
} Tproperties;

#ifdef WITH_INTERNAL_PREVIEW
typedef struct {
	GtkWidget *win;
	GtkWidget *html;
} Tpreview;
#endif

typedef enum {
FILTER_ALL,
FILTER_WEB,
FILTER_IMAGES,
FILTER_DOCUMENTS
} Tfilebrowser_filter;


typedef struct {
	gchar *curdir;
	GtkWidget *dir_history;
	GtkWidget *dir_list;
	gint dir_list_lastrow;
	GtkWidget *file_list;
	gint file_list_lastrow;
	gint file_list_selectedrow;
	GList *dir_history_menu;
	Tfilebrowser_filter filter_type;
	GList *directory_history;
} Tfilebrowser;

/* identifying files */
#define TYPE_UNKNOWN 0
#define TYPE_IMAGE 1
#define TYPE_PHP 2
#define TYPE_HTML 3
#define TYPE_DIR 4
#define TYPE_JSCRIPT 5
#define TYPE_CSS 6
#define TYPE_OTHER 7
#define TYPES_COUNT 8

typedef struct {
	Tproject current_project;
	Tproperties props;
	Tdocument *current_document;	/* This is always the current visible one */
	GList *documentlist;		/* The documents are now placed in a Glist */
	GtkWidget *notebook;
	gint last_notebook_page;	/* this is the last used, this can be used to track down if the notebook page really changed */
	GtkWidget *statusbar;
	GtkWidget *menubar;
	Tfilebrowser filebrowser;
	gchar **identify_filters[TYPES_COUNT];
	GtkWidget *main_window;
	GtkWidget *cmenu;
	GList *cmenu_arrays; /* custom menu strctures */
#ifdef WITH_INTERNAL_PREVIEW
	Tpreview *preview;
#endif
	void *syntax_structs;		/* pointer to an array of struct : the props.syntax_configstrings parsed into structs with GdkColor and regex pattern */
	gint syntax_structs_n;		/* number of structs pointed by syntax_structs */
	GList *command_strings;
	GList *filter_strings;
	GList *recent_files;
	GdkColormap *colormap;
#ifdef WITH_MSG_QUEUE
	gint msgid;
#endif /* WITH_MSG_QUEUE */
} Tmain;

extern Tmain *main_v;

/* for exiting bluefish */
void cya_later(GtkWidget * widget, gpointer data);

void load_identify_filters();
gint identify_by_filename(gchar *filename);

/* runs through all the events in the gtk and gdk queue */
void flush_queue(void);

#endif							/* __BLUEFISH_H_ */
