/* Bluefish HTML Editor
 * bf_lib.h - non-GUI general functions
 *
 * Copyright (C) 2000 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __BF_LIB_H_
#define __BF_LIB_H_
gboolean file_copy(gchar *source, gchar *dest);
gchar *escapestring(gchar *original, gchar delimiter);
gchar *unescapestring(gchar *original);
gboolean change_dir(gchar * filename);
gchar *strip_any_whitespace(gchar *string);
gchar *trunc_on_char(gchar * string, gchar which_char);
gchar *strip_filename(gchar * string);
gchar *strip_common_path(char *to_filename, char *from_filename);
gchar *most_efficient_filename(gchar *filename);
gchar *create_relative_link_to(gchar * current_filepath, gchar * link_to_filepath);
gchar *create_full_path(gchar * filename, gchar *basedir);
gchar *ending_slash(gchar *dirname);
gint file_is_dir(gchar * filename);
gint file_exists_and_readable(gchar * filename);
gchar *bf_str_repeat(const gchar * str, gint number_of);
#endif /* __BF_LIB_H_ */
