/* Bluefish HTML Editor
 * wml.c - menu/toolbar callbacks, inserting functions, and other cool stuff 
 *
 * Copyright (C) 
 * 1998 Olivier Sessink and Chris Mazuc
 * 1999-2000 Olivier Sessink
 * 2000 Roland Steinbach
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Keep in mind that wml-stuff is case-sensitive!
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"
#include <locale.h>

#include <string.h>		/* strncpy() */

#include "bluefish.h"
#include "gtk_easy.h"
#include "html.h"
#include "wml.h"
#include "undo.h"
#include "document.h"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * 
why this incedible amount of includes for such a simple file?  (Olivier)
because I was too lazy to strip them (Roland)
I stripped them now (Olivier)
* * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* functions */
void carddialogok(GtkWidget * widget, gpointer data);
void postfielddialogok(GtkWidget * widget, gpointer data);
void vardialogok(GtkWidget * widget, gpointer data);
void godialogok(GtkWidget * widget, gpointer data);
void dodialogok(GtkWidget * widget, gpointer data);
void anchordialogok(GtkWidget * widget, gpointer data);
void accessdialogok(GtkWidget * widget, gpointer data);

/* variables */

GtkWidget *identry, *titleentry, *ontimerentry, *hrefentry, *refererentry, *methodentry, *enctypeentry, *nameentry, *optionalentry, *typeentry, *labelentry, *accesskeyentry, *domainentry, *pathentry;
gchar *stuff;

/* stuff in wml.h - used by the menus and toolbars */
void general_wml_cb(GtkWidget * widget, gpointer data)
{
	switch ((int) data) {
	case 1:
		insert_text("<p>", "</p>");
		break;
	case 2:
		insert_text("<br/>", "");
		break;
	case 3:
		insert_text("<i>", "</i>");
		break;
	case 4:
		insert_text("$nbsp", "");
		break;
	case 5:
		insert_text("<b>", "</b>");
		break;
	case 6:
		insert_text
			("<?xml version=\"1.0\"?>\n<DOCTYPE wml PUBLIC \"-//WAPFORUM/DTD wml 1.2//EN\" \"http://www.wapforum.org/DTD/wml_1.2.xml\">\n<wml>\n",
			 "\n</wml>");
		break;
	case 7:
		insert_text("<prev/>", "");
		break;
	case 8:
		insert_text("<refresh/>", "");
		break;
	case 9:
		insert_text("<noop/>", "");
		break;
	default:
		break;
	}
}



/************************************************************************/

void carddialog_cb(GtkWidget * widget, gpointer data)
{

	static gchar *tagitems[] = { "id", "title", "ontimer", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("WML Card"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);

	identry = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), identry, 1, 2, 0, 1);

	titleentry = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Title")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), titleentry, 1, 2, 1, 2);

	ontimerentry = entry_with_text(tagvalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("OnTimer")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), ontimerentry, 1, 2, 2, 3);


	create_buttons(GTK_SIGNAL_FUNC(carddialogok), (gpointer) replace_range);
}

/************************************************************************/

void postfielddialog_cb(GtkWidget * widget, gpointer data)
{

	static gchar *tagitems[] = { "id", "name", "value", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("WML Postfield"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);

	identry = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), identry, 1, 2, 0, 1);

	titleentry = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), titleentry, 1, 2, 1, 2);

	ontimerentry = entry_with_text(tagvalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), ontimerentry, 1, 2, 2, 3);


	create_buttons(GTK_SIGNAL_FUNC(postfielddialogok), (gpointer) replace_range);
}

/************************************************************************/

void vardialog_cb(GtkWidget * widget, gpointer data)
{

	static gchar *tagitems[] = { "id", "name", "value", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("WML Variable"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);

	identry = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), identry, 1, 2, 0, 1);

	titleentry = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), titleentry, 1, 2, 1, 2);

	ontimerentry = entry_with_text(tagvalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), ontimerentry, 1, 2, 2, 3);


	create_buttons(GTK_SIGNAL_FUNC(vardialogok), (gpointer) replace_range);
}

/************************************************************************/

void godialog_cb(GtkWidget * widget, gpointer data)
{
	GList *methodlist = NULL;
	GList *enctypelist = NULL;
	GList *refererlist = NULL;
	
	static gchar *tagitems[] = { "id", "href", "sendreferer", "method", "enctype", NULL };
	gchar *tagvalues[6];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("Go Dialog"));
	dialogtable = gtk_table_new(3, 6, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);

	identry = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), identry, 1, 2, 0, 1);

	hrefentry = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("HREF")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), hrefentry, 1, 2, 1, 2);

	refererlist = g_list_append(refererlist, "false");
	refererlist = g_list_append(refererlist, "true");
	refererentry = combo_with_popdown(tagvalues[2], refererlist, 1);
	g_list_free(refererlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Sendreferer")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(refererentry)), 1, 2, 2, 3);

	methodlist = g_list_append(methodlist, "get");
	methodlist = g_list_append(methodlist, "post");
	methodentry = combo_with_popdown(tagvalues[3], methodlist, 1);
	g_list_free(methodlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Method")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(methodentry)), 1, 2, 3, 4);

	enctypelist = g_list_append(enctypelist, "application/x-www-form-urlencoded");
	enctypelist = g_list_append(enctypelist, "multipart/form-data");
	enctypeentry = combo_with_popdown(tagvalues[4], enctypelist, 1);
	g_list_free(enctypelist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Enctype")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(enctypeentry)), 1, 2, 4, 5);

	create_buttons(GTK_SIGNAL_FUNC(godialogok), (gpointer) replace_range);
}

/************************************************************************/

void dodialog_cb(GtkWidget * widget, gpointer data)
{
	GList *typelist = NULL;
	GList *optionallist = NULL;
	
	static gchar *tagitems[] = { "id", "type", "label", "name", "optional", NULL };
	gchar *tagvalues[6];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("Do Dialog"));
	dialogtable = gtk_table_new(3, 8, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);

	identry = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), identry, 1, 2, 0, 1);

	typelist = g_list_append(typelist, "accept");
	typelist = g_list_append(typelist, "prev");
	typelist = g_list_append(typelist, "help");
	typelist = g_list_append(typelist, "reset");
	typelist = g_list_append(typelist, "options");
	typelist = g_list_append(typelist, "delete");
	typeentry = combo_with_popdown(tagvalues[1], typelist, 1);
	g_list_free(typelist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Type")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(typeentry)), 1, 2, 1, 2);

	labelentry = entry_with_text(tagvalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Label")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), labelentry, 1, 2, 2, 3);

	nameentry = entry_with_text(tagvalues[3], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), nameentry, 1, 2, 3, 4);

	optionallist = g_list_append(optionallist, "false");
	optionallist = g_list_append(optionallist, "true");
	optionalentry = combo_with_popdown(tagvalues[4], optionallist, 1);
	g_list_free(optionallist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Is Optional")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(optionalentry)), 1, 2, 4, 5);

	create_buttons(GTK_SIGNAL_FUNC(dodialogok), (gpointer) replace_range);
}

/************************************************************************/

void anchordialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "id", "title", "accesskey", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("Anchor Dialog"));
	dialogtable = gtk_table_new(3, 8, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);

	identry = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), identry, 1, 2, 0, 1);

	titleentry = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Title")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), titleentry, 1, 2, 1, 2);

	accesskeyentry = entry_with_text(tagvalues[2], 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Accesskey")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), accesskeyentry, 1, 2, 2, 3);

	create_buttons(GTK_SIGNAL_FUNC(anchordialogok), (gpointer) replace_range);
}

/************************************************************************/

void accessdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "id", "domain", "path", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("WML Access Dialog"));
	dialogtable = gtk_table_new(3, 8, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);

	identry = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), identry, 1, 2, 0, 1);

	domainentry = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Domain")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), domainentry, 1, 2, 1, 2);

	pathentry = entry_with_text(tagvalues[2], 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Path")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), pathentry, 1, 2, 2, 3);

	create_buttons(GTK_SIGNAL_FUNC(accessdialogok), (gpointer) replace_range);
}


/************************************************************************/
void carddialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, "<card", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(identry)))) {
		g_snprintf(tempstr, 1023, " id=\"%s\"", gtk_entry_get_text(GTK_ENTRY(identry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(titleentry)))) {
		g_snprintf(tempstr, 1023, " title=\"%s\"", gtk_entry_get_text(GTK_ENTRY(titleentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(ontimerentry)))) {
		g_snprintf(tempstr, 1023, " ontimer=\"%s\"", gtk_entry_get_text(GTK_ENTRY(ontimerentry)));
		strncat(stuff, tempstr, 1023);
	}
	strncat(stuff, ">\n", 1023);
	if (data == NULL) {
		insert_text(stuff, "\n</card>");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void postfielddialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, "<postfield", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(identry)))) {
		g_snprintf(tempstr, 1023, " id=\"%s\"", gtk_entry_get_text(GTK_ENTRY(identry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(titleentry)))) {
		g_snprintf(tempstr, 1023, " name=\"%s\"", gtk_entry_get_text(GTK_ENTRY(titleentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(ontimerentry)))) {
		g_snprintf(tempstr, 1023, " value=\"%s\"", gtk_entry_get_text(GTK_ENTRY(ontimerentry)));
		strncat(stuff, tempstr, 1023);
	}
	strncat(stuff, "/>", 1023);
	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void vardialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, "<setvar", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(identry)))) {
		g_snprintf(tempstr, 1023, " id=\"%s\"", gtk_entry_get_text(GTK_ENTRY(identry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(titleentry)))) {
		g_snprintf(tempstr, 1023, " name=\"%s\"", gtk_entry_get_text(GTK_ENTRY(titleentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(ontimerentry)))) {
		g_snprintf(tempstr, 1023, " value=\"%s\"", gtk_entry_get_text(GTK_ENTRY(ontimerentry)));
		strncat(stuff, tempstr, 1023);
	}
	strncat(stuff, "/>", 1023);
	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void godialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, "<go", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(identry)))) {
		g_snprintf(tempstr, 1023, " id=\"%s\"", gtk_entry_get_text(GTK_ENTRY(identry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(hrefentry)))) {
		g_snprintf(tempstr, 1023, " href=\"%s\"", gtk_entry_get_text(GTK_ENTRY(hrefentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(refererentry)->entry)))) {
		g_snprintf(tempstr, 1023, " sendreferer=\"%s\"", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(refererentry)->entry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(methodentry)->entry)))) {
		g_snprintf(tempstr, 1023, " method=\"%s\"", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(methodentry)->entry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(enctypeentry)->entry)))) {
		g_snprintf(tempstr, 1023, " enctype=\"%s\"", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(enctypeentry)->entry)));
		strncat(stuff, tempstr, 1023);
	}
	strncat(stuff, ">\n", 1023);
	if (data == NULL) {
		insert_text(stuff, "</go>");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void dodialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, "<do", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(identry)))) {
		g_snprintf(tempstr, 1023, " id=\"%s\"", gtk_entry_get_text(GTK_ENTRY(identry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(typeentry)->entry)))) {
		g_snprintf(tempstr, 1023, " type=\"%s\"", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(typeentry)->entry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(labelentry)))) {
		g_snprintf(tempstr, 1023, " label=\"%s\"", gtk_entry_get_text(GTK_ENTRY(labelentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(nameentry)))) {
		g_snprintf(tempstr, 1023, " name=\"%s\"", gtk_entry_get_text(GTK_ENTRY(nameentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(optionalentry)->entry)))) {
		g_snprintf(tempstr, 1023, " optional=\"%s\"", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(optionalentry)->entry)));
		strncat(stuff, tempstr, 1023);
	}
	strncat(stuff, ">\n", 1023);
	if (data == NULL) {
		insert_text(stuff, "</do>");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void anchordialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, "<anchor", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(identry)))) {
		g_snprintf(tempstr, 1023, " id=\"%s\"", gtk_entry_get_text(GTK_ENTRY(identry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(titleentry)))) {
		g_snprintf(tempstr, 1023, " title=\"%s\"", gtk_entry_get_text(GTK_ENTRY(titleentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(accesskeyentry)))) {
		g_snprintf(tempstr, 1023, " accesskey=\"%s\"", gtk_entry_get_text(GTK_ENTRY(accesskeyentry)));
		strncat(stuff, tempstr, 1023);
	}
	strncat(stuff, ">\n", 1023);
	if (data == NULL) {
		insert_text(stuff, "</anchor>");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void accessdialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, "<access", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(identry)))) {
		g_snprintf(tempstr, 1023, " id=\"%s\"", gtk_entry_get_text(GTK_ENTRY(identry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(domainentry)))) {
		g_snprintf(tempstr, 1023, " domain=\"%s\"", gtk_entry_get_text(GTK_ENTRY(domainentry)));
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(pathentry)))) {
		g_snprintf(tempstr, 1023, " path=\"%s\"", gtk_entry_get_text(GTK_ENTRY(pathentry)));
		strncat(stuff, tempstr, 1023);
	}
	strncat(stuff, ">\n", 1023);
	if (data == NULL) {
		insert_text(stuff, "</access>");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}
