/* Bluefish HTML Editor
 * document.c - this file contains the document code
 *
 * Copyright (C) 2000 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __DOCUMENT_H_
#define __DOCUMENT_H_

typedef struct {
	gint currentp;
	gshort selection;
	gint startp;
	gint endp;
	gfloat adj;
} Ttext_positions;

void document_set_fonts(gchar * textfontstring, gchar * labelfontstring, Tdocument * document);
void document_set_wrap(gint word_wrap, gint line_wrap, Tdocument * document);

void file_to_textbox(gchar * filename);
void textbox_to_file(gchar * filename);
void doc_insert_text_cb(GtkEditable * editable, const char *text, int len, int
						*pos, gpointer d);
void doc_delete_text_cb(GtkEditable * editable, int start, int end, gpointer d);
gboolean highlight_once(Tdocument * whichdoc);
void document_need_highlighting(Tdocument * whichdoc);
void destroy_current_document(void);
void copy_cb(GtkWidget * w, gpointer data);
void paste_cb(GtkWidget * w, gpointer data);
void cut_cb(GtkWidget * w, gpointer data);
void sel_all_cb(GtkWidget * w, gpointer data);
Ttext_positions get_positions(GtkWidget * textbox);
void restore_positions(Ttext_positions positions, GtkWidget * textbox);
void doc_replace_text(const gchar * newstring, gint pos, gint end, Tdocument *doc);
void replace_text(const gchar * newstring, gint pos, gint end);
void insert_text(const gchar * before, const gchar * after);
Tdocument *new_document(void);
gint position_to_linenum(gint position);
void doc_go_to_line(gint linenum, gint select_line);
void file_move_to_cb(GtkWidget * widget, gpointer data);
void iso8859_1_replace_cb(GtkWidget * widget, gpointer data);
void ascii_replace_cb(GtkWidget * widget, gpointer data);
#endif
