/* Bluefish HTML Editor
 * toolbars.c - the home of the many toolbars
 *
 * Copyright (C) 1998-1999 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <locale.h>
#include <libintl.h>

#include <string.h>
#include <dirent.h>
#include <sys/types.h>
/* #include <sys/param.h> */
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "config.h"
#include "bluefish.h"
#include "pixmaps.h"
#include "toolbars.h"
#include "callbacks.h"
#include "html.h"
#include "html2.h"
#include "interface.h"
#include "images.h"
#include "wizards.h"
#include "ref_dialog.h"
#include "configure.h"
#include "undo.h"
#include "snr.h"
#include "gtk_easy.h"
#include "debug.h"
#include "intl.h"


typedef struct {
	gchar *name;
	GList *entry_list;
	GtkWidget *item;
	GtkWidget *subtree;
} cust_main_menu_struct;

typedef struct {
	gchar *name;
	gchar *bef_html;
	gchar *aft_html;
	GtkWidget *item;
	GtkWidget *subtree;
	cust_main_menu_struct *main_entry;
} cust_menu_struct;

/* 
 * these widgets are NULL if the bars are not initialised yet,
 * they're !NULL after initialisation 
 */
GtkWidget *main_widget = NULL, *cust_widget = NULL, *html_widget = NULL;


GList *entry_list_list;
GtkWidget *entry1, *entry2, *entry3, *entry4;
/* cust_menu_struct *last_entry = NULL;
cust_main_menu_struct *last_main_entry = NULL; */


/***************************************************************************/
void toggle_html_toolbar_lcb(GtkWidget * w, gpointer data);
void toggle_main_toolbar_lcb(GtkWidget * w, gpointer data);
void hide_main_toolbar_cb(GtkWidget * w, gpointer data);
void hide_html_toolbar_cb(GtkWidget * w, gpointer data);
void show_main_toolbar_cb(GtkWidget * w, gpointer data);
void show_html_toolbar_cb(GtkWidget * w, gpointer data);
void make_main_toolbar(void);
void make_html_toolbar(void);
void flush_toolbar(gchar * labeltext, GtkWidget * toolbar, GtkWidget * notebook);
GtkWidget *new_pixmap(int type, GdkWindow * window, GdkColor * background);


/***************************************************************************/


/***************************************************************************/
/* takes care of inserting the special characters */

void toggle_html_toolbar_lcb(GtkWidget * w, gpointer data)
{
	if (GTK_WIDGET_VISIBLE(html_handle_box)) {
		hide_html_toolbar_cb(NULL, NULL);
	} else {
		show_html_toolbar_cb(NULL, NULL);
	}
}

void toggle_main_toolbar_lcb(GtkWidget * w, gpointer data)
{
	if (GTK_WIDGET_VISIBLE(handle_box)) {
		hide_main_toolbar_cb(NULL, NULL);
	} else {
		show_main_toolbar_cb(NULL, NULL);
	}
}

void hide_main_toolbar_cb(GtkWidget * w, gpointer data)
{
	gtk_widget_hide(handle_box);
}

void hide_html_toolbar_cb(GtkWidget * w, gpointer data)
{
	gtk_widget_hide(html_handle_box);
}

void show_main_toolbar_cb(GtkWidget * w, gpointer data)
{
	if (!main_widget) {
		make_main_toolbar();
	}
	gtk_widget_show(handle_box);
}

void show_html_toolbar_cb(GtkWidget * w, gpointer data)
{
	if (!html_widget) {
		make_html_toolbar();
	}
	gtk_widget_show(html_handle_box);
}

void make_main_toolbar(void)
{

	DEBUG_MSG("make_main_toolbar, started\n");
	main_widget = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_container_add(GTK_CONTAINER(handle_box), main_widget);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("New"), "",
							new_pixmap(000, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(file_new_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Open"), "",
							new_pixmap(001, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(file_open_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Save"), "",
							new_pixmap(002, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(file_save_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Save As"), "",
							new_pixmap(003, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(file_save_as_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Close"), "",
							new_pixmap(004, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(file_close_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(main_widget));
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Copy"), "",
							new_pixmap(005, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(copy_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Cut"), "",
							new_pixmap(006, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(cut_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Paste"), "",
							new_pixmap(007, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(paste_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Search"), "",
							new_pixmap(010, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(search_search_cmd_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL,
							_("Search and Replace"), "", new_pixmap(011,
																	main_v->main_window->window,
																	NULL), GTK_SIGNAL_FUNC(search_replace_cmd_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(main_widget));
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Undo"), "",
							new_pixmap(012, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(undo_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Redo"), "",
							new_pixmap(013, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(redo_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(main_widget));
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Configure"),
							"", new_pixmap(014, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(configure_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Print"), "", new_pixmap(015, main_v->main_window->window, NULL), NULL, NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(main_widget), NULL, _("Spellcheck"),
							"", new_pixmap(016, main_v->main_window->window, NULL), NULL, NULL);
	gtk_widget_show(main_widget);
	DEBUG_MSG("make_main_widget, end\n");
}

void make_html_toolbar(void)
{

/*
 * every item with a ... in the tooltip brings up a dialog, every item
 * without the ... in the tooltip will directly insert html code
 *
 */

	GtkWidget *html_toolbar;

	DEBUG_MSG("make_html_toolbar, started\n");
	html_widget = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(html_widget), GTK_POS_TOP);
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(html_widget), TRUE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(html_widget), TRUE);
	gtk_notebook_set_page(GTK_NOTEBOOK(html_widget), 0);
	gtk_container_add(GTK_CONTAINER(html_handle_box), html_widget);

	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("QuickStart..."), "", new_pixmap(100, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(quickstart), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("DTD..."),
							"", new_pixmap(185, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(dtd_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Head..."),
							"", new_pixmap(186, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(head_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Body..."),
							"", new_pixmap(101, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(body_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Bold"), "",
							new_pixmap(102, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 1);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Italic"), "",
							new_pixmap(103, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 2);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Underline"),
							"", new_pixmap(104, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 3);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Strikeout"),
							"", new_pixmap(105, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 4);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Paragraph"),
							"", new_pixmap(106, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 5);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Break"), "",
							new_pixmap(107, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 6);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Break and clear"), "",
							new_pixmap(108, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 41);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Non-breaking space"), "", new_pixmap(110,
																	main_v->main_window->window, NULL),
							GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 7);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Anchor..."),
							"", new_pixmap(111, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(quickanchor_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Rule..."),
							"", new_pixmap(112, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(quickrule_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Image..."),
							"", new_pixmap(113, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(image_insert_dialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							"Thumbnail...",
							"", new_pixmap(125, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(image_thumbnail_dialog_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Center"), "",
							new_pixmap(114, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 8);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Right Justify"), "", new_pixmap(115,
															   main_v->main_window->window, NULL),
							GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 9);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Comment"),
							"", new_pixmap(116, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 10);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("E-Mail..."),
							"", new_pixmap(117, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(email_cb), NULL);


	flush_toolbar(_(" Quick bar "), html_toolbar, html_widget);


	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Font..."),
							"", new_pixmap(118, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(fontdialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Base Font Size..."), "", new_pixmap(119,
																   main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(basefont_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Font Size +1"),
							"", new_pixmap(120, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 11);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Font Size -1"),
							"", new_pixmap(121, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 12);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Preformatted Text"), "", new_pixmap(122,
																   main_v->main_window->window,
																   NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 13);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Subscript"),
							"", new_pixmap(123, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 14);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Superscript"),
							"", new_pixmap(124, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 15);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Strong"), "",
							new_pixmap(102, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 16);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Emphasis"),
							"", new_pixmap(103, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 17);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Heading 1"),
							"", new_pixmap(127, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 18);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Heading 2"),
							"", new_pixmap(128, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 19);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Heading 3"),
							"", new_pixmap(129, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 20);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Heading 4"),
							"", new_pixmap(130, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 21);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Heading 5"),
							"", new_pixmap(131, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 22);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Heading 6"),
							"", new_pixmap(132, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 23);

	flush_toolbar(_(" Fonts "), html_toolbar, html_widget);

	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Table Wizard..."),
							"", new_pixmap(133, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(tablewizard), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Table..."),
							"", new_pixmap(134, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(tabledialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Table Row..."),
							"", new_pixmap(135, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(tablerowdialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Table Header..."), "", new_pixmap(136,
																 main_v->main_window->window,
																 NULL), GTK_SIGNAL_FUNC(tableheaddialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Table Data..."), "", new_pixmap(137,
															   main_v->main_window->window,
															   NULL), GTK_SIGNAL_FUNC(tabledatadialog_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Table"), "",
							new_pixmap(138, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 24);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Table Row"),
							"", new_pixmap(139, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 25);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Table Header"),
							"", new_pixmap(140, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 26);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Table Data"),
							"", new_pixmap(141, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 27);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Table Caption"), "", new_pixmap(142,
															   main_v->main_window->window,
															   NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 28);

	flush_toolbar(_(" Tables "), html_toolbar, html_widget);


	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Frame Wizard..."),
							"", new_pixmap(143, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(framewizard), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Frameset..."),
							"", new_pixmap(144, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(framesetdialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Frame..."),
							"", new_pixmap(145, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(framedialog_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Frameset"),
							"", new_pixmap(146, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 29);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Frame"), "",
							new_pixmap(147, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 30);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Noframes"),
							"", new_pixmap(148, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 31);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Base Target"),
							"", new_pixmap(149, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 32);

	flush_toolbar(_(" Frames "), html_toolbar, html_widget);

	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Form..."),
							"", new_pixmap(150, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(formdialog_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Submit..."),
							"", new_pixmap(151, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(submitdialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Reset..."),
							"", new_pixmap(152, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(resetdialog_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Text..."),
							"", new_pixmap(153, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(textdialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Hidden..."),
							"", new_pixmap(154, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(hiddendialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Textarea..."),
							"", new_pixmap(155, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(textareadialog_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Radio Button..."),
							"", new_pixmap(156, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(radiodialog_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Check Box..."),
							"", new_pixmap(157, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(checkdialog_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Select..."),
							"", new_pixmap(158, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(selectdialog_cb), NULL);
	flush_toolbar(_(" Forms "), html_toolbar, html_widget);

	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Quick List..."),
							"", new_pixmap(159, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(quicklist_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Unordered List"), "", new_pixmap(160,
																main_v->main_window->window,
																NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 33);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Ordered List"),
							"", new_pixmap(161, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 34);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("List Item"),
							"", new_pixmap(162, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 35);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Definition List"), "", new_pixmap(163,
																 main_v->main_window->window,
																 NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 36);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Definition Term"), "", new_pixmap(164,
																 main_v->main_window->window,
																 NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *)
							(gpointer *) 37);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Definition"),
							"", new_pixmap(165, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *)
							(gpointer *) 38);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Menu"), "",
							new_pixmap(166, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *)
							(gpointer *) 39);

	flush_toolbar(_(" Lists "), html_toolbar, html_widget);

	/* CSS toolbar */
	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Insert style in stylesheet..."),
							"", new_pixmap(180, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(insert_in_stylesheet), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Span..."),
							"", new_pixmap(181, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(insert_span), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Div..."),
							"", new_pixmap(182, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(insert_div), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Add class to tag..."),
							"", new_pixmap(183, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(insert_class), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Style"),
							"", new_pixmap(184, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 42);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Link to stylesheet"),
							"", new_pixmap(189, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 46);

	flush_toolbar(_(" CSS "), html_toolbar, html_widget);

	/* other toolbar */
	html_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Imagemap"),
							"", new_pixmap(167, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *)
							(gpointer *) 40);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Meta..."),
							"", new_pixmap(168, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(meta_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Embed..."),
							"", new_pixmap(169, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(embed_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("View in Netscape"), "",
							new_pixmap(170, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(view_in_netscape_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Select Colour..."), "",
							new_pixmap(171, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(sel_colour_cb), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("Insert Time..."), "",
							new_pixmap(172, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(insert_time_cb), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("PHP3 reference..."), "",
							new_pixmap(173, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(php3_dialog), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("SSI reference..."), "",
							new_pixmap(174, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(ssi_dialog), NULL);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL,
							_("RXML reference..."), "",
							new_pixmap(175, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(rxml_dialog), NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(html_toolbar));
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Javascript"),
							"", new_pixmap(188, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 44);
	gtk_toolbar_append_item(GTK_TOOLBAR(html_toolbar), NULL, _("Link to javascript"),
							"", new_pixmap(187, main_v->main_window->window, NULL), GTK_SIGNAL_FUNC(general_html_cb), (gpointer *) 45);
	flush_toolbar(_(" Other "), html_toolbar, html_widget);

	gtk_widget_show(html_widget);
	DEBUG_MSG("make_html_toolbar, end\n");
}


void flush_toolbar(gchar * labeltext, GtkWidget * toolbar, GtkWidget * notebook)
{
	GtkWidget *html_label;

	gtk_widget_show(toolbar);
	html_label = gtk_label_new(labeltext);
	gtk_widget_show(html_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), toolbar, html_label);
}




/* ------------------------------------------
 * These functions are only declared in the top of toolbars.c
 * they are only accessible from within this file
 * --------------------------------------------- */

GtkWidget *new_pixmap(int type, GdkWindow * window, GdkColor * background)
{
	GtkWidget *wpixmap;
	GdkPixmap *pixm = NULL;
	GdkBitmap *mask = NULL;
	/* editor toolbar stuff */
	switch (type) {
	case 000:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, new_xpm);
		break;
	case 001:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, open_xpm);
		break;
	case 002:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, save_xpm);
		break;
	case 003:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, save_as_xpm);
		break;
	case 004:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, close_xpm);
		break;
	case 005:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, copy_xpm);
		break;
	case 006:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cut_xpm);
		break;
	case 007:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, paste_xpm);
		break;
	case 010:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, search_xpm);
		break;
	case 011:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, search_replace_xpm);
		break;
	case 012:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, undo_xpm);
		break;
	case 013:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, redo_xpm);
		break;
	case 014:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, preferences_xpm);
		break;
	case 015:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, print_xpm);
		break;
	case 016:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, spellcheck_xpm);
		break;
		/* HTML toolbar stuff */
	case 100:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, quick_start_xpm);
		break;
	case 101:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, body_xpm);
		break;
	case 102:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, bold_xpm);
		break;
	case 103:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, italic_xpm);
		break;
	case 104:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, underline_xpm);
		break;
	case 105:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, strikeout_xpm);
		break;
	case 106:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, paragraph_xpm);
		break;
	case 107:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, break_xpm);
		break;
	case 108:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, breakall_xpm);
		break;
	case 110:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, nbsp_xpm);
		break;
	case 111:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, anchor_xpm);
		break;
	case 112:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, hrule_xpm);
		break;
	case 113:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, image_xpm);
		break;
	case 114:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, center_xpm);
		break;
	case 115:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, right_xpm);
		break;
	case 116:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, comment_xpm);
		break;
	case 117:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, email_xpm);
		break;
	case 118:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, font_xpm);
		break;
	case 119:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, font_base_xpm);
		break;
	case 120:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontp1_xpm);
		break;
	case 121:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontm1_xpm);
		break;
	case 122:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontpre_xpm);
		break;
	case 123:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontsub_xpm);
		break;
	case 124:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fontsuper_xpm);
		break;
	case 125:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, thumbnail_xpm);
		break;
	case 127:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth1_xpm);
		break;
	case 128:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth2_xpm);
		break;
	case 129:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth3_xpm);
		break;
	case 130:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth4_xpm);
		break;
	case 131:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth5_xpm);
		break;
	case 132:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, fonth6_xpm);
		break;
	case 133:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, tablewhiz_xpm);
		break;
	case 134:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_xpm);
		break;
	case 135:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_tr_xpm);
		break;
	case 136:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_th_xpm);
		break;
	case 137:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_td_xpm);
		break;
	case 138:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table2_xpm);
		break;
	case 139:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_tr2_xpm);
		break;
	case 140:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_th2_xpm);
		break;
	case 141:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_td2_xpm);
		break;
	case 142:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, table_capt_xpm);
		break;
	case 143:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, framewhiz_xpm);
		break;
	case 144:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frameset_xpm);
		break;
	case 145:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame_xpm);
		break;
	case 146:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frameset2_xpm);
		break;
	case 147:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame2_xpm);
		break;
	case 148:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame_no_xpm);
		break;
	case 149:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, frame_base_xpm);
		break;
	case 150:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_xpm);
		break;
	case 151:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_submit_xpm);
		break;
	case 152:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_reset_xpm);
		break;
	case 153:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_text_xpm);
		break;
	case 154:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_hidden_xpm);
		break;
	case 155:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_textarea_xpm);
		break;
	case 156:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_radio_xpm);
		break;
	case 157:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_check_xpm);
		break;
	case 158:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, form_select_xpm);
		break;
	case 159:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_xpm);
		break;
	case 160:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_ul_xpm);
		break;
	case 161:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_ol_xpm);
		break;
	case 162:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_li_xpm);
		break;
	case 163:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_dl_xpm);
		break;
	case 164:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_dt_xpm);
		break;
	case 165:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_dd_xpm);
		break;
	case 166:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, list_menu_xpm);
		break;
	case 167:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, image_map_xpm);
		break;
	case 168:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, meta_xpm);
		break;
	case 169:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, embed_xpm);
		break;
	case 170:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, netscape_xpm);
		break;
	case 171:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, color_select_xpm);
		break;
	case 172:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, time_xpm);
		break;
	case 173:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, php3_xpm);
		break;
	case 174:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, ssi_xpm);
		break;
	case 175:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, rxml_xpm);
		break;
	case 176:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, color_select_small_xpm);
		break;
	case 177:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, open_small_xpm);
		break;

	case 180:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssnewstyle_xpm);
		break;
	case 181:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssspan_xpm);
		break;
	case 182:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssdiv_xpm);
		break;
	case 183:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssclass_xpm);
		break;
	case 184:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cssstyle_xpm);
		break;
	case 185:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, dtd_xpm);
		break;
	case 186:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, head_xpm);
		break;
	case 187:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, linkjscript_xpm);
		break;
	case 188:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, jscript_xpm);
		break;
	case 189:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, linkstylesheet_xpm);
		break;

		/* everything else */
	case 200:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, help_xpm);
		break;
	case 201:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, yes_xpm);
		break;
	case 202:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, no_xpm);
		break;
	case 203:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, ok_xpm);
		break;
	case 204:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, cancel_xpm);
		break;

	case 300:
		pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, nothing_xpm);
		break;
	}

	wpixmap = gtk_pixmap_new(pixm, mask);
	gdk_pixmap_unref(pixm);
	return wpixmap;
}
