/* Bluefish HTML Editor
 * init.h --> all configurational options
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 * font selection code Copyright (C) 1999 MJ Ray
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __INIT_H_
#define __INIT_H_

#include <glib.h>
#include <gtk/gtkwidget.h>

/* assume netscape is on the path */
#define DEFAULT_BROWSER "netscape -remote OpenUrl\\(%s\\)"
#define DEFAULT_WEBLINT "weblint"
#define COMMAND_MAX 1024

typedef struct {
	gchar *command;
	GtkItemFactoryEntry entry;
} Texternal_menu;

/*
 * These values are pointers to the lists that are used in multiple 
 * combo widgets
 */
extern GList *positionlist;

/*
 * these are the functions in init.c that are used to parse config files
 */

gint chk_dir(gchar * name);
gint chk_link(gchar * src_name, gchar * dst_name);
gint chk_file(gchar * name, gchar * content);
gint check_directories();
GList *make_config_list_item(GList * config_list, void *pointer_to_var, unsigned char type_of_var, gchar * name_of_var);
gint save_config_file(GList * config_list, gchar * filename);
gint parse_config_file(GList * config_list, gchar * filename);
void parse_config_files();
void save_config_files();
void make_external_menu_entries(gint which_external);
gint rcfile_init();

#endif							/* __INIT_H_ */
