/* Bluefish HTML Editor
 * html.h - menu/toolbar callback prototypes
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __HTML_H_
#define __HTML_H_

typedef struct {
	gchar *item;
	gchar *value;
} Ttagitem;

typedef struct {
	GList *taglist;
	gint pos;
	gint len;
} Ttagpopup;


typedef struct {
	gint pos;
	gint len;
} Treplacerange;

Treplacerange *values_for_dialog(gchar * dialogitems[], gchar * dialogvalues[], gchar ** custom, Ttagpopup * data);
void parse_integer_for_dialog(gchar * valuestring, GtkWidget * spin, GtkWidget * entry, GtkWidget * checkbox);
void init_values_for_dialog(gchar * dialogitems[], gchar * dialogvalues[]);
void parse_integer_for_dialog(gchar * valuestring, GtkWidget * spin, GtkWidget * entry, GtkWidget * checkbox);
void parse_existence_for_dialog(gchar * valuestring, GtkWidget * checkbox);
gchar *insert_integer_if_spin(GtkWidget * spin, gchar * itemname, gchar * string2add2, GtkWidget * percentage);
gchar *insert_string_if_entry(GtkWidget * entry, gchar * itemname, gchar * string2add2);
void general_html_cb(GtkWidget * widget, gpointer data);
void dtd_cb(GtkWidget * widget, gpointer data);
void head_cb(GtkWidget * widget, gpointer data);
void body_cb(GtkWidget * widget, gpointer data);
void quickanchor_cb(GtkWidget * widget, gpointer data);
void quickrule_cb(GtkWidget * widget, gpointer data);
void email_cb(GtkWidget * widget, gpointer data);
void fontdialog_cb(GtkWidget * widget, gpointer data);
void basefont_cb(GtkWidget * widget, gpointer data);
void tabledialog_cb(GtkWidget * widget, gpointer data);
void tablerowdialog_cb(GtkWidget * widget, gpointer data);
void tableheaddialog_cb(GtkWidget * widget, gpointer data);
void tabledatadialog_cb(GtkWidget * widget, gpointer data);
void framesetdialog_cb(GtkWidget * widget, gpointer data);
void framedialog_cb(GtkWidget * widget, gpointer data);
void formdialog_cb(GtkWidget * widget, gpointer data);
void submitdialog_cb(GtkWidget * widget, gpointer data);
void resetdialog_cb(GtkWidget * widget, gpointer data);
void textdialog_cb(GtkWidget * widget, gpointer data);
void hiddendialog_cb(GtkWidget * widget, gpointer data);
void textareadialog_cb(GtkWidget * widget, gpointer data);
void radiodialog_cb(GtkWidget * widget, gpointer data);
void checkdialog_cb(GtkWidget * widget, gpointer data);
void selectdialog_cb(GtkWidget * widget, gpointer data);
void quicklist_cb(GtkWidget * widget, gpointer data);
void meta_cb(GtkWidget * widget, gpointer data);
void embed_cb(GtkWidget * widget, gpointer data);
void sel_colour_cb(GtkWidget * widget, gpointer data);
void insert_time_cb(GtkWidget * widget, gpointer data);

void create_buttons(GtkSignalFunc ok_func, gpointer ok_data);
void create_buttons(GtkSignalFunc ok_func, gpointer ok_data);
void create_dialog(int width, int height, gchar * title);
/* color select button function */
GtkWidget *color_but_new(GtkWidget * which_entry, GtkWidget * win);
/* file select button function */
GtkWidget *file_but_new(GtkWidget * which_entry, GtkWidget * win, gint full_pathname);

#endif							/* __HTML_H_ */
