/**
 * blenlib/BKE_bad_level_calls.h (mar-2001 nzc)
 *	
 * Stuff that definitely does not belong in the kernel! These will all
 * have to be removed in order to restore sanity.
 *
 * $Id: BKE_bad_level_calls.h,v 1.19 2005/10/22 14:05:24 ton Exp $ 
 *
 * ***** BEGIN GPL/BL DUAL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. The Blender
 * Foundation also sells licenses for use in proprietary software under
 * the Blender License.  See http://www.blender.org/BL/ for information
 * about this.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL/BL DUAL LICENSE BLOCK *****
 */
#ifndef BKE_BAD_LEVEL_CALLS_H
#define BKE_BAD_LEVEL_CALLS_H

/* blender.c */
void freeAllRad(void);
void free_editText(void);
void free_vertexpaint(void);

/* readfile.c */
struct PluginSeq;
void open_plugin_seq(struct PluginSeq *pis, char *seqname);
struct SpaceButs;
void set_rects_butspace(struct SpaceButs *buts);
struct SpaceImaSel;
void check_imasel_copy(struct SpaceImaSel *simasel);
struct ScrArea;
struct bScreen;
void unlink_screen(struct bScreen *sc);
void setscreen(struct bScreen *sc);
void force_draw_all(int);
  /* otherwise the WHILE_SEQ doesn't work */
struct Sequence;
struct ListBase;
void build_seqar(struct ListBase *seqbase, struct Sequence  ***seqar, int *totseq);

struct ID;
struct Script;
struct Text;
void BPY_do_pyscript (struct ID *id, short int event);
void BPY_clear_script (struct Script *script);
void BPY_free_compiled_text (struct Text *text);
void BPY_free_screen_spacehandlers (struct bScreen *sc);

/* writefile.c */
struct Oops;
void free_oops(struct Oops *oops);
void error(char *str, ...);

/* anim.c */
extern struct ListBase editNurb;

/* displist.c */
#include "DNA_world_types.h"	/* for render_types */
#include "render_types.h"
extern struct RE_Render R;
float Blinn_Spec(float *n, float *l, float *v, float a, float b, int);
float Phong_Spec(float *, float *, float *, int, int);
float CookTorr_Spec(float *n, float *l, float *v, int hard, int);
float Toon_Spec(float *n, float *l, float *v, float a, float b, int);
float WardIso_Spec(float *n, float *l, float *v, float a, int);

float Toon_Diff(float *n, float *l, float *v, float a, float b);
float OrenNayar_Diff(float *n, float *l, float *v, float rough);
float Minnaert_Diff(float nl, float *n, float *v, float a);

void add_to_diffuse(float *, ShadeInput *, float, float, float, float);
void ramp_diffuse_result(float *diff, ShadeInput *shi);
void do_specular_ramp(ShadeInput *shi, float is, float t, float *spec);
void ramp_spec_result(float *, float *, float *, ShadeInput *);

void mainqenter (unsigned short event, short val);
void waitcursor(int);
void allqueue(unsigned short event, short val);
#define REDRAWVIEW3D	0x4010
#define REDRAWBUTSEDIT	0x4019
struct Material;
extern struct Material defmaterial;

/* effect.c */
void    RE_jitterate1(float *jit1, float *jit2, int num, float rad1);
void    RE_jitterate2(float *jit1, float *jit2, int num, float rad2);

/* exotic.c */
void load_editMesh(void);
void make_editMesh(void);
struct EditMesh;
void free_editMesh(struct EditMesh *);
void free_editArmature(void);
void docentre_new(void);
int saveover(char *str);

/* image.c */
#include "DNA_image_types.h"
void free_realtime_image(Image *ima); // has to become a callback, opengl stuff
void RE_make_existing_file(char *name); // from render, but these funcs should be moved anyway 

/* ipo.c */
void copy_view3d_lock(short val);	// was a hack, to make scene layer ipo's possible

/* library.c */
void allspace(unsigned short event, short val) ;
#define OOPS_TEST             2

/* mball.c */
extern ListBase editelems;

/* object.c */
void BPY_free_scriptlink(ScriptLink *slink);
void BPY_copy_scriptlink(ScriptLink *scriptlink);
float *give_cursor(void);  // become a callback or argument
void exit_posemode(int freedata);

/* packedFile.c */
short pupmenu(char *instr);  // will be general callback

/* sca.c */
#define LEFTMOUSE    0x001	// because of mouse sensor

/* scene.c */
#include "DNA_sequence_types.h"
void free_editing(struct Editing *ed);	// scenes and sequences problem...
void BPY_do_all_scripts (short int event);
int BPY_call_importloader(char *name);

/* texture.c */
#define FLO 128
#define INT	96
struct EnvMap;
struct Tex;

void do_material_tex(ShadeInput *shi);
void externtex(struct MTex *mtex, float *vec, float *tin, float *tr, 
	float *tg, float *tb, float *ta);
void init_render_textures(void);
void end_render_textures(void);

void RE_free_envmap(struct EnvMap *env);      
void RE_free_envmapdata(struct EnvMap *env);
struct EnvMap *RE_copy_envmap(struct EnvMap *env);
int RE_envmaptex(struct Tex *tex, float *texvec, float *dxt, float *dyt);
extern char texstr[20][12];	/* buttons.c */


/* editsca.c */
void make_unique_prop_names(char *str);

/* DerivedMesh.c */
void bglBegin(int mode);
void bglVertex3fv(float *vec);
void bglVertex3f(float x, float y, float z);
void bglEnd(void);

struct DispListMesh;
struct Object;
struct DispListMesh *NewBooleanMeshDLM(struct Object *ob, struct Object *ob_select, int int_op_type);

#endif

