/*
			(c) Copyright 1998-2000 - Tord Jansson
			======================================

		This file is part of the BladeEnc MP3 Encoder, based on
		ISO's reference code for MPEG Layer 3 compression, and might
		contain smaller or larger sections that are directly taken
		from ISO's reference code.

		All changes to the ISO reference code herein are either
		copyrighted by Tord Jansson (tord.jansson@swipnet.se)
		or sublicensed to Tord Jansson by a third party.

	BladeEnc is free software; you can redistribute this file
	and/or modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	2000-03-13  Andr Piotrowski
*/

#include	"tables.h"





/*	========================================================================================  */
/*      L3 parameter tables                                                                   */
/*	========================================================================================  */



l3_parm_block			l3_parm[3] =
{

	{	/* sfreq_idx_44100 */

		{	/* psy_longBlock_44100_62 */

			63, /* cbmax_l */

			{	/* numlines_l */
				  1,  1,  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  2,  2,  2,
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  2,  3,  3,  3,  3,  3,  3,  3,  4,
				  4,  4,  5,  5,  5,  6,  6,  7,  7,
				  7,  9,  9,  9, 10, 10, 11, 14, 14,
				 15, 20, 20, 21, 27, 27, 36, 73, 18
			},
			{	/* minval */
				 24.5, 24.5, 24.5, 24.5, 24.5, 20.0, 20.0, 20.0, 20.0,
				 20.0, 20.0, 20.0, 18.0, 18.0, 18.0, 12.0,  6.0,  6.0,
				  3.0,  3.0,  3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0
			},
			{	/* qthr_l */
				   4.532,   4.532,   4.532,   0.904,   0.904,   0.090,   0.090,   0.029,   0.029,
				   0.029,   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,
				   0.018,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.036,
				   0.036,   0.036,   0.045,   0.045,   0.045,   0.054,   0.054,   0.063,   0.063,
				   0.063,   0.081,   0.081,   0.081,   0.180,   0.180,   0.198,   0.400,   0.400,
				   0.429,   1.808,   1.808,   1.898,  24.416,  24.416,  32.554, 660.124, 162.770
			},
#if 0  /* we compute the exact values  2000-03-13*/
			{	/* norm_l */
				 0.951, 0.700, 0.681, 0.675, 0.667, 0.665, 0.664, 0.664, 0.664,
				 0.655, 0.616, 0.597, 0.578, 0.541, 0.575, 0.856, 0.846, 0.840,
				 0.822, 0.800, 0.753, 0.704, 0.674, 0.640, 0.609, 0.566, 0.535,
				 0.531, 0.615, 0.686, 0.650, 0.612, 0.567, 0.520, 0.513, 0.557,
				 0.584, 0.570, 0.579, 0.585, 0.548, 0.536, 0.550, 0.532, 0.504,
				 0.496, 0.517, 0.527, 0.516, 0.497, 0.489, 0.502, 0.501, 0.491,
				 0.497, 0.504, 0.504, 0.495, 0.486, 0.484, 0.483, 0.475, 0.515
			},
#endif
			{	/* bval_l */
				  0.000,  0.431,  0.861,  1.292,  1.723,  2.153,  2.584,  3.015,  3.445,
				  3.876,  4.279,  4.670,  5.057,  5.416,  5.774,  6.422,  7.026,  7.609,
				  8.168,  8.710,  9.207,  9.662, 10.099, 10.515, 10.917, 11.293, 11.652,
				 11.997, 12.394, 12.850, 13.277, 13.681, 14.062, 14.411, 14.751, 15.119,
				 15.508, 15.883, 16.263, 16.654, 17.020, 17.374, 17.744, 18.104, 18.447,
				 18.782, 19.130, 19.487, 19.838, 20.179, 20.510, 20.852, 21.196, 21.531,
				 21.870, 22.214, 22.558, 22.898, 23.232, 23.564, 23.897, 24.229, 24.442 
			}

		},

		{	/* psy_shortBlock_44100_38 */

			39, /* cbmax_s */

			{	/* numlines_s */
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  3,  3,  3,
				  3,  3,  4,  4,  5,  5,  5,
				  7,  7,  7, 19,  0,  0,  0
			},
			{	/* qthr_s */
				   4.532,   0.904,   0.029,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.027,   0.027,   0.054,
				   0.054,   0.054,   0.114,   0.114,   0.452,   0.452,   0.452,
				   6.330,   6.330,   6.330, 171.813,   0.000,   0.000,   0.000
			},
#if 0  /* we compute the exact values  2000-03-13*/
			{	/* norm_s */
				 1.000, 0.983, 0.983, 0.982, 0.985, 0.983, 0.978,
				 0.967, 0.948, 0.930, 0.914, 0.870, 0.845, 0.800,
				 0.749, 0.701, 0.653, 0.590, 0.616, 0.860, 0.823,
				 0.762, 0.688, 0.612, 0.594, 0.658, 0.706, 0.660,
				 0.606, 0.565, 0.560, 0.579, 0.567, 0.534, 0.514,
				 0.520, 0.518, 0.507, 0.447, 0.000, 0.000, 0.000
			},
#endif
			{	/* SNR_s */
				 -8.240, -8.240, -8.240, -8.240, -8.240, -8.240, -8.240,
				 -8.240, -8.240, -8.240, -7.447, -7.447, -7.447, -7.447,
				 -7.447, -7.447, -7.447, -7.447, -7.447, -7.447, -6.990,
				 -6.990, -6.990, -6.990, -6.990, -6.990, -6.990, -6.990,
				 -6.990, -6.990, -6.020, -6.020, -6.020, -6.020, -5.229,
				 -5.229, -5.229, -5.229, -4.559,  0.000,  0.000,  0.000
			},
			{	/* bval_s */
				  0.000,  1.723,  3.445,  5.057,  6.422,  7.609,  8.710,
				  9.662, 10.515, 11.293, 12.009, 12.625, 13.210, 13.748,
				 14.241, 14.695, 15.125, 15.508, 15.891, 16.537, 17.112,
				 17.621, 18.073, 18.470, 18.849, 19.271, 19.741, 20.177,
				 20.576, 20.950, 21.316, 21.699, 22.078, 22.438, 22.782,
				 23.133, 23.484, 23.828, 24.173,  0.000,  0.000,  0.000
			}

		},

		{	/* psy_data3_44100_20 */

			{	/* cbw_l */
				  3,  3,  4,  3,  3,  1,  3,
				  3,  3,  3,  3,  3,  4,  3,
				  3,  3,  3,  3,  2,  2,  2
			},
			{	/* bu_l */
				  0,  4,  7, 11, 14, 17, 18,
				 21, 24, 27, 30, 33, 36, 40,
				 43, 46, 49, 52, 55, 57, 59
			},
			{	/* bo_l */
				  4,  7, 11, 14, 17, 18, 21,
				 24, 27, 30, 33, 36, 40, 43,
				 46, 49, 52, 55, 57, 59, 61
			},
			{	/* w1_l */
				 1.000, 0.944, 0.389, 0.833, 0.278, 0.861, 0.083,
				 0.417, 0.750, 0.194, 0.426, 0.463, 0.180, 0.900,
				 0.532, 0.376, 0.550, 0.448, 0.597, 0.357, 0.278
			},
			{	/* w2_l */
				 0.056, 0.611, 0.167, 0.722, 0.139, 0.917, 0.583,
				 0.250, 0.805, 0.574, 0.537, 0.819, 0.100, 0.468,
				 0.623, 0.450, 0.552, 0.403, 0.643, 0.722, 0.960
			}

		},

		{	/* psy_data4_44100_11 */

			{	/* cbw_s */
				  2,  2,  3,  3,  4,  5,
				  3,  4,  3,  3,  3,  2
			},
			{	/* bu_s */
				  0,  3,  5,  8, 11, 15,
				 20, 23, 27, 30, 33, 36
			},
			{	/* bo_s */
				  2,  5,  8, 11, 15, 20,
				 23, 27, 30, 33, 36, 38
			},
			{	/* w1_s */
				 1.000, 0.833, 0.167, 0.500, 0.833, 0.833,
				 0.750, 0.417, 0.944, 0.625, 0.700, 0.833
			},
			{	/* w2_s */
				 0.167, 0.833, 0.500, 0.167, 0.167, 0.250,
				 0.583, 0.055, 0.375, 0.300, 0.167, 1.000
			}

		}

	},

	{	/* sfreq_idx_48000 */

		{	/* psy_longBlock_48000_61 */

			62, /* cbmax_l */

			{	/* numlines_l */
				  1,  1,  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  2,  2,  3,  3,  3,  3,  3,  4,  4,
				  4,  4,  4,  5,  5,  5,  6,  7,  7,
				  8,  8,  8, 10, 10, 10, 13, 13, 14,
				 18, 18, 20, 25, 25, 35, 67, 67,  0
			},
			{	/* minval */
				 24.5, 24.5, 24.5, 24.5, 24.5, 20.0, 20.0, 20.0, 20.0,
				 20.0, 20.0, 18.0, 18.0, 18.0, 12.0, 12.0,  6.0,  6.0,
				  3.0,  3.0,  3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0
			},
			{	/* qthr_l */
				   4.532,   4.532,   4.532,   0.904,   0.904,   0.090,   0.090,   0.029,   0.029,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,
				   0.018,   0.018,   0.027,   0.027,   0.027,   0.027,   0.027,   0.036,   0.036,
				   0.036,   0.036,   0.036,   0.045,   0.045,   0.045,   0.054,   0.063,   0.063,
				   0.072,   0.072,   0.072,   0.180,   0.180,   0.180,   0.372,   0.372,   0.400,
				   1.627,   1.627,   1.808,  22.607,  22.607,  31.650, 605.867, 605.867,   0.000
			},
#if 0  /* we compute the exact values  2000-03-13*/
			{	/* norm_l */
				 0.970, 0.755, 0.738, 0.730, 0.724, 0.723, 0.723, 0.723, 0.718,
				 0.690, 0.660, 0.641, 0.600, 0.584, 0.532, 0.537, 0.857, 0.858,
				 0.853, 0.824, 0.778, 0.740, 0.709, 0.676, 0.632, 0.592, 0.553,
				 0.510, 0.513, 0.608, 0.673, 0.637, 0.586, 0.571, 0.616, 0.640,
				 0.598, 0.538, 0.512, 0.528, 0.517, 0.493, 0.499, 0.525, 0.541,
				 0.528, 0.510, 0.506, 0.525, 0.536, 0.518, 0.501, 0.497, 0.497,
				 0.495, 0.494, 0.497, 0.494, 0.487, 0.483, 0.482, 0.524, 0.000
			},
#endif
			{	/* bval_l */
				  0.000,  0.469,  0.938,  1.406,  1.875,  2.344,  2.813,  3.281,  3.750,
				  4.199,  4.625,  5.047,  5.438,  5.828,  6.188,  6.522,  7.174,  7.801,
				  8.402,  8.966,  9.484,  9.966, 10.426, 10.866, 11.279, 11.669, 12.042,
				 12.386, 12.721, 13.115, 13.562, 13.984, 14.371, 14.741, 15.140, 15.563,
				 15.962, 16.324, 16.665, 17.020, 17.373, 17.708, 18.045, 18.398, 18.762,
				 19.120, 19.466, 19.807, 20.159, 20.522, 20.874, 21.214, 21.553, 21.892,
				 22.231, 22.569, 22.909, 23.248, 23.583, 23.915, 24.246, 24.576,  0.000
			}

		},

		{	/* psy_shortBlock_48000_37 */

			38, /* cbmax_s */

			{	/* numlines_s */
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  2,  3,  3,
				  3,  4,  4,  5,  5,  5,  7,
				  7, 11, 17,  0,  0,  0,  0
			},
			{	/* qthr_s */
				   4.532,   0.904,   0.029,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.054,   0.054,
				   0.054,   0.114,   0.114,   0.452,   0.452,   0.452,   6.330,
				   6.330,   9.947, 153.727,   0.000,   0.000,   0.000,   0.000
			},
#if 0  /* we compute the exact values  2000-03-13*/
			{	/* norm_s */
				 1.000, 0.989, 0.989, 0.981, 0.985, 0.984, 0.980,
				 0.968, 0.954, 0.929, 0.906, 0.883, 0.844, 0.792,
				 0.747, 0.689, 0.644, 0.592, 0.553, 0.850, 0.811,
				 0.736, 0.665, 0.610, 0.544, 0.528, 0.621, 0.673,
				 0.635, 0.626, 0.636, 0.615, 0.579, 0.551, 0.552,
				 0.559, 0.528, 0.479, 0.000, 0.000, 0.000, 0.000
			},
#endif
			{	/* SNR_s */
				 -8.240, -8.240, -8.240, -8.240, -8.240, -8.240, -8.240,
				 -8.240, -8.240, -8.240, -7.447, -7.447, -7.447, -7.447,
				 -7.447, -7.447, -7.447, -7.447, -7.447, -7.447, -6.990,
				 -6.990, -6.990, -6.990, -6.990, -6.990, -6.990, -6.990,
				 -6.990, -6.990, -6.020, -6.020, -6.020, -6.020, -5.229,
				 -5.229, -5.229, -5.229,  0.000,  0.000,  0.000,  0.000
			},
			{	/* bval_s */
				  0.000,  1.875,  3.750,  5.438,  6.857,  8.109,  9.237,
				 10.202, 11.083, 11.865, 12.554, 13.195, 13.781, 14.309,
				 14.803, 15.250, 15.667, 16.068, 16.409, 17.045, 17.607,
				 18.097, 18.528, 18.931, 19.295, 19.636, 20.038, 20.486,
				 20.900, 21.306, 21.722, 22.128, 22.513, 22.877, 23.241,
				 23.616, 23.974, 24.313,  0.000,  0.000,  0.000,  0.000
			}

		},

		{	/* psy_data3_48000_20 */

			{	/* cbw_l */
				  3,  3,  4,  3,  3,  2,  3,
				  2,  3,  3,  3,  3,  4,  3,
				  3,  3,  3,  2,  3,  2,  1
			},
			{	/* bu_l */
				  0,  4,  7, 11, 14, 17, 19,
				 22, 24, 27, 30, 33, 36, 40,
				 43, 46, 49, 52, 54, 57, 59
			},
			{	/* bo_l */
				  4,  7, 11, 14, 17, 19, 22,
				 24, 27, 30, 33, 36, 40, 43,
				 46, 49, 52, 54, 57, 59, 60
			},
			{	/* w1_l */
				 1.000, 0.944, 0.389, 0.833, 0.278, 0.361, 0.583,
				 0.917, 0.250, 0.583, 0.352, 0.389, 0.375, 0.856,
				 0.611, 0.840, 0.783, 0.816, 0.114, 0.687, 0.548
			},
			{	/* w2_l */
				 0.056, 0.611, 0.167, 0.722, 0.639, 0.417, 0.083,
				 0.750, 0.417, 0.648, 0.611, 0.625, 0.144, 0.389,
				 0.160, 0.217, 0.184, 0.886, 0.313, 0.452, 0.908
			}

		},

		{	/* psy_data4_48000_11 */

			{	/* cbw_s */
				  2,  2,  3,  3,  4,  4,
				  3,  4,  4,  2,  3,  2
			},
			{	/* bu_s */
				  0,  3,  5,  8, 11, 15,
				 19, 22, 26, 30, 32, 35
			},
			{	/* bo_s */
				  2,  5,  8, 11, 15, 19,
				 22, 26, 30, 32, 35, 37
			},
			{	/* w1_s */
				 1.000, 0.833, 0.167, 0.500, 0.833, 0.833,
				 0.417, 0.083, 0.055, 0.958, 0.433, 0.833
			},
			{	/* w2_s */
				 0.167, 0.833, 0.500, 0.167, 0.167, 0.583,
				 0.917, 0.944, 0.042, 0.567, 0.167, 0.618
			}

		}

	},

	{	/* sfreq_idx_32000 */

		{	/* psy_longBlock_32000_58 */

			59, /* cbmax_l */

			{	/* numlines_l */
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  3,  3,  3,  3,  3,  3,  3,  3,  3,
				  4,  4,  4,  5,  5,  5,  5,  5,  6,
				  6,  6,  8,  8,  8, 10, 10, 10, 12,
				 12, 13, 14, 14, 16, 20, 20, 23, 27,
				 27, 32, 37, 37, 12,  0,  0,  0,  0   
			},
			{	/* minval */
				 24.5, 24.5, 24.5, 20.0, 20.0, 20.0, 20.0, 20.0, 18.0,
				 18.0, 12.0, 12.0,  6.0,  6.0,  6.0,  3.0,  3.0,  3.0,
				  3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0
			},
			{	/* qthr_l */
				   4.532,   4.532,   1.809,   0.181,   0.181,   0.057,   0.018,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,
				   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,
				   0.036,   0.036,   0.036,   0.045,   0.045,   0.045,   0.045,   0.045,   0.054,
				   0.054,   0.054,   0.072,   0.072,   0.072,   0.090,   0.090,   0.090,   0.109,
				   0.109,   0.118,   0.252,   0.252,   0.288,   0.572,   0.572,   0.658,   2.441,
				   2.441,   2.893,  33.458,  33.458,  10.851,   0.000,   0.000,   0.000,   0.000
			},
#if 0  /* we compute the exact values  2000-03-13*/
			{	/* norm_l */
				 0.997, 0.893, 0.881, 0.873, 0.872, 0.871, 0.860, 0.839, 0.812,
				 0.784, 0.741, 0.697, 0.674, 0.651, 0.633, 0.611, 0.589, 0.575,
				 0.654, 0.724, 0.701, 0.673, 0.631, 0.592, 0.553, 0.510, 0.506,
				 0.562, 0.598, 0.589, 0.607, 0.620, 0.580, 0.532, 0.517, 0.517,
				 0.509, 0.506, 0.522, 0.531, 0.519, 0.512, 0.509, 0.498, 0.494,
				 0.501, 0.508, 0.502, 0.493, 0.497, 0.506, 0.510, 0.504, 0.496,
				 0.493, 0.490, 0.482, 0.458, 0.500, 0.000, 0.000, 0.000, 0.000
			},
#endif
			{	/* bval_l */
				  0.313,  0.938,  1.563,  2.188,  2.813,  3.438,  4.045,  4.625,  5.173,
				  5.698,  6.185,  6.634,  7.070,  7.492,  7.905,  8.305,  8.695,  9.064,
				  9.484,  9.966, 10.426, 10.866, 11.279, 11.669, 12.042, 12.386, 12.721,
				 13.091, 13.488, 13.873, 14.268, 14.679, 15.067, 15.424, 15.771, 16.120,
				 16.466, 16.807, 17.158, 17.518, 17.869, 18.215, 18.563, 18.902, 19.239,
				 19.580, 19.925, 20.269, 20.606, 20.944, 21.288, 21.635, 21.980, 22.319,
				 22.656, 22.993, 23.326, 23.656, 23.937,  0.000,  0.000,  0.000,  0.000
			}

		},

		{	/* psy_shortBlock_32000_41 */

			42, /* cbmax_s */

			{	/* numlines_s */
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  2,  2,  3,
				  3,  3,  3,  3,  4,  4,  4,
				  5,  5,  6,  7,  7,  8, 10
			},
			{	/* qthr_s */
				   4.532,   0.904,   0.090,   0.029,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.027,
				   0.027,   0.027,   0.027,   0.027,   0.072,   0.072,   0.072,
				   0.143,   0.143,   0.172,   0.633,   0.633,   0.723,   9.043
			},
#if 0  /* we compute the exact values  2000-03-13*/
			{	/* norm_s */
				 1.000, 0.985, 0.983, 0.983, 0.981, 0.975, 0.959,
				 0.944, 0.933, 0.920, 0.892, 0.863, 0.839, 0.786,
				 0.755, 0.698, 0.673, 0.605, 0.629, 0.883, 0.858,
				 0.829, 0.767, 0.705, 0.637, 0.564, 0.550, 0.603,
				 0.635, 0.592, 0.533, 0.518, 0.568, 0.594, 0.568,
				 0.536, 0.522, 0.542, 0.539, 0.519, 0.514, 0.518
			},
#endif
			{	/* SNR_s */
				 -8.240, -8.240, -8.240, -8.240, -8.240, -8.240, -8.240,
				 -8.240, -8.240, -8.240, -7.447, -7.447, -7.447, -7.447,
				 -7.447, -7.447, -7.447, -7.447, -7.447, -7.447, -6.990,
				 -6.990, -6.990, -6.990, -6.990, -6.990, -6.990, -6.990,
				 -6.990, -6.990, -6.020, -6.020, -6.020, -6.020, -5.229,
				 -5.229, -5.229, -5.229, -4.559, -4.559, -3.980, -3.980
			},
			{	/* bval_s */
				  0.000,  1.250,  2.500,  3.750,  4.909,  5.958,  6.857,
				  7.700,  8.500,  9.237,  9.895, 10.500, 11.083, 11.604,
				 12.107, 12.554, 13.000, 13.391, 13.781, 14.474, 15.096,
				 15.667, 16.177, 16.636, 17.057, 17.429, 17.786, 18.177,
				 18.597, 18.994, 19.352, 19.693, 20.066, 20.462, 20.841,
				 21.201, 21.549, 21.911, 22.275, 22.625, 22.971, 23.321
			}

		},

		{	/* psy_data3_32000_20 */

			{	/* cbw_l */
				  1,  2,  2,  1,  2,  2,  3,
				  2,  3,  3,  4,  4,  4,  3,
				  4,  3,  4,  3,  3,  2,  2
			},
			{	/* bu_l */
				  0,  2,  4,  6,  7,  9, 11,
				 14, 16, 19, 22, 26, 30, 34,
				 37, 41, 44, 48, 51, 54, 56
			},
			{	/* bo_l */
				  2,  4,  6,  7,  9, 11, 14,
				 16, 19, 22, 26, 30, 34, 37,
				 41, 44, 48, 51, 54, 56, 58
			},
			{	/* w1_l */
				 1.000, 0.472, 0.694, 0.917, 0.139, 0.361, 0.583,
				 0.917, 0.250, 0.130, 0.167, 0.611, 0.522, 0.967,
				 0.083, 0.383, 0.005, 0.726, 0.519, 0.739, 0.116
			},
			{	/* w2_l */
				 0.528, 0.305, 0.083, 0.861, 0.639, 0.417, 0.083,
				 0.750, 0.870, 0.833, 0.389, 0.478, 0.033, 0.917,
				 0.617, 0.995, 0.274, 0.480, 0.261, 0.884, 1.000
			}

		},

		{	/* psy_data4_32000_11 */

			{	/* cbw_s */
				  2,  2,  3,  3,  4,  5,
				  4,  5,  4,  4,  3,  1
			},
			{	/* bu_s */
				  0,  3,  5,  8, 11, 15,
				 20, 24, 29, 33, 37, 40
			},
			{	/* bo_s */
				  2,  5,  8, 11, 15, 20,
				 24, 29, 33, 37, 40, 41
			},
			{	/* w1_s */
				 1.000, 0.833, 0.167, 0.500, 0.833, 0.833,
				 0.750, 0.750, 0.944, 0.625, 0.528, 0.062
			},
			{	/* w2_s */
				 0.167, 0.833, 0.500, 0.167, 0.167, 0.250,
				 0.250, 0.055, 0.375, 0.472, 0.937, 1.000
			}

		}

	}

};




#if 0   /* The old parameter tables */

psyDataElem		psy_longBlock_48000_61[62] =
{
	{ 1 ,24.5 ,   4.532 ,0.970 ,   0.000 },
	{ 1 ,24.5 ,   4.532 ,0.755 ,   0.469 },
	{ 1 ,24.5 ,   4.532 ,0.738 ,   0.938 },
	{ 1 ,24.5 ,   0.904 ,0.730 ,   1.406 },
	{ 1 ,24.5 ,   0.904 ,0.724 ,   1.875 },
	{ 1 ,20.0 ,   0.090 ,0.723 ,   2.344 },
	{ 1 ,20.0 ,   0.090 ,0.723 ,   2.813 },
	{ 1 ,20.0 ,   0.029 ,0.723 ,   3.281 },
	{ 1 ,20.0 ,   0.029 ,0.718 ,   3.750 },
	{ 1 ,20.0 ,   0.009 ,0.690 ,   4.199 },
	{ 1 ,20.0 ,   0.009 ,0.660 ,   4.625 },
	{ 1 ,18.0 ,   0.009 ,0.641 ,   5.047 },
	{ 1 ,18.0 ,   0.009 ,0.600 ,   5.438 },
	{ 1 ,18.0 ,   0.009 ,0.584 ,   5.828 },
	{ 1 ,12.0 ,   0.009 ,0.532 ,   6.188 },
	{ 1 ,12.0 ,   0.009 ,0.537 ,   6.522 },
	{ 2 , 6.0 ,   0.018 ,0.857 ,   7.174 },
	{ 2 , 6.0 ,   0.018 ,0.858 ,   7.801 },
	{ 2 , 3.0 ,   0.018 ,0.853 ,   8.402 },
	{ 2 , 3.0 ,   0.018 ,0.824 ,   8.966 },
	{ 2 , 3.0 ,   0.018 ,0.778 ,   9.484 },
	{ 2 , 3.0 ,   0.018 ,0.740 ,   9.966 },
	{ 2 , 0.0 ,   0.018 ,0.709 ,  10.426 },

	{ 2 , 0.0 ,   0.018 ,0.676 ,  10.866 },
	{ 2 , 0.0 ,   0.018 ,0.632 ,  11.279 },
	{ 2 , 0.0 ,   0.018 ,0.592 ,  11.669 },
	{ 2 , 0.0 ,   0.018 ,0.553 ,  12.042 },
	{ 2 , 0.0 ,   0.018 ,0.510 ,  12.386 },
	{ 2 , 0.0 ,   0.018 ,0.513 ,  12.721 },
	{ 3 , 0.0 ,   0.027 ,0.608 ,  13.115 },
	{ 3 , 0.0 ,   0.027 ,0.673 ,  13.562 },
	{ 3 , 0.0 ,   0.027 ,0.637 ,  13.984 },
	{ 3 , 0.0 ,   0.027 ,0.586 ,  14.371 },
	{ 3 , 0.0 ,   0.027 ,0.571 ,  14.741 },
	{ 4 , 0.0 ,   0.036 ,0.616 ,  15.140 },
	{ 4 , 0.0 ,   0.036 ,0.640 ,  15.563 },
	{ 4 , 0.0 ,   0.036 ,0.598 ,  15.962 },
	{ 4 , 0.0 ,   0.036 ,0.538 ,  16.324 },
	{ 4 , 0.0 ,   0.036 ,0.512 ,  16.665 },
	{ 5 , 0.0 ,   0.045 ,0.528 ,  17.020 },
	{ 5 , 0.0 ,   0.045 ,0.517 ,  17.373 },
	{ 5 , 0.0 ,   0.045 ,0.493 ,  17.708 },
	{ 6 , 0.0 ,   0.054 ,0.499 ,  18.045 },
	{ 7 , 0.0 ,   0.063 ,0.525 ,  18.398 },
	{ 7 , 0.0 ,   0.063 ,0.541 ,  18.762 },
	{ 8 , 0.0 ,   0.072 ,0.528 ,  19.120 },
	{ 8 , 0.0 ,   0.072 ,0.510 ,  19.466 },
	{ 8 , 0.0 ,   0.072 ,0.506 ,  19.807 },
	{10 , 0.0 ,   0.180 ,0.525 ,  20.159 },
	{10 , 0.0 ,   0.180 ,0.536 ,  20.522 },
	{10 , 0.0 ,   0.180 ,0.518 ,  20.874 },
	{13 , 0.0 ,   0.372 ,0.501 ,  21.214 },
	{13 , 0.0 ,   0.372 ,0.497 ,  21.553 },
	{14 , 0.0 ,   0.400 ,0.497 ,  21.892 },
	{18 , 0.0 ,   1.627 ,0.495 ,  22.231 },
	{18 , 0.0 ,   1.627 ,0.494 ,  22.569 },
	{20 , 0.0 ,   1.808 ,0.497 ,  22.909 },
	{25 , 0.0 ,  22.607 ,0.494 ,  23.248 },
	{25 , 0.0 ,  22.607 ,0.487 ,  23.583 },
	{35 , 0.0 ,  31.650 ,0.483 ,  23.915 },
	{67 , 0.0 , 605.867 ,0.482 ,  24.246 },
	{67 , 0.0 , 605.867 ,0.524 ,  24.576 } 
};


psyDataElem		psy_longBlock_44100_62[63] =
{
	{ 1 ,24.5 ,   4.532 ,0.951 ,   0.000 },
	{ 1 ,24.5 ,   4.532 ,0.700 ,   0.431 },
	{ 1 ,24.5 ,   4.532 ,0.681 ,   0.861 },
	{ 1 ,24.5 ,   0.904 ,0.675 ,   1.292 },
	{ 1 ,24.5 ,   0.904 ,0.667 ,   1.723 },
	{ 1 ,20.0 ,   0.090 ,0.665 ,   2.153 },
	{ 1 ,20.0 ,   0.090 ,0.664 ,   2.584 },
	{ 1 ,20.0 ,   0.029 ,0.664 ,   3.015 },
	{ 1 ,20.0 ,   0.029 ,0.664 ,   3.445 },
	{ 1 ,20.0 ,   0.029 ,0.655 ,   3.876 },
	{ 1 ,20.0 ,   0.009 ,0.616 ,   4.279 },
	{ 1 ,20.0 ,   0.009 ,0.597 ,   4.670 },
	{ 1 ,18.0 ,   0.009 ,0.578 ,   5.057 },
	{ 1 ,18.0 ,   0.009 ,0.541 ,   5.416 },
	{ 1 ,18.0 ,   0.009 ,0.575 ,   5.774 },
	{ 2 ,12.0 ,   0.018 ,0.856 ,   6.422 },
	{ 2 , 6.0 ,   0.018 ,0.846 ,   7.026 },
	{ 2 , 6.0 ,   0.018 ,0.840 ,   7.609 },
	{ 2 , 3.0 ,   0.018 ,0.822 ,   8.168 },
	{ 2 , 3.0 ,   0.018 ,0.800 ,   8.710 },
	{ 2 , 3.0 ,   0.018 ,0.753 ,   9.207 },
	{ 2 , 3.0 ,   0.018 ,0.704 ,   9.662 },
	{ 2 , 0.0 ,   0.018 ,0.674 ,  10.099 },
	{ 2 , 0.0 ,   0.018 ,0.640 ,  10.515 },
	{ 2 , 0.0 ,   0.018 ,0.609 ,  10.917 },
	{ 2 , 0.0 ,   0.018 ,0.566 ,  11.293 },
	{ 2 , 0.0 ,   0.018 ,0.535 ,  11.652 },
	{ 2 , 0.0 ,   0.018 ,0.531 ,  11.997 },
	{ 3 , 0.0 ,   0.027 ,0.615 ,  12.394 },
	{ 3 , 0.0 ,   0.027 ,0.686 ,  12.850 },
	{ 3 , 0.0 ,   0.027 ,0.650 ,  13.277 },
	{ 3 , 0.0 ,   0.027 ,0.612 ,  13.681 },
	{ 3 , 0.0 ,   0.027 ,0.567 ,  14.062 },
	{ 3 , 0.0 ,   0.027 ,0.520 ,  14.411 },
	{ 3 , 0.0 ,   0.027 ,0.513 ,  14.751 },
	{ 4 , 0.0 ,   0.036 ,0.557 ,  15.119 },
	{ 4 , 0.0 ,   0.036 ,0.584 ,  15.508 },
	{ 4 , 0.0 ,   0.036 ,0.570 ,  15.883 },
	{ 5 , 0.0 ,   0.045 ,0.579 ,  16.263 },
	{ 5 , 0.0 ,   0.045 ,0.585 ,  16.654 },
	{ 5 , 0.0 ,   0.045 ,0.548 ,  17.020 },
	{ 6 , 0.0 ,   0.054 ,0.536 ,  17.374 },
	{ 6 , 0.0 ,   0.054 ,0.550 ,  17.744 },
	{ 7 , 0.0 ,   0.063 ,0.532 ,  18.104 },
	{ 7 , 0.0 ,   0.063 ,0.504 ,  18.447 },
	{ 7 , 0.0 ,   0.063 ,0.496 ,  18.782 },
	{ 9 , 0.0 ,   0.081 ,0.517 ,  19.130 },
	{ 9 , 0.0 ,   0.081 ,0.527 ,  19.487 },
	{ 9 , 0.0 ,   0.081 ,0.516 ,  19.838 },
	{10 , 0.0 ,   0.180 ,0.497 ,  20.179 },
	{10 , 0.0 ,   0.180 ,0.489 ,  20.510 },
	{11 , 0.0 ,   0.198 ,0.502 ,  20.852 },
	{14 , 0.0 ,   0.400 ,0.501 ,  21.196 },
	{14 , 0.0 ,   0.400 ,0.491 ,  21.531 },
	{15 , 0.0 ,   0.429 ,0.497 ,  21.870 },
	{20 , 0.0 ,   1.808 ,0.504 ,  22.214 },
	{20 , 0.0 ,   1.808 ,0.504 ,  22.558 },
	{21 , 0.0 ,   1.898 ,0.495 ,  22.898 },
	{27 , 0.0 ,  24.416 ,0.486 ,  23.232 },
	{27 , 0.0 ,  24.416 ,0.484 ,  23.564 },
	{36 , 0.0 ,  32.554 ,0.483 ,  23.897 },
	{73 , 0.0 , 660.124 ,0.475 ,  24.229 },
	{18 , 0.0 , 162.770 ,0.515 ,  24.442 } 
};


psyDataElem		psy_longBlock__32000_58[59] =
{
	{ 2 ,24.5 ,   4.532 ,0.997 ,   0.313 },
	{ 2 ,24.5 ,   4.532 ,0.893 ,   0.938 },
	{ 2 ,24.5 ,   1.809 ,0.881 ,   1.563 },
	{ 2 ,20.0 ,   0.181 ,0.873 ,   2.188 },
	{ 2 ,20.0 ,   0.181 ,0.872 ,   2.813 },
	{ 2 ,20.0 ,   0.057 ,0.871 ,   3.438 },
	{ 2 ,20.0 ,   0.018 ,0.860 ,   4.045 },
	{ 2 ,20.0 ,   0.018 ,0.839 ,   4.625 },
	{ 2 ,18.0 ,   0.018 ,0.812 ,   5.173 },
	{ 2 ,18.0 ,   0.018 ,0.784 ,   5.698 },
	{ 2 ,12.0 ,   0.018 ,0.741 ,   6.185 },
	{ 2 ,12.0 ,   0.018 ,0.697 ,   6.634 },
	{ 2 , 6.0 ,   0.018 ,0.674 ,   7.070 },
	{ 2 , 6.0 ,   0.018 ,0.651 ,   7.492 },
	{ 2 , 6.0 ,   0.018 ,0.633 ,   7.905 },
	{ 2 , 3.0 ,   0.018 ,0.611 ,   8.305 },
	{ 2 , 3.0 ,   0.018 ,0.589 ,   8.695 },
	{ 2 , 3.0 ,   0.018 ,0.575 ,   9.064 },
	{ 3 , 3.0 ,   0.027 ,0.654 ,   9.484 },
	{ 3 , 3.0 ,   0.027 ,0.724 ,   9.966 },
	{ 3 , 0.0 ,   0.027 ,0.701 ,  10.426 },
	{ 3 , 0.0 ,   0.027 ,0.673 ,  10.866 },
	{ 3 , 0.0 ,   0.027 ,0.631 ,  11.279 },
	{ 3 , 0.0 ,   0.027 ,0.592 ,  11.669 },
	{ 3 , 0.0 ,   0.027 ,0.553 ,  12.042 },
	{ 3 , 0.0 ,   0.027 ,0.510 ,  12.386 },
	{ 3 , 0.0 ,   0.027 ,0.506 ,  12.721 },
	{ 4 , 0.0 ,   0.036 ,0.562 ,  13.091 },
	{ 4 , 0.0 ,   0.036 ,0.598 ,  13.488 },
	{ 4 , 0.0 ,   0.036 ,0.589 ,  13.873 },
	{ 5 , 0.0 ,   0.045 ,0.607 ,  14.268 },
	{ 5 , 0.0 ,   0.045 ,0.620 ,  14.679 },
	{ 5 , 0.0 ,   0.045 ,0.580 ,  15.067 },
	{ 5 , 0.0 ,   0.045 ,0.532 ,  15.424 },
	{ 5 , 0.0 ,   0.045 ,0.517 ,  15.771 },
	{ 6 , 0.0 ,   0.054 ,0.517 ,  16.120 },
	{ 6 , 0.0 ,   0.054 ,0.509 ,  16.466 },
	{ 6 , 0.0 ,   0.054 ,0.506 ,  16.807 },
	{ 8 , 0.0 ,   0.072 ,0.522 ,  17.158 },
	{ 8 , 0.0 ,   0.072 ,0.531 ,  17.518 },
	{ 8 , 0.0 ,   0.072 ,0.519 ,  17.869 },
	{10 , 0.0 ,   0.090 ,0.512 ,  18.215 },
	{10 , 0.0 ,   0.090 ,0.509 ,  18.563 },
	{10 , 0.0 ,   0.090 ,0.498 ,  18.902 },
	{12 , 0.0 ,   0.109 ,0.494 ,  19.239 },
	{12 , 0.0 ,   0.109 ,0.501 ,  19.580 },
	{13 , 0.0 ,   0.118 ,0.508 ,  19.925 },
	{14 , 0.0 ,   0.252 ,0.502 ,  20.269 },
	{14 , 0.0 ,   0.252 ,0.493 ,  20.606 },
	{16 , 0.0 ,   0.288 ,0.497 ,  20.944 },
	{20 , 0.0 ,   0.572 ,0.506 ,  21.288 },
	{20 , 0.0 ,   0.572 ,0.510 ,  21.635 },
	{23 , 0.0 ,   0.658 ,0.504 ,  21.980 },
	{27 , 0.0 ,   2.441 ,0.496 ,  22.319 },
	{27 , 0.0 ,   2.441 ,0.493 ,  22.656 },
	{32 , 0.0 ,   2.893 ,0.490 ,  22.993 },
	{37 , 0.0 ,  33.458 ,0.482 ,  23.326 },
	{37 , 0.0 ,  33.458 ,0.458 ,  23.656 },
	{12 , 0.0 ,  10.851 ,0.500 ,  23.937 } 
};


psyDataElem2	psy_shortBlock_48000_37[38] =
{
	{ 1 ,   4.532 ,1.000 ,-8.240 ,   0.000 },
	{ 1 ,   0.904 ,0.989 ,-8.240 ,   1.875 },
	{ 1 ,   0.029 ,0.989 ,-8.240 ,   3.750 },
	{ 1 ,   0.009 ,0.981 ,-8.240 ,   5.438 },
	{ 1 ,   0.009 ,0.985 ,-8.240 ,   6.857 },
	{ 1 ,   0.009 ,0.984 ,-8.240 ,   8.109 },
	{ 1 ,   0.009 ,0.980 ,-8.240 ,   9.237 },
	{ 1 ,   0.009 ,0.968 ,-8.240 ,  10.202 },
	{ 1 ,   0.009 ,0.954 ,-8.240 ,  11.083 },
	{ 1 ,   0.009 ,0.929 ,-8.240 ,  11.865 },
	{ 1 ,   0.009 ,0.906 ,-7.447 ,  12.554 },
	{ 1 ,   0.009 ,0.883 ,-7.447 ,  13.195 },
	{ 1 ,   0.009 ,0.844 ,-7.447 ,  13.781 },
	{ 1 ,   0.009 ,0.792 ,-7.447 ,  14.309 },
	{ 1 ,   0.009 ,0.747 ,-7.447 ,  14.803 },
	{ 1 ,   0.009 ,0.689 ,-7.447 ,  15.250 },
	{ 1 ,   0.009 ,0.644 ,-7.447 ,  15.667 },
	{ 1 ,   0.009 ,0.592 ,-7.447 ,  16.068 },
	{ 1 ,   0.009 ,0.553 ,-7.447 ,  16.409 },
	{ 2 ,   0.018 ,0.850 ,-7.447 ,  17.045 },
	{ 2 ,   0.018 ,0.811 ,-6.990 ,  17.607 },
	{ 2 ,   0.018 ,0.736 ,-6.990 ,  18.097 },
	{ 2 ,   0.018 ,0.665 ,-6.990 ,  18.528 },
	{ 2 ,   0.018 ,0.610 ,-6.990 ,  18.931 },
	{ 2 ,   0.018 ,0.544 ,-6.990 ,  19.295 },
	{ 2 ,   0.018 ,0.528 ,-6.990 ,  19.636 },
	{ 3 ,   0.054 ,0.621 ,-6.990 ,  20.038 },
	{ 3 ,   0.054 ,0.673 ,-6.990 ,  20.486 },
	{ 3 ,   0.054 ,0.635 ,-6.990 ,  20.900 },
	{ 4 ,   0.114 ,0.626 ,-6.990 ,  21.306 },
	{ 4 ,   0.114 ,0.636 ,-6.020 ,  21.722 },
	{ 5 ,   0.452 ,0.615 ,-6.020 ,  22.128 },
	{ 5 ,   0.452 ,0.579 ,-6.020 ,  22.513 },
	{ 5 ,   0.452 ,0.551 ,-6.020 ,  22.877 },
	{ 7 ,   6.330 ,0.552 ,-5.229 ,  23.241 },
	{ 7 ,   6.330 ,0.559 ,-5.229 ,  23.616 },
	{11 ,   9.947 ,0.528 ,-5.229 ,  23.974 },
	{17 , 153.727 ,0.479 ,-5.229 ,  24.313 }
};

psyDataElem2	psy_shortBlock_44100_38[39] =
{
	{ 1 ,   4.532 ,1.000 ,-8.240 ,   0.000 },
	{ 1 ,   0.904 ,0.983 ,-8.240 ,   1.723 },
	{ 1 ,   0.029 ,0.983 ,-8.240 ,   3.445 },
	{ 1 ,   0.009 ,0.982 ,-8.240 ,   5.057 },
	{ 1 ,   0.009 ,0.985 ,-8.240 ,   6.422 },
	{ 1 ,   0.009 ,0.983 ,-8.240 ,   7.609 },
	{ 1 ,   0.009 ,0.978 ,-8.240 ,   8.710 },
	{ 1 ,   0.009 ,0.967 ,-8.240 ,   9.662 },
	{ 1 ,   0.009 ,0.948 ,-8.240 ,  10.515 },
	{ 1 ,   0.009 ,0.930 ,-8.240 ,  11.293 },
	{ 1 ,   0.009 ,0.914 ,-7.447 ,  12.009 },
	{ 1 ,   0.009 ,0.870 ,-7.447 ,  12.625 },
	{ 1 ,   0.009 ,0.845 ,-7.447 ,  13.210 },
	{ 1 ,   0.009 ,0.800 ,-7.447 ,  13.748 },
	{ 1 ,   0.009 ,0.749 ,-7.447 ,  14.241 },
	{ 1 ,   0.009 ,0.701 ,-7.447 ,  14.695 },
	{ 1 ,   0.009 ,0.653 ,-7.447 ,  15.125 },
	{ 1 ,   0.009 ,0.590 ,-7.447 ,  15.508 },
	{ 1 ,   0.009 ,0.616 ,-7.447 ,  15.891 },
	{ 2 ,   0.018 ,0.860 ,-7.447 ,  16.537 },
	{ 2 ,   0.018 ,0.823 ,-6.990 ,  17.112 },
	{ 2 ,   0.018 ,0.762 ,-6.990 ,  17.621 },
	{ 2 ,   0.018 ,0.688 ,-6.990 ,  18.073 },
	{ 2 ,   0.018 ,0.612 ,-6.990 ,  18.470 },
	{ 2 ,   0.018 ,0.594 ,-6.990 ,  18.849 },
	{ 3 ,   0.027 ,0.658 ,-6.990 ,  19.271 },
	{ 3 ,   0.027 ,0.706 ,-6.990 ,  19.741 },
	{ 3 ,   0.054 ,0.660 ,-6.990 ,  20.177 },
	{ 3 ,   0.054 ,0.606 ,-6.990 ,  20.576 },
	{ 3 ,   0.054 ,0.565 ,-6.990 ,  20.950 },
	{ 4 ,   0.114 ,0.560 ,-6.020 ,  21.316 },
	{ 4 ,   0.114 ,0.579 ,-6.020 ,  21.699 },
	{ 5 ,   0.452 ,0.567 ,-6.020 ,  22.078 },
	{ 5 ,   0.452 ,0.534 ,-6.020 ,  22.438 },
	{ 5 ,   0.452 ,0.514 ,-5.229 ,  22.782 },
	{ 7 ,   6.330 ,0.520 ,-5.229 ,  23.133 },
	{ 7 ,   6.330 ,0.518 ,-5.229 ,  23.484 },
	{ 7 ,   6.330 ,0.507 ,-5.229 ,  23.828 },
	{19 , 171.813 ,0.447 ,-4.559 ,  24.173 }
};

psyDataElem2	psy_shortBlock_32000_41[42] =
{
	{ 1 ,   4.532 ,1.000 ,-8.240 ,   0.000 },
	{ 1 ,   0.904 ,0.985 ,-8.240 ,   1.250 },
	{ 1 ,   0.090 ,0.983 ,-8.240 ,   2.500 },
	{ 1 ,   0.029 ,0.983 ,-8.240 ,   3.750 },
	{ 1 ,   0.009 ,0.981 ,-8.240 ,   4.909 },
	{ 1 ,   0.009 ,0.975 ,-8.240 ,   5.958 },
	{ 1 ,   0.009 ,0.959 ,-8.240 ,   6.857 },
	{ 1 ,   0.009 ,0.944 ,-8.240 ,   7.700 },
	{ 1 ,   0.009 ,0.933 ,-8.240 ,   8.500 },
	{ 1 ,   0.009 ,0.920 ,-8.240 ,   9.237 },
	{ 1 ,   0.009 ,0.892 ,-7.447 ,   9.895 },
	{ 1 ,   0.009 ,0.863 ,-7.447 ,  10.500 },
	{ 1 ,   0.009 ,0.839 ,-7.447 ,  11.083 },
	{ 1 ,   0.009 ,0.786 ,-7.447 ,  11.604 },
	{ 1 ,   0.009 ,0.755 ,-7.447 ,  12.107 },
	{ 1 ,   0.009 ,0.698 ,-7.447 ,  12.554 },
	{ 1 ,   0.009 ,0.673 ,-7.447 ,  13.000 },
	{ 1 ,   0.009 ,0.605 ,-7.447 ,  13.391 },
	{ 1 ,   0.009 ,0.629 ,-7.447 ,  13.781 },
	{ 2 ,   0.018 ,0.883 ,-7.447 ,  14.474 },
	{ 2 ,   0.018 ,0.858 ,-6.990 ,  15.096 },
	{ 2 ,   0.018 ,0.829 ,-6.990 ,  15.667 },
	{ 2 ,   0.018 ,0.767 ,-6.990 ,  16.177 },
	{ 2 ,   0.018 ,0.705 ,-6.990 ,  16.636 },
	{ 2 ,   0.018 ,0.637 ,-6.990 ,  17.057 },
	{ 2 ,   0.018 ,0.564 ,-6.990 ,  17.429 },
	{ 2 ,   0.018 ,0.550 ,-6.990 ,  17.786 },
	{ 3 ,   0.027 ,0.603 ,-6.990 ,  18.177 },
	{ 3 ,   0.027 ,0.635 ,-6.990 ,  18.597 },
	{ 3 ,   0.027 ,0.592 ,-6.990 ,  18.994 },
	{ 3 ,   0.027 ,0.533 ,-6.020 ,  19.352 },
	{ 3 ,   0.027 ,0.518 ,-6.020 ,  19.693 },
	{ 4 ,   0.072 ,0.568 ,-6.020 ,  20.066 },
	{ 4 ,   0.072 ,0.594 ,-6.020 ,  20.462 },
	{ 4 ,   0.072 ,0.568 ,-5.229 ,  20.841 },
	{ 5 ,   0.143 ,0.536 ,-5.229 ,  21.201 },
	{ 5 ,   0.143 ,0.522 ,-5.229 ,  21.549 },
	{ 6 ,   0.172 ,0.542 ,-5.229 ,  21.911 },
	{ 7 ,   0.633 ,0.539 ,-4.559 ,  22.275 },
	{ 7 ,   0.633 ,0.519 ,-4.559 ,  22.625 },
	{ 8 ,   0.723 ,0.514 ,-3.980 ,  22.971 },
	{10 ,   9.043 ,0.518 ,-3.980 ,  23.321 }
};


psyDataElem3	psy_data3_48000_20[21] =
{
	{ 3 , 0 , 4 ,(FLOAT)1.000 ,(FLOAT)0.056 },
	{ 3 , 4 , 7 ,(FLOAT)0.944 ,(FLOAT)0.611 },
	{ 4 , 7 ,11 ,(FLOAT)0.389 ,(FLOAT)0.167 },
	{ 3 ,11 ,14 ,(FLOAT)0.833 ,(FLOAT)0.722 },
	{ 3 ,14 ,17 ,(FLOAT)0.278 ,(FLOAT)0.639 },
	{ 2 ,17 ,19 ,(FLOAT)0.361 ,(FLOAT)0.417 },
	{ 3 ,19 ,22 ,(FLOAT)0.583 ,(FLOAT)0.083 },
	{ 2 ,22 ,24 ,(FLOAT)0.917 ,(FLOAT)0.750 },
	{ 3 ,24 ,27 ,(FLOAT)0.250 ,(FLOAT)0.417 },
	{ 3 ,27 ,30 ,(FLOAT)0.583 ,(FLOAT)0.648 },
	{ 3 ,30 ,33 ,(FLOAT)0.352 ,(FLOAT)0.611 },
	{ 3 ,33 ,36 ,(FLOAT)0.389 ,(FLOAT)0.625 },
	{ 4 ,36 ,40 ,(FLOAT)0.375 ,(FLOAT)0.144 },
	{ 3 ,40 ,43 ,(FLOAT)0.856 ,(FLOAT)0.389 },
	{ 3 ,43 ,46 ,(FLOAT)0.611 ,(FLOAT)0.160 },
	{ 3 ,46 ,49 ,(FLOAT)0.840 ,(FLOAT)0.217 },
	{ 3 ,49 ,52 ,(FLOAT)0.783 ,(FLOAT)0.184 },
	{ 2 ,52 ,54 ,(FLOAT)0.816 ,(FLOAT)0.886 },
	{ 3 ,54 ,57 ,(FLOAT)0.114 ,(FLOAT)0.313 },
	{ 2 ,57 ,59 ,(FLOAT)0.687 ,(FLOAT)0.452 },
	{ 1 ,59 ,60 ,(FLOAT)0.548 ,(FLOAT)0.908 }
};


psyDataElem3	psy_data3_44100_20[21] =
{
	{ 3 , 0 , 4 ,(FLOAT)1.000 ,(FLOAT)0.056 },
	{ 3 , 4 , 7 ,(FLOAT)0.944 ,(FLOAT)0.611 },
	{ 4 , 7 ,11 ,(FLOAT)0.389 ,(FLOAT)0.167 },
	{ 3 ,11 ,14 ,(FLOAT)0.833 ,(FLOAT)0.722 },
	{ 3 ,14 ,17 ,(FLOAT)0.278 ,(FLOAT)0.139 },
	{ 1 ,17 ,18 ,(FLOAT)0.861 ,(FLOAT)0.917 },
	{ 3 ,18 ,21 ,(FLOAT)0.083 ,(FLOAT)0.583 },
	{ 3 ,21 ,24 ,(FLOAT)0.417 ,(FLOAT)0.250 },
	{ 3 ,24 ,27 ,(FLOAT)0.750 ,(FLOAT)0.805 },
	{ 3 ,27 ,30 ,(FLOAT)0.194 ,(FLOAT)0.574 },
	{ 3 ,30 ,33 ,(FLOAT)0.426 ,(FLOAT)0.537 },
	{ 3 ,33 ,36 ,(FLOAT)0.463 ,(FLOAT)0.819 },
	{ 4 ,36 ,40 ,(FLOAT)0.180 ,(FLOAT)0.100 },
	{ 3 ,40 ,43 ,(FLOAT)0.900 ,(FLOAT)0.468 },
	{ 3 ,43 ,46 ,(FLOAT)0.532 ,(FLOAT)0.623 },
	{ 3 ,46 ,49 ,(FLOAT)0.376 ,(FLOAT)0.450 },
	{ 3 ,49 ,52 ,(FLOAT)0.550 ,(FLOAT)0.552 },
	{ 3 ,52 ,55 ,(FLOAT)0.448 ,(FLOAT)0.403 },
	{ 2 ,55 ,57 ,(FLOAT)0.597 ,(FLOAT)0.643 },
	{ 2 ,57 ,59 ,(FLOAT)0.357 ,(FLOAT)0.722 },
	{ 2 ,59 ,61 ,(FLOAT)0.278 ,(FLOAT)0.960 }
};


psyDataElem3	psy_data3_32000_20[21] =
{
	{ 1 , 0 , 2 ,(FLOAT)1.000 ,(FLOAT)0.528 },
	{ 2 , 2 , 4 ,(FLOAT)0.472 ,(FLOAT)0.305 },
	{ 2 , 4 , 6 ,(FLOAT)0.694 ,(FLOAT)0.083 },
	{ 1 , 6 , 7 ,(FLOAT)0.917 ,(FLOAT)0.861 },
	{ 2 , 7 , 9 ,(FLOAT)0.139 ,(FLOAT)0.639 },
	{ 2 , 9 ,11 ,(FLOAT)0.361 ,(FLOAT)0.417 },
	{ 3 ,11 ,14 ,(FLOAT)0.583 ,(FLOAT)0.083 },
	{ 2 ,14 ,16 ,(FLOAT)0.917 ,(FLOAT)0.750 },
	{ 3 ,16 ,19 ,(FLOAT)0.250 ,(FLOAT)0.870 },
	{ 3 ,19 ,22 ,(FLOAT)0.130 ,(FLOAT)0.833 },
	{ 4 ,22 ,26 ,(FLOAT)0.167 ,(FLOAT)0.389 },
	{ 4 ,26 ,30 ,(FLOAT)0.611 ,(FLOAT)0.478 },
	{ 4 ,30 ,34 ,(FLOAT)0.522 ,(FLOAT)0.033 },
	{ 3 ,34 ,37 ,(FLOAT)0.967 ,(FLOAT)0.917 },
	{ 4 ,37 ,41 ,(FLOAT)0.083 ,(FLOAT)0.617 },
	{ 3 ,41 ,44 ,(FLOAT)0.383 ,(FLOAT)0.995 },
	{ 4 ,44 ,48 ,(FLOAT)0.005 ,(FLOAT)0.274 },
	{ 3 ,48 ,51 ,(FLOAT)0.726 ,(FLOAT)0.480 },
	{ 3 ,51 ,54 ,(FLOAT)0.519 ,(FLOAT)0.261 },
	{ 2 ,54 ,56 ,(FLOAT)0.739 ,(FLOAT)0.884 },
	{ 2 ,56 ,58 ,(FLOAT)0.116 ,(FLOAT)1.000 }
};



psyDataElem3	psy_data4_48000_11[12] =
{
	{ 2 , 0 , 2 ,(FLOAT)1.000 ,(FLOAT)0.167 },
	{ 2 , 3 , 5 ,(FLOAT)0.833 ,(FLOAT)0.833 },
	{ 3 , 5 , 8 ,(FLOAT)0.167 ,(FLOAT)0.500 },
	{ 3 , 8 ,11 ,(FLOAT)0.500 ,(FLOAT)0.167 },
	{ 4 ,11 ,15 ,(FLOAT)0.833 ,(FLOAT)0.167 },
	{ 4 ,15 ,19 ,(FLOAT)0.833 ,(FLOAT)0.583 },
	{ 3 ,19 ,22 ,(FLOAT)0.417 ,(FLOAT)0.917 },
	{ 4 ,22 ,26 ,(FLOAT)0.083 ,(FLOAT)0.944 },
	{ 4 ,26 ,30 ,(FLOAT)0.055 ,(FLOAT)0.042 },
	{ 2 ,30 ,32 ,(FLOAT)0.958 ,(FLOAT)0.567 },
	{ 3 ,32 ,35 ,(FLOAT)0.433 ,(FLOAT)0.167 },
	{ 2 ,35 ,37 ,(FLOAT)0.833 ,(FLOAT)0.618 }
};


psyDataElem3	psy_data4_44100_11[12] =
{
	{ 2 , 0 , 2 ,(FLOAT)1.000 ,(FLOAT)0.167 },
	{ 2 , 3 , 5 ,(FLOAT)0.833 ,(FLOAT)0.833 },
	{ 3 , 5 , 8 ,(FLOAT)0.167 ,(FLOAT)0.500 },
	{ 3 , 8 ,11 ,(FLOAT)0.500 ,(FLOAT)0.167 },
	{ 4 ,11 ,15 ,(FLOAT)0.833 ,(FLOAT)0.167 },
	{ 5 ,15 ,20 ,(FLOAT)0.833 ,(FLOAT)0.250 },
	{ 3 ,20 ,23 ,(FLOAT)0.750 ,(FLOAT)0.583 },
	{ 4 ,23 ,27 ,(FLOAT)0.417 ,(FLOAT)0.055 },
	{ 3 ,27 ,30 ,(FLOAT)0.944 ,(FLOAT)0.375 },
	{ 3 ,30 ,33 ,(FLOAT)0.625 ,(FLOAT)0.300 },
	{ 3 ,33 ,36 ,(FLOAT)0.700 ,(FLOAT)0.167 },
	{ 2 ,36 ,38 ,(FLOAT)0.833 ,(FLOAT)1.000 }
};


psyDataElem3	psy_data4_32000_11[12] =
{
	{ 2 , 0 , 2 ,(FLOAT)1.000 ,(FLOAT)0.167 },
	{ 2 , 3 , 5 ,(FLOAT)0.833 ,(FLOAT)0.833 },
	{ 3 , 5 , 8 ,(FLOAT)0.167 ,(FLOAT)0.500 },
	{ 3 , 8 ,11 ,(FLOAT)0.500 ,(FLOAT)0.167 },
	{ 4 ,11 ,15 ,(FLOAT)0.833 ,(FLOAT)0.167 },
	{ 5 ,15 ,20 ,(FLOAT)0.833 ,(FLOAT)0.250 },
	{ 4 ,20 ,24 ,(FLOAT)0.750 ,(FLOAT)0.250 },
	{ 5 ,24 ,29 ,(FLOAT)0.750 ,(FLOAT)0.055 },
	{ 4 ,29 ,33 ,(FLOAT)0.944 ,(FLOAT)0.375 },
	{ 4 ,33 ,37 ,(FLOAT)0.625 ,(FLOAT)0.472 },
	{ 3 ,37 ,40 ,(FLOAT)0.528 ,(FLOAT)0.937 },
	{ 1 ,40 ,41 ,(FLOAT)0.062 ,(FLOAT)1.000 }
};

#endif



/*=============================================================================*/
/*
	For  i  with  i % 64 != 0  is  enwindow[i] = -enwindow[512-i],
	for  i  with  i % 64 == 0  is  enwindow[i] =  enwindow[512-i]   (i != 0)
*/
#if 1

double	enwindow[512] = {
	 0.000000000, 0.000101566, 0.000971317, 0.003134727, 0.035780907, 0.003134727, 0.000971317, 0.000101566,
	-0.000000477, 0.000103951, 0.000953674, 0.002841473, 0.035758972, 0.003401756, 0.000983715, 0.000099182,
	-0.000000477, 0.000105858, 0.000930786, 0.002521515, 0.035694122, 0.003643036, 0.000991821, 0.000096321,
	-0.000000477, 0.000107288, 0.000902653, 0.002174854, 0.035586357, 0.003858566, 0.000995159, 0.000093460,
	-0.000000477, 0.000108242, 0.000868797, 0.001800537, 0.035435200, 0.004049301, 0.000994205, 0.000090599,
	-0.000000477, 0.000108719, 0.000829220, 0.001399517, 0.035242081, 0.004215240, 0.000989437, 0.000087261,
	-0.000000477, 0.000108719, 0.000783920, 0.000971317, 0.035007000, 0.004357815, 0.000980854, 0.000083923,
	-0.000000954, 0.000108242, 0.000731945, 0.000515938, 0.034730434, 0.004477024, 0.000968933, 0.000080585,

	-0.000000954, 0.000106812, 0.000674248, 0.000033379, 0.034412861, 0.004573822, 0.000954151, 0.000076771,
	-0.000000954, 0.000105381, 0.000610352,-0.000475883, 0.034055710, 0.004649162, 0.000935555, 0.000073433,
	-0.000000954, 0.000102520, 0.000539303,-0.001011848, 0.033659935, 0.004703045, 0.000915051, 0.000070095,
	-0.000001431, 0.000099182, 0.000462532,-0.001573563, 0.033225536, 0.004737377, 0.000891685, 0.000066280,
	-0.000001431, 0.000095367, 0.000378609,-0.002161503, 0.032754898, 0.004752159, 0.000866413, 0.000062943,
	-0.000001907, 0.000090122, 0.000288486,-0.002774239, 0.032248020, 0.004748821, 0.000838757, 0.000059605,
	-0.000001907, 0.000084400, 0.000191689,-0.003411293, 0.031706810, 0.004728317, 0.000809669, 0.000055790,
	-0.000002384, 0.000077724, 0.000088215,-0.004072189, 0.031132698, 0.004691124, 0.000779152, 0.000052929,

	-0.000002384, 0.000069618,-0.000021458,-0.004756451, 0.030526638, 0.004638195, 0.000747204, 0.000049591,
	-0.000002861, 0.000060558,-0.000137329,-0.005462170, 0.029890060, 0.004570484, 0.000714302, 0.000046253,
	-0.000003338, 0.000050545,-0.000259876,-0.006189346, 0.029224873, 0.004489899, 0.000680923, 0.000043392,
	-0.000003338, 0.000039577,-0.000388145,-0.006937027, 0.028532982, 0.004395962, 0.000646591, 0.000040531,
	-0.000003815, 0.000027180,-0.000522137,-0.007703304, 0.027815342, 0.004290581, 0.000611782, 0.000037670,
	-0.000004292, 0.000013828,-0.000661850,-0.008487225, 0.027073860, 0.004174709, 0.000576973, 0.000034809,
	-0.000004768,-0.000000954,-0.000806808,-0.009287834, 0.026310921, 0.004048824, 0.000542164, 0.000032425,
	-0.000005245,-0.000017166,-0.000956535,-0.010103703, 0.025527000, 0.003914356, 0.000507355, 0.000030041,

	-0.000006199,-0.000034332,-0.001111031,-0.010933399, 0.024725437, 0.003771782, 0.000472546, 0.000027657,
	-0.000006676,-0.000052929,-0.001269817,-0.011775017, 0.023907185, 0.003622532, 0.000438213, 0.000025272,
	-0.000007629,-0.000072956,-0.001432419,-0.012627602, 0.023074150, 0.003467083, 0.000404358, 0.000023365,
	-0.000008106,-0.000093937,-0.001597881,-0.013489246, 0.022228718, 0.003306866, 0.000371456, 0.000021458,
	-0.000009060,-0.000116348,-0.001766682,-0.014358521, 0.021372318, 0.003141880, 0.000339031, 0.000019550,
	-0.000010014,-0.000140190,-0.001937389,-0.015233517, 0.020506859, 0.002974033, 0.000307560, 0.000018120,
	-0.000011444,-0.000165462,-0.002110004,-0.016112804, 0.019634247, 0.002803326, 0.000277042, 0.000016689,
	-0.000012398,-0.000191212,-0.002283096,-0.016994476, 0.018756866, 0.002630711, 0.000247478, 0.000014782,

	-0.000013828,-0.000218868,-0.002457142,-0.017876148, 0.017876148, 0.002457142, 0.000218868, 0.000013828,
	-0.000014782,-0.000247478,-0.002630711,-0.018756866, 0.016994476, 0.002283096, 0.000191212, 0.000012398,
	-0.000016689,-0.000277042,-0.002803326,-0.019634247, 0.016112804, 0.002110004, 0.000165462, 0.000011444,
	-0.000018120,-0.000307560,-0.002974033,-0.020506859, 0.015233517, 0.001937389, 0.000140190, 0.000010014,
	-0.000019550,-0.000339031,-0.003141880,-0.021372318, 0.014358521, 0.001766682, 0.000116348, 0.000009060,
	-0.000021458,-0.000371456,-0.003306866,-0.022228718, 0.013489246, 0.001597881, 0.000093937, 0.000008106,
	-0.000023365,-0.000404358,-0.003467083,-0.023074150, 0.012627602, 0.001432419, 0.000072956, 0.000007629,
	-0.000025272,-0.000438213,-0.003622532,-0.023907185, 0.011775017, 0.001269817, 0.000052929, 0.000006676,

	-0.000027657,-0.000472546,-0.003771782,-0.024725437, 0.010933399, 0.001111031, 0.000034332, 0.000006199,
	-0.000030041,-0.000507355,-0.003914356,-0.025527000, 0.010103703, 0.000956535, 0.000017166, 0.000005245,
	-0.000032425,-0.000542164,-0.004048824,-0.026310921, 0.009287834, 0.000806808, 0.000000954, 0.000004768,
	-0.000034809,-0.000576973,-0.004174709,-0.027073860, 0.008487225, 0.000661850,-0.000013828, 0.000004292,
	-0.000037670,-0.000611782,-0.004290581,-0.027815342, 0.007703304, 0.000522137,-0.000027180, 0.000003815,
	-0.000040531,-0.000646591,-0.004395962,-0.028532982, 0.006937027, 0.000388145,-0.000039577, 0.000003338,
	-0.000043392,-0.000680923,-0.004489899,-0.029224873, 0.006189346, 0.000259876,-0.000050545, 0.000003338,
	-0.000046253,-0.000714302,-0.004570484,-0.029890060, 0.005462170, 0.000137329,-0.000060558, 0.000002861,

	-0.000049591,-0.000747204,-0.004638195,-0.030526638, 0.004756451, 0.000021458,-0.000069618, 0.000002384,
	-0.000052929,-0.000779152,-0.004691124,-0.031132698, 0.004072189,-0.000088215,-0.000077724, 0.000002384,
	-0.000055790,-0.000809669,-0.004728317,-0.031706810, 0.003411293,-0.000191689,-0.000084400, 0.000001907,
	-0.000059605,-0.000838757,-0.004748821,-0.032248020, 0.002774239,-0.000288486,-0.000090122, 0.000001907,
	-0.000062943,-0.000866413,-0.004752159,-0.032754898, 0.002161503,-0.000378609,-0.000095367, 0.000001431,
	-0.000066280,-0.000891685,-0.004737377,-0.033225536, 0.001573563,-0.000462532,-0.000099182, 0.000001431,
	-0.000070095,-0.000915051,-0.004703045,-0.033659935, 0.001011848,-0.000539303,-0.000102520, 0.000000954,
	-0.000073433,-0.000935555,-0.004649162,-0.034055710, 0.000475883,-0.000610352,-0.000105381, 0.000000954,

	-0.000076771,-0.000954151,-0.004573822,-0.034412861,-0.000033379,-0.000674248,-0.000106812, 0.000000954,
	-0.000080585,-0.000968933,-0.004477024,-0.034730434,-0.000515938,-0.000731945,-0.000108242, 0.000000954,
	-0.000083923,-0.000980854,-0.004357815,-0.035007000,-0.000971317,-0.000783920,-0.000108719, 0.000000477,
	-0.000087261,-0.000989437,-0.004215240,-0.035242081,-0.001399517,-0.000829220,-0.000108719, 0.000000477,
	-0.000090599,-0.000994205,-0.004049301,-0.035435200,-0.001800537,-0.000868797,-0.000108242, 0.000000477,
	-0.000093460,-0.000995159,-0.003858566,-0.035586357,-0.002174854,-0.000902653,-0.000107288, 0.000000477,
	-0.000096321,-0.000991821,-0.003643036,-0.035694122,-0.002521515,-0.000930786,-0.000105858, 0.000000477,
	-0.000099182,-0.000983715,-0.003401756,-0.035758972,-0.002841473,-0.000953674,-0.000103951, 0.000000477
};

#else

double	enwindow[512] = {
	 0.000000000,-0.000000477,-0.000000477,-0.000000477,-0.000000477,-0.000000477,-0.000000477,-0.000000954,
	-0.000000954,-0.000000954,-0.000000954,-0.000001431,-0.000001431,-0.000001907,-0.000001907,-0.000002384,
	-0.000002384,-0.000002861,-0.000003338,-0.000003338,-0.000003815,-0.000004292,-0.000004768,-0.000005245,
	-0.000006199,-0.000006676,-0.000007629,-0.000008106,-0.000009060,-0.000010014,-0.000011444,-0.000012398,
	-0.000013828,-0.000014782,-0.000016689,-0.000018120,-0.000019550,-0.000021458,-0.000023365,-0.000025272,
	-0.000027657,-0.000030041,-0.000032425,-0.000034809,-0.000037670,-0.000040531,-0.000043392,-0.000046253,
	-0.000049591,-0.000052929,-0.000055790,-0.000059605,-0.000062943,-0.000066280,-0.000070095,-0.000073433,
	-0.000076771,-0.000080585,-0.000083923,-0.000087261,-0.000090599,-0.000093460,-0.000096321,-0.000099182,

	 0.000101566, 0.000103951, 0.000105858, 0.000107288, 0.000108242, 0.000108719, 0.000108719, 0.000108242,
	 0.000106812, 0.000105381, 0.000102520, 0.000099182, 0.000095367, 0.000090122, 0.000084400, 0.000077724,
	 0.000069618, 0.000060558, 0.000050545, 0.000039577, 0.000027180, 0.000013828,-0.000000954,-0.000017166,
	-0.000034332,-0.000052929,-0.000072956,-0.000093937,-0.000116348,-0.000140190,-0.000165462,-0.000191212,
	-0.000218868,-0.000247478,-0.000277042,-0.000307560,-0.000339031,-0.000371456,-0.000404358,-0.000438213,
	-0.000472546,-0.000507355,-0.000542164,-0.000576973,-0.000611782,-0.000646591,-0.000680923,-0.000714302,
	-0.000747204,-0.000779152,-0.000809669,-0.000838757,-0.000866413,-0.000891685,-0.000915051,-0.000935555,
	-0.000954151,-0.000968933,-0.000980854,-0.000989437,-0.000994205,-0.000995159,-0.000991821,-0.000983715,

	 0.000971317, 0.000953674, 0.000930786, 0.000902653, 0.000868797, 0.000829220, 0.000783920, 0.000731945,
	 0.000674248, 0.000610352, 0.000539303, 0.000462532, 0.000378609, 0.000288486, 0.000191689, 0.000088215,
	-0.000021458,-0.000137329,-0.000259876,-0.000388145,-0.000522137,-0.000661850,-0.000806808,-0.000956535,
	-0.001111031,-0.001269817,-0.001432419,-0.001597881,-0.001766682,-0.001937389,-0.002110004,-0.002283096,
	-0.002457142,-0.002630711,-0.002803326,-0.002974033,-0.003141880,-0.003306866,-0.003467083,-0.003622532,
	-0.003771782,-0.003914356,-0.004048824,-0.004174709,-0.004290581,-0.004395962,-0.004489899,-0.004570484,
	-0.004638195,-0.004691124,-0.004728317,-0.004748821,-0.004752159,-0.004737377,-0.004703045,-0.004649162,
	-0.004573822,-0.004477024,-0.004357815,-0.004215240,-0.004049301,-0.003858566,-0.003643036,-0.003401756,

	 0.003134727, 0.002841473, 0.002521515, 0.002174854, 0.001800537, 0.001399517, 0.000971317, 0.000515938,
	 0.000033379,-0.000475883,-0.001011848,-0.001573563,-0.002161503,-0.002774239,-0.003411293,-0.004072189,
	-0.004756451,-0.005462170,-0.006189346,-0.006937027,-0.007703304,-0.008487225,-0.009287834,-0.010103703,
	-0.010933399,-0.011775017,-0.012627602,-0.013489246,-0.014358521,-0.015233517,-0.016112804,-0.016994476,
	-0.017876148,-0.018756866,-0.019634247,-0.020506859,-0.021372318,-0.022228718,-0.023074150,-0.023907185,
	-0.024725437,-0.025527000,-0.026310921,-0.027073860,-0.027815342,-0.028532982,-0.029224873,-0.029890060,
	-0.030526638,-0.031132698,-0.031706810,-0.032248020,-0.032754898,-0.033225536,-0.033659935,-0.034055710,
	-0.034412861,-0.034730434,-0.035007000,-0.035242081,-0.035435200,-0.035586357,-0.035694122,-0.035758972,

	 0.035780907, 0.035758972, 0.035694122, 0.035586357, 0.035435200, 0.035242081, 0.035007000, 0.034730434,
	 0.034412861, 0.034055710, 0.033659935, 0.033225536, 0.032754898, 0.032248020, 0.031706810, 0.031132698,
	 0.030526638, 0.029890060, 0.029224873, 0.028532982, 0.027815342, 0.027073860, 0.026310921, 0.025527000,
	 0.024725437, 0.023907185, 0.023074150, 0.022228718, 0.021372318, 0.020506859, 0.019634247, 0.018756866,
	 0.017876148, 0.016994476, 0.016112804, 0.015233517, 0.014358521, 0.013489246, 0.012627602, 0.011775017,
	 0.010933399, 0.010103703, 0.009287834, 0.008487225, 0.007703304, 0.006937027, 0.006189346, 0.005462170,
	 0.004756451, 0.004072189, 0.003411293, 0.002774239, 0.002161503, 0.001573563, 0.001011848, 0.000475883,
	-0.000033379,-0.000515938,-0.000971317,-0.001399517,-0.001800537,-0.002174854,-0.002521515,-0.002841473,

	 0.003134727, 0.003401756, 0.003643036, 0.003858566, 0.004049301, 0.004215240, 0.004357815, 0.004477024,
	 0.004573822, 0.004649162, 0.004703045, 0.004737377, 0.004752159, 0.004748821, 0.004728317, 0.004691124,
	 0.004638195, 0.004570484, 0.004489899, 0.004395962, 0.004290581, 0.004174709, 0.004048824, 0.003914356,
	 0.003771782, 0.003622532, 0.003467083, 0.003306866, 0.003141880, 0.002974033, 0.002803326, 0.002630711,
	 0.002457142, 0.002283096, 0.002110004, 0.001937389, 0.001766682, 0.001597881, 0.001432419, 0.001269817,
	 0.001111031, 0.000956535, 0.000806808, 0.000661850, 0.000522137, 0.000388145, 0.000259876, 0.000137329,
	 0.000021458,-0.000088215,-0.000191689,-0.000288486,-0.000378609,-0.000462532,-0.000539303,-0.000610352,
	-0.000674248,-0.000731945,-0.000783920,-0.000829220,-0.000868797,-0.000902653,-0.000930786,-0.000953674,

	 0.000971317, 0.000983715, 0.000991821, 0.000995159, 0.000994205, 0.000989437, 0.000980854, 0.000968933,
	 0.000954151, 0.000935555, 0.000915051, 0.000891685, 0.000866413, 0.000838757, 0.000809669, 0.000779152,
	 0.000747204, 0.000714302, 0.000680923, 0.000646591, 0.000611782, 0.000576973, 0.000542164, 0.000507355,
	 0.000472546, 0.000438213, 0.000404358, 0.000371456, 0.000339031, 0.000307560, 0.000277042, 0.000247478,
	 0.000218868, 0.000191212, 0.000165462, 0.000140190, 0.000116348, 0.000093937, 0.000072956, 0.000052929,
	 0.000034332, 0.000017166, 0.000000954,-0.000013828,-0.000027180,-0.000039577,-0.000050545,-0.000060558,
	-0.000069618,-0.000077724,-0.000084400,-0.000090122,-0.000095367,-0.000099182,-0.000102520,-0.000105381,
	-0.000106812,-0.000108242,-0.000108719,-0.000108719,-0.000108242,-0.000107288,-0.000105858,-0.000103951,

	 0.000101566, 0.000099182, 0.000096321, 0.000093460, 0.000090599, 0.000087261, 0.000083923, 0.000080585,
	 0.000076771, 0.000073433, 0.000070095, 0.000066280, 0.000062943, 0.000059605, 0.000055790, 0.000052929,
	 0.000049591, 0.000046253, 0.000043392, 0.000040531, 0.000037670, 0.000034809, 0.000032425, 0.000030041,
	 0.000027657, 0.000025272, 0.000023365, 0.000021458, 0.000019550, 0.000018120, 0.000016689, 0.000014782,
	 0.000013828, 0.000012398, 0.000011444, 0.000010014, 0.000009060, 0.000008106, 0.000007629, 0.000006676,
	 0.000006199, 0.000005245, 0.000004768, 0.000004292, 0.000003815, 0.000003338, 0.000003338, 0.000002861,
	 0.000002384, 0.000002384, 0.000001907, 0.000001907, 0.000001431, 0.000001431, 0.000000954, 0.000000954,
	 0.000000954, 0.000000954, 0.000000477, 0.000000477, 0.000000477, 0.000000477, 0.000000477, 0.000000477
};

#endif



/*=============================================================================*/

char	aHuffcode[1498][36] =
{
	".table 0  0  0  0",
	"#val hlen hcod",
	"",
	".table 1  2  2  0",
	"#x  y hlen hcod",
	" 0  0  1   1",
	" 0  1  3   001",
	" 1  0  2   01",
	" 1  1  3   000",
	"",
	".table 2  3  3  0",
	" 0  0  1   1",
	" 0  1  3   010",
	" 0  2  6   000001",
	" 1  0  3   011",
	" 1  1  3   001",
	" 1  2  5   00001",
	" 2  0  5   00011",
	" 2  1  5   00010",
	" 2  2  6   000000",
	"",
	".table 3  3  3  0",
	" 0  0  2   11",
	" 0  1  2   10",
	" 0  2  6   000001",
	" 1  0  3   001",
	" 1  1  2   01",
	" 1  2  5   00001",
	" 2  0  5   00011",
	" 2  1  5   00010",
	" 2  2  6   000000",
	"",
	".table 4  0  0  0",
	"#not usedwanz",
	"",
	".table 5  4  4  0",
	" 0  0  1   1",
	" 0  1  3   010",
	" 0  2  6   000110",
	" 0  3  7   0000101",
	" 1  0  3   011",
	" 1  1  3   001",
	" 1  2  6   000100",
	" 1  3  7   0000100",
	" 2  0  6   000111",
	" 2  1  6   000101",
	" 2  2  7   0000111",
	" 2  3  8   00000001",
	" 3  0  7   0000110",
	" 3  1  6   000001",
	" 3  2  7   0000001",
	" 3  3  8   00000000",
	"",
	".table 6  4  4  0",
	" 0  0  3   111",
	" 0  1  3   011",
	" 0  2  5   00101",
	" 0  3  7   0000001",
	" 1  0  3   110",
	" 1  1  2   10",
	" 1  2  4   0011",
	" 1  3  5   00010",
	" 2  0  4   0101",
	" 2  1  4   0100",
	" 2  2  5   00100",
	" 2  3  6   000001",
	" 3  0  6   000011",
	" 3  1  5   00011",
	" 3  2  6   000010",
	" 3  3  7   0000000",
	"",
	".table 7  6  6  0",
	" 0  0   1   1",
	" 0  1   3   010",
	" 0  2   6   001010",
	" 0  3   8   00010011",
	" 0  4   8   00010000",
	" 0  5   9   000001010",
	" 1  0   3   011",
	" 1  1   4   0011",
	" 1  2   6   000111",
	" 1  3   7   0001010",
	" 1  4   7   0000101",
	" 1  5   8   00000011",
	" 2  0   6   001011",
	" 2  1   5   00100",
	" 2  2   7   0001101",
	" 2  3   8   00010001",
	" 2  4   8   00001000",
	" 2  5   9   000000100",
	" 3  0   7   0001100",
	" 3  1   7   0001011",
	" 3  2   8   00010010",
	" 3  3   9   000001111",
	" 3  4   9   000001011",
	" 3  5   9   000000010",
	" 4  0   7   0000111",
	" 4  1   7   0000110",
	" 4  2   8   00001001",
	" 4  3   9   000001110",
	" 4  4   9   000000011",
	" 4  5  10   0000000001",
	" 5  0   8   00000110",
	" 5  1   8   00000100",
	" 5  2   9   000000101",
	" 5  3  10   0000000011",
	" 5  4  10   0000000010",
	" 5  5  10   0000000000",
	"",
	".table 8  6  6  0",
	" 0  0   2   11",
	" 0  1   3   100",
	" 0  2   6   000110",
	" 0  3   8   00010010",
	" 0  4   8   00001100",
	" 0  5   9   000000101",
	" 1  0   3   101",

	" 1  1   2   01",
	" 1  2   4   0010",
	" 1  3   8   00010000",
	" 1  4   8   00001001",
	" 1  5   8   00000011",
	" 2  0   6   000111",
	" 2  1   4   0011",
	" 2  2   6   000101",
	" 2  3   8   00001110",
	" 2  4   8   00000111",
	" 2  5   9   000000011",
	" 3  0   8   00010011",
	" 3  1   8   00010001",
	" 3  2   8   00001111",
	" 3  3   9   000001101",
	" 3  4   9   000001010",
	" 3  5  10   0000000100",
	" 4  0   8   00001101",
	" 4  1   7   0000101",
	" 4  2   8   00001000",
	" 4  3   9   000001011",
	" 4  4  10   0000000101",
	" 4  5  10   0000000001",
	" 5  0   9   000001100",
	" 5  1   8   00000100",
	" 5  2   9   000000100",
	" 5  3   9   000000001",
	" 5  4  11   00000000001",
	" 5  5  11   00000000000",
	"",
	".table 9  6  6  0",
	" 0  0   3   111",
	" 0  1   3   101",
	" 0  2   5   01001",
	" 0  3   6   001110",
	" 0  4   8   00001111",
	" 0  5   9   000000111",
	" 1  0   3   110",
	" 1  1   3   100",
	" 1  2   4   0101",
	" 1  3   5   00101",
	" 1  4   6   000110",
	" 1  5   8   00000111",
	" 2  0   4   0111",
	" 2  1   4   0110",
	" 2  2   5   01000",
	" 2  3   6   001000",
	" 2  4   7   0001000",
	" 2  5   8   00000101",
	" 3  0   6   001111",
	" 3  1   5   00110",
	" 3  2   6   001001",
	" 3  3   7   0001010",
	" 3  4   7   0000101",
	" 3  5   8   00000001",
	" 4  0   7   0001011",
	" 4  1   6   000111",
	" 4  2   7   0001001",
	" 4  3   7   0000110",
	" 4  4   8   00000100",
	" 4  5   9   000000001",
	" 5  0   8   00001110",
	" 5  1   7   0000100",
	" 5  2   8   00000110",
	" 5  3   8   00000010",
	" 5  4   9   000000110",
	" 5  5   9   000000000",
	"",
	".table 10  8  8  0",
	" 0  0   1   1",
	" 0  1   3   010",
	" 0  2   6   001010",
	" 0  3   8   00010111",
	" 0  4   9   000100011",
	" 0  5   9   000011110",
	" 0  6   9   000001100",
	" 0  7  10   0000010001",
	" 1  0   3   011",
	" 1  1   4   0011",
	" 1  2   6   001000",
	" 1  3   7   0001100",
	" 1  4   8   00010010",
	" 1  5   9   000010101",
	" 1  6   8   00001100",
	" 1  7   8   00000111",
	" 2  0   6   001011",
	" 2  1   6   001001",
	" 2  2   7   0001111",
	" 2  3   8   00010101",
	" 2  4   9   000100000",
	" 2  5  10   0000101000",
	" 2  6   9   000010011",
	" 2  7   9   000000110",
	" 3  0   7   0001110",
	" 3  1   7   0001101",
	" 3  2   8   00010110",
	" 3  3   9   000100010",
	" 3  4  10   0000101110",
	" 3  5  10   0000010111",
	" 3  6   9   000010010",
	" 3  7  10   0000000111",
	" 4  0   8   00010100",
	" 4  1   8   00010011",

	" 4  2   9   000100001",
	" 4  3  10   0000101111",
	" 4  4  10   0000011011",
	" 4  5  10   0000010110",
	" 4  6  10   0000001001",
	" 4  7  10   0000000011",
	" 5  0   9   000011111",
	" 5  1   9   000010110",
	" 5  2  10   0000101001",
	" 5  3  10   0000011010",
	" 5  4  11   00000010101",
	" 5  5  11   00000010100",
	" 5  6  10   0000000101",
	" 5  7  11   00000000011",
	" 6  0   8   00001110",
	" 6  1   8   00001101",
	" 6  2   9   000001010",
	" 6  3  10   0000001011",
	" 6  4  10   0000010000",
	" 6  5  10   0000000110",
	" 6  6  11   00000000101",
	" 6  7  11   00000000001",
	" 7  0   9   000001001",
	" 7  1   8   00001000",
	" 7  2   9   000000111",
	" 7  3  10   0000001000",
	" 7  4  10   0000000100",
	" 7  5  11   00000000100",
	" 7  6  11   00000000010",
	" 7  7  11   00000000000",
	"",
	".table 11  8  8  0",
	" 0  0   2   11",
	" 0  1   3   100",
	" 0  2   5   01010",
	" 0  3   7   0011000",
	" 0  4   8   00100010",
	" 0  5   9   000100001",
	" 0  6   8   00010101",
	" 0  7   9   000001111",
	" 1  0   3   101",
	" 1  1   3   011",
	" 1  2   4   0100",
	" 1  3   6   001010",
	" 1  4   8   00100000",
	" 1  5   8   00010001",
	" 1  6   7   0001011",
	" 1  7   8   00001010",
	" 2  0   5   01011",
	" 2  1   5   00111",
	" 2  2   6   001101",
	" 2  3   7   0010010",
	" 2  4   8   00011110",
	" 2  5   9   000011111",
	" 2  6   8   00010100",
	" 2  7   8   00000101",
	" 3  0   7   0011001",
	" 3  1   6   001011",
	" 3  2   7   0010011",
	" 3  3   9   000111011",
	" 3  4   8   00011011",
	" 3  5  10   0000010010",
	" 3  6   8   00001100",
	" 3  7   9   000000101",
	" 4  0   8   00100011",
	" 4  1   8   00100001",
	" 4  2   8   00011111",
	" 4  3   9   000111010",
	" 4  4   9   000011110",
	" 4  5  10   0000010000",
	" 4  6   9   000000111",
	" 4  7  10   0000000101",
	" 5  0   8   00011100",
	" 5  1   8   00011010",
	" 5  2   9   000100000",
	" 5  3  10   0000010011",
	" 5  4  10   0000010001",
	" 5  5  11   00000001111",
	" 5  6  10   0000001000",
	" 5  7  11   00000001110",
	" 6  0   8   00001110",
	" 6  1   7   0001100",
	" 6  2   7   0001001",
	" 6  3   8   00001101",
	" 6  4   9   000001110",
	" 6  5  10   0000001001",
	" 6  6  10   0000000100",
	" 6  7  10   0000000001",
	" 7  0   8   00001011",
	" 7  1   7   0000100",
	" 7  2   8   00000110",
	" 7  3   9   000000110",
	" 7  4  10   0000000110",
	" 7  5  10   0000000011",
	" 7  6  10   0000000010",
	" 7  7  10   0000000000",
	"",
	".table 12  8  8  0",
	" 0  0   4   1001",
	" 0  1   3   110",
	" 0  2   5   10000",
	" 0  3   7   0100001",
	" 0  4   8   00101001",
	" 0  5   9   000100111",
	" 0  6   9   000100110",
	" 0  7   9   000011010",
	" 1  0   3   111",
	" 1  1   3   101",
	" 1  2   4   0110",
	" 1  3   5   01001",
	" 1  4   7   0010111",
	" 1  5   7   0010000",
	" 1  6   8   00011010",
	" 1  7   8   00001011",
	" 2  0   5   10001",
	" 2  1   4   0111",
	" 2  2   5   01011",
	" 2  3   6   001110",
	" 2  4   7   0010101",
	" 2  5   8   00011110",
	" 2  6   7   0001010",
	" 2  7   8   00000111",
	" 3  0   6   010001",
	" 3  1   5   01010",
	" 3  2   6   001111",
	" 3  3   6   001100",
	" 3  4   7   0010010",
	" 3  5   8   00011100",
	" 3  6   8   00001110",
	" 3  7   8   00000101",
	" 4  0   7   0100000",
	" 4  1   6   001101",
	" 4  2   7   0010110",
	" 4  3   7   0010011",
	" 4  4   8   00010010",
	" 4  5   8   00010000",
	" 4  6   8   00001001",
	" 4  7   9   000000101",
	" 5  0   8   00101000",
	" 5  1   7   0010001",
	" 5  2   8   00011111",
	" 5  3   8   00011101",
	" 5  4   8   00010001",
	" 5  5   9   000001101",
	" 5  6   8   00000100",
	" 5  7   9   000000010",
	" 6  0   8   00011011",
	" 6  1   7   0001100",
	" 6  2   7   0001011",
	" 6  3   8   00001111",
	" 6  4   8   00001010",
	" 6  5   9   000000111",
	" 6  6   9   000000100",
	" 6  7  10   0000000001",
	" 7  0   9   000011011",
	" 7  1   8   00001100",
	" 7  2   8   00001000",
	" 7  3   9   000001100",
	" 7  4   9   000000110",
	" 7  5   9   000000011",
	" 7  6   9   000000001",
	" 7  7  10   0000000000",
	"",
	".table 13  16  16  0",
	" 0  0   1   1",
	" 0  1   4   0101",
	" 0  2   6   001110",
	" 0  3   7   0010101",
	" 0  4   8   00100010",
	" 0  5   9   000110011",
	" 0  6   9   000101110",

	" 0  7  10   0001000111",
	" 0  8   9   000101010",
	" 0  9  10   0000110100",
	" 0 10  11   00001000100",
	" 0 11  11   00000110100",
	" 0 12  12   000001000011",
	" 0 13  12   000000101100",
	" 0 14  13   0000000101011",

	" 0 15  13   0000000010011",
	" 1  0   3   011",
	" 1  1   4   0100",
	" 1  2   6   001100",
	" 1  3   7   0010011",
	" 1  4   8   00011111",
	" 1  5   8   00011010",
	" 1  6   9   000101100",
	" 1  7   9   000100001",
	" 1  8   9   000011111",
	" 1  9   9   000011000",
	" 1 10  10   0000100000",
	" 1 11  10   0000011000",
	" 1 12  11   00000011111",
	" 1 13  12   000000100011",
	" 1 14  12   000000010110",
	" 1 15  12   000000001110",
	" 2  0   6   001111",
	" 2  1   6   001101",
	" 2  2   7   0010111",
	" 2  3   8   00100100",
	" 2  4   9   000111011",
	" 2  5   9   000110001",
	" 2  6  10   0001001101",
	" 2  7  10   0001000001",
	" 2  8   9   000011101",
	" 2  9  10   0000101000",
	" 2 10  10   0000011110",
	" 2 11  11   00000101000",
	" 2 12  11   00000011011",
	" 2 13  12   000000100001",
	" 2 14  13   0000000101010",
	" 2 15  13   0000000010000",
	" 3  0   7   0010110",
	" 3  1   7   0010100",
	" 3  2   8   00100101",
	" 3  3   9   000111101",
	" 3  4   9   000111000",
	" 3  5  10   0001001111",
	" 3  6  10   0001001001",
	" 3  7  10   0001000000",
	" 3  8  10   0000101011",
	" 3  9  11   00001001100",
	" 3 10  11   00000111000",
	" 3 11  11   00000100101",
	" 3 12  11   00000011010",
	" 3 13  12   000000011111",
	" 3 14  13   0000000011001",
	" 3 15  13   0000000001110",
	" 4  0   8   00100011",
	" 4  1   7   0010000",
	" 4  2   9   000111100",
	" 4  3   9   000111001",
	" 4  4  10   0001100001",
	" 4  5  10   0001001011",
	" 4  6  11   00001110010",
	" 4  7  11   00001011011",
	" 4  8  10   0000110110",
	" 4  9  11   00001001001",
	" 4 10  11   00000110111",
	" 4 11  12   000000101001",
	" 4 12  12   000000110000",
	" 4 13  13   0000000110101",
	" 4 14  13   0000000010111",
	" 4 15  14   00000000011000",
	" 5  0   9   000111010",
	" 5  1   8   00011011",
	" 5  2   9   000110010",
	" 5  3  10   0001100000",
	" 5  4  10   0001001100",
	" 5  5  10   0001000110",
	" 5  6  11   00001011101",
	" 5  7  11   00001010100",
	" 5  8  11   00001001101",
	" 5  9  11   00000111010",
	" 5 10  12   000001001111",
	" 5 11  11   00000011101",
	" 5 12  13   0000001001010",
	" 5 13  13   0000000110001",
	" 5 14  14   00000000101001",
	" 5 15  14   00000000010001",
	" 6  0   9   000101111",
	" 6  1   9   000101101",

	" 6  2  10   0001001110",
	" 6  3  10   0001001010",
	" 6  4  11   00001110011",
	" 6  5  11   00001011110",
	" 6  6  11   00001011010",
	" 6  7  11   00001001111",
	" 6  8  11   00001000101",
	" 6  9  12   000001010011",
	" 6 10  12   000001000111",
	" 6 11  12   000000110010",
	" 6 12  13   0000000111011",
	" 6 13  13   0000000100110",
	" 6 14  14   00000000100100",
	" 6 15  14   00000000001111",
	" 7  0  10   0001001000",
	" 7  1   9   000100010",
	" 7  2  10   0000111000",
	" 7  3  11   00001011111",
	" 7  4  11   00001011100",
	" 7  5  11   00001010101",
	" 7  6  12   000001011011",
	" 7  7  12   000001011010",
	" 7  8  12   000001010110",
	" 7  9  12   000001001001",
	" 7 10  13   0000001001101",
	" 7 11  13   0000001000001",
	" 7 12  13   0000000110011",
	" 7 13  14   00000000101100",
	" 7 14  16   0000000000101011",
	" 7 15  16   0000000000101010",
	" 8  0   9   000101011",
	" 8  1   8   00010100",
	" 8  2   9   000011110",
	" 8  3  10   0000101100",
	" 8  4  10   0000110111",
	" 8  5  11   00001001110",
	" 8  6  11   00001001000",
	" 8  7  12   000001010111",
	" 8  8  12   000001001110",
	" 8  9  12   000000111101",
	" 8 10  12   000000101110",
	" 8 11  13   0000000110110",
	" 8 12  13   0000000100101",
	" 8 13  14   00000000011110",
	" 8 14  15   000000000010100",
	" 8 15  15   000000000010000",
	" 9  0  10   0000110101",
	" 9  1   9   000011001",
	" 9  2  10   0000101001",
	" 9  3  10   0000100101",
	" 9  4  11   00000101100",
	" 9  5  11   00000111011",
	" 9  6  11   00000110110",
	" 9  7  13   0000001010001",
	" 9  8  12   000001000010",
	" 9  9  13   0000001001100",
	" 9 10  13   0000000111001",
	" 9 11  14   00000000110110",
	" 9 12  14   00000000100101",
	" 9 13  14   00000000010010",
	" 9 14  16   0000000000100111",
	" 9 15  15   000000000001011",
	"10  0  10   0000100011",
	"10  1  10   0000100001",
	"10  2  10   0000011111",
	"10  3  11   00000111001",
	"10  4  11   00000101010",
	"10  5  12   000001010010",
	"10  6  12   000001001000",
	"10  7  13   0000001010000",
	"10  8  12   000000101111",
	"10  9  13   0000000111010",
	"10 10  14   00000000110111",
	"10 11  13   0000000010101",
	"10 12  14   00000000010110",
	"10 13  15   000000000011010",
	"10 14  16   0000000000100110",
	"10 15  17   00000000000010110",
	"11  0  11   00000110101",
	"11  1  10   0000011001",
	"11  2  10   0000010111",
	"11  3  11   00000100110",
	"11  4  12   000001000110",
	"11  5  12   000000111100",
	"11  6  12   000000110011",
	"11  7  12   000000100100",
	"11  8  13   0000000110111",
	"11  9  13   0000000011010",
	"11 10  13   0000000100010",
	"11 11  14   00000000010111",
	"11 12  15   000000000011011",
	"11 13  15   000000000001110",
	"11 14  15   000000000001001",
	"11 15  16   0000000000000111",
	"12  0  11   00000100010",
	"12  1  11   00000100000",
	"12  2  11   00000011100",
	"12  3  12   000000100111",
	"12  4  12   000000110001",
	"12  5  13   0000001001011",
	"12  6  12   000000011110",
	"12  7  13   0000000110100",
	"12  8  14   00000000110000",
	"12  9  14   00000000101000",
	"12 10  15   000000000110100",
	"12 11  15   000000000011100",
	"12 12  15   000000000010010",
	"12 13  16   0000000000010001",
	"12 14  16   0000000000001001",
	"12 15  16   0000000000000101",
	"13  0  12   000000101101",
	"13  1  11   00000010101",
	"13  2  12   000000100010",
	"13  3  13   0000001000000",
	"13  4  13   0000000111000",
	"13  5  13   0000000110010",
	"13  6  14   00000000110001",
	"13  7  14   00000000101101",
	"13  8  14   00000000011111",
	"13  9  14   00000000010011",
	"13 10  14   00000000001100",
	"13 11  15   000000000001111",
	"13 12  16   0000000000001010",
	"13 13  15   000000000000111",
	"13 14  16   0000000000000110",
	"13 15  16   0000000000000011",
	"14  0  13   0000000110000",
	"14  1  12   000000010111",
	"14  2  12   000000010100",
	"14  3  13   0000000100111",
	"14  4  13   0000000100100",
	"14  5  13   0000000100011",
	"14  6  15   000000000110101",
	"14  7  14   00000000010101",
	"14  8  14   00000000010000",
	"14  9  17   00000000000010111",
	"14 10  15   000000000001101",
	"14 11  15   000000000001010",
	"14 12  15   000000000000110",
	"14 13  17   00000000000000001",
	"14 14  16   0000000000000100",
	"14 15  16   0000000000000010",
	"15  0  12   000000010000",
	"15  1  12   000000001111",
	"15  2  13   0000000010001",
	"15  3  14   00000000011011",
	"15  4  14   00000000011001",
	"15  5  14   00000000010100",
	"15  6  15   000000000011101",
	"15  7  14   00000000001011",
	"15  8  15   000000000010001",
	"15  9  15   000000000001100",
	"15 10  16   0000000000010000",
	"15 11  16   0000000000001000",
	"15 12  19   0000000000000000001",
	"15 13  18   000000000000000001",
	"15 14  19   0000000000000000000",
	"15 15  16   0000000000000001",
	"",
	".table 14  0  0  0",
	"#not used",
	"",
	".table 15  16  16  0",
	" 0  0   3   111",
	" 0  1   4   1100",
	" 0  2   5   10010",
	" 0  3   7   0110101",
	" 0  4   7   0101111",
	" 0  5   8   01001100",
	" 0  6   9   001111100",
	" 0  7   9   001101100",
	" 0  8   9   001011001",
	" 0  9  10   0001111011",
	" 0 10  10   0001101100",
	" 0 11  11   00001110111",
	" 0 12  11   00001101011",
	" 0 13  11   00001010001",
	" 0 14  12   000001111010",
	" 0 15  13   0000000111111",
	" 1  0   4   1101",
	" 1  1   3   101",
	" 1  2   5   10000",
	" 1  3   6   011011",
	" 1  4   7   0101110",
	" 1  5   7   0100100",
	" 1  6   8   00111101",
	" 1  7   8   00110011",
	" 1  8   8   00101010",
	" 1  9   9   001000110",
	" 1 10   9   000110100",
	" 1 11  10   0001010011",
	" 1 12  10   0001000001",
	" 1 13  10   0000101001",
	" 1 14  11   00000111011",
	" 1 15  11   00000100100",
	" 2  0   5   10011",
	" 2  1   5   10001",
	" 2  2   5   01111",
	" 2  3   6   011000",
	" 2  4   7   0101001",
	" 2  5   7   0100010",
	" 2  6   8   00111011",
	" 2  7   8   00110000",
	" 2  8   8   00101000",
	" 2  9   9   001000000",
	" 2 10   9   000110010",
	" 2 11  10   0001001110",
	" 2 12  10   0000111110",
	" 2 13  11   00001010000",
	" 2 14  11   00000111000",
	" 2 15  11   00000100001",
	" 3  0   6   011101",
	" 3  1   6   011100",
	" 3  2   6   011001",
	" 3  3   7   0101011",
	" 3  4   7   0100111",
	" 3  5   8   00111111",
	" 3  6   8   00110111",
	" 3  7   9   001011101",
	" 3  8   9   001001100",
	" 3  9   9   000111011",
	" 3 10  10   0001011101",
	" 3 11  10   0001001000",
	" 3 12  10   0000110110",
	" 3 13  11   00001001011",
	" 3 14  11   00000110010",
	" 3 15  11   00000011101",
	" 4  0   7   0110100",
	" 4  1   6   010110",
	" 4  2   7   0101010",
	" 4  3   7   0101000",
	" 4  4   8   01000011",
	" 4  5   8   00111001",
	" 4  6   9   001011111",
	" 4  7   9   001001111",
	" 4  8   9   001001000",
	" 4  9   9   000111001",
	" 4 10  10   0001011001",
	" 4 11  10   0001000101",
	" 4 12  10   0000110001",
	" 4 13  11   00001000010",
	" 4 14  11   00000101110",
	" 4 15  11   00000011011",
	" 5  0   8   01001101",
	" 5  1   7   0100101",
	" 5  2   7   0100011",
	" 5  3   8   01000010",
	" 5  4   8   00111010",
	" 5  5   8   00110100",
	" 5  6   9   001011011",
	" 5  7   9   001001010",
	" 5  8   9   000111110",
	" 5  9   9   000110000",
	" 5 10  10   0001001111",
	" 5 11  10   0000111111",
	" 5 12  11   00001011010",
	" 5 13  11   00000111110",
	" 5 14  11   00000101000",
	" 5 15  12   000000100110",
	" 6  0   9   001111101",
	" 6  1   7   0100000",
	" 6  2   8   00111100",
	" 6  3   8   00111000",
	" 6  4   8   00110010",
	" 6  5   9   001011100",
	" 6  6   9   001001110",
	" 6  7   9   001000001",
	" 6  8   9   000110111",
	" 6  9  10   0001010111",
	" 6 10  10   0001000111",
	" 6 11  10   0000110011",
	" 6 12  11   00001001001",
	" 6 13  11   00000110011",

	" 6 14  12   000001000110",
	" 6 15  12   000000011110",
	" 7  0   9   001101101",
	" 7  1   8   00110101",
	" 7  2   8   00110001",
	" 7  3   9   001011110",
	" 7  4   9   001011000",
	" 7  5   9   001001011",
	" 7  6   9   001000010",
	" 7  7  10   0001111010",
	" 7  8  10   0001011011",
	" 7  9  10   0001001001",
	" 7 10  10   0000111000",
	" 7 11  10   0000101010",
	" 7 12  11   00001000000",
	" 7 13  11   00000101100",
	" 7 14  11   00000010101",
	" 7 15  12   000000011001",
	" 8  0   9   001011010",
	" 8  1   8   00101011",
	" 8  2   8   00101001",
	" 8  3   9   001001101",
	" 8  4   9   001001001",
	" 8  5   9   000111111",
	" 8  6   9   000111000",
	" 8  7  10   0001011100",
	" 8  8  10   0001001101",
	" 8  9  10   0001000010",
	" 8 10  10   0000101111",
	" 8 11  11   00001000011",
	" 8 12  11   00000110000",
	" 8 13  12   000000110101",
	" 8 14  12   000000100100",
	" 8 15  12   000000010100",
	" 9  0   9   001000111",
	" 9  1   8   00100010",
	" 9  2   9   001000011",
	" 9  3   9   000111100",
	" 9  4   9   000111010",
	" 9  5   9   000110001",
	" 9  6  10   0001011000",
	" 9  7  10   0001001100",
	" 9  8  10   0001000011",
	" 9  9  11   00001101010",
	" 9 10  11   00001000111",
	" 9 11  11   00000110110",
	" 9 12  11   00000100110",
	" 9 13  12   000000100111",
	" 9 14  12   000000010111",
	" 9 15  12   000000001111",
	"10  0  10   0001101101",
	"10  1   9   000110101",
	"10  2   9   000110011",
	"10  3   9   000101111",
	"10  4  10   0001011010",
	"10  5  10   0001010010",
	"10  6  10   0000111010",
	"10  7  10   0000111001",
	"10  8  10   0000110000",
	"10  9  11   00001001000",
	"10 10  11   00000111001",
	"10 11  11   00000101001",
	"10 12  11   00000010111",
	"10 13  12   000000011011",
	"10 14  13   0000000111110",
	"10 15  12   000000001001",
	"11  0  10   0001010110",
	"11  1   9   000101010",
	"11  2   9   000101000",
	"11  3   9   000100101",
	"11  4  10   0001000110",
	"11  5  10   0001000000",
	"11  6  10   0000110100",
	"11  7  10   0000101011",
	"11  8  11   00001000110",
	"11  9  11   00000110111",
	"11 10  11   00000101010",
	"11 11  11   00000011001",
	"11 12  12   000000011101",
	"11 13  12   000000010010",
	"11 14  12   000000001011",
	"11 15  13   0000000001011",
	"12  0  11   00001110110",
	"12  1  10   0001000100",
	"12  2   9   000011110",
	"12  3  10   0000110111",
	"12  4  10   0000110010",
	"12  5  10   0000101110",
	"12  6  11   00001001010",
	"12  7  11   00001000001",
	"12  8  11   00000110001",
	"12  9  11   00000100111",
	"12 10  11   00000011000",
	"12 11  11   00000010000",
	"12 12  12   000000010110",
	"12 13  12   000000001101",
	"12 14  13   0000000001110",
	"12 15  13   0000000000111",
	"13  0  11   00001011011",
	"13  1  10   0000101100",
	"13  2  10   0000100111",
	"13  3  10   0000100110",
	"13  4  10   0000100010",
	"13  5  11   00000111111",
	"13  6  11   00000110100",
	"13  7  11   00000101101",
	"13  8  11   00000011111",
	"13  9  12   000000110100",
	"13 10  12   000000011100",
	"13 11  12   000000010011",
	"13 12  12   000000001110",
	"13 13  12   000000001000",
	"13 14  13   0000000001001",
	"13 15  13   0000000000011",
	"14  0  12   000001111011",
	"14  1  11   00000111100",
	"14  2  11   00000111010",
	"14  3  11   00000110101",
	"14  4  11   00000101111",
	"14  5  11   00000101011",
	"14  6  11   00000100000",
	"14  7  11   00000010110",
	"14  8  12   000000100101",
	"14  9  12   000000011000",
	"14 10  12   000000010001",
	"14 11  12   000000001100",
	"14 12  13   0000000001111",
	"14 13  13   0000000001010",
	"14 14  12   000000000010",
	"14 15  13   0000000000001",
	"15  0  12   000001000111",
	"15  1  11   00000100101",
	"15  2  11   00000100010",
	"15  3  11   00000011110",
	"15  4  11   00000011100",
	"15  5  11   00000010100",
	"15  6  11   00000010001",
	"15  7  12   000000011010",
	"15  8  12   000000010101",
	"15  9  12   000000010000",
	"15 10  12   000000001010",
	"15 11  12   000000000110",
	"15 12  13   0000000001000",
	"15 13  13   0000000000110",
	"15 14  13   0000000000010",
	"15 15  13   0000000000000",
	"",
	".table 16  16  16  1",
	" 0  0   1   1",
	" 0  1   4   0101",
	" 0  2   6   001110",
	" 0  3   8   00101100",
	" 0  4   9   001001010",
	" 0  5   9   000111111",
	" 0  6  10   0001101110",
	" 0  7  10   0001011101",
	" 0  8  11   00010101100",
	" 0  9  11   00010010101",
	" 0 10  11   00010001010",
	" 0 11  12   000011110010",
	" 0 12  12   000011100001",
	" 0 13  12   000011000011",
	" 0 14  13   0000101111000",
	" 0 15   9   000010001",
	" 1  0   3   011",
	" 1  1   4   0100",
	" 1  2   6   001100",
	" 1  3   7   0010100",
	" 1  4   8   00100011",
	" 1  5   9   000111110",
	" 1  6   9   000110101",
	" 1  7   9   000101111",
	" 1  8  10   0001010011",
	" 1  9  10   0001001011",
	" 1 10  10   0001000100",
	" 1 11  11   00001110111",
	" 1 12  12   000011001001",
	" 1 13  11   00001101011",
	" 1 14  12   000011001111",
	" 1 15   8   00001001",
	" 2  0   6   001111",
	" 2  1   6   001101",
	" 2  2   7   0010111",
	" 2  3   8   00100110",
	" 2  4   9   001000011",
	" 2  5   9   000111010",
	" 2  6  10   0001100111",
	" 2  7  10   0001011010",
	" 2  8  11   00010100001",
	" 2  9  10   0001001000",
	" 2 10  11   00001111111",
	" 2 11  11   00001110101",
	" 2 12  11   00001101110",
	" 2 13  12   000011010001",
	" 2 14  12   000011001110",
	" 2 15   9   000010000",
	" 3  0   8   00101101",
	" 3  1   7   0010101",
	" 3  2   8   00100111",
	" 3  3   9   001000101",
	" 3  4   9   001000000",
	" 3  5  10   0001110010",
	" 3  6  10   0001100011",
	" 3  7  10   0001010111",
	" 3  8  11   00010011110",
	" 3  9  11   00010001100",
	" 3 10  12   000011111100",
	" 3 11  12   000011010100",
	" 3 12  12   000011000111",
	" 3 13  13   0000110000011",
	" 3 14  13   0000101101101",
	" 3 15  10   0000011010",
	" 4  0   9   001001011",
	" 4  1   8   00100100",
	" 4  2   9   001000100",
	" 4  3   9   001000001",
	" 4  4  10   0001110011",
	" 4  5  10   0001100101",
	" 4  6  11   00010110011",
	" 4  7  11   00010100100",
	" 4  8  11   00010011011",
	" 4  9  12   000100001000",
	" 4 10  12   000011110110",
	" 4 11  12   000011100010",
	" 4 12  13   0000110001011",
	" 4 13  13   0000101111110",
	" 4 14  13   0000101101010",
	" 4 15   9   000001001",
	" 5  0   9   001000010",
	" 5  1   8   00011110",
	" 5  2   9   000111011",
	" 5  3   9   000111000",
	" 5  4  10   0001100110",
	" 5  5  11   00010111001",
	" 5  6  11   00010101101",
	" 5  7  12   000100001001",
	" 5  8  11   00010001110",
	" 5  9  12   000011111101",
	" 5 10  12   000011101000",
	" 5 11  13   0000110010000",
	" 5 12  13   0000110000100",
	" 5 13  13   0000101111010",
	" 5 14  14   00000110111101",
	" 5 15  10   0000010000",
	" 6  0  10   0001101111",
	" 6  1   9   000110110",
	" 6  2   9   000110100",
	" 6  3  10   0001100100",
	" 6  4  11   00010111000",
	" 6  5  11   00010110010",
	" 6  6  11   00010100000",
	" 6  7  11   00010000101",
	" 6  8  12   000100000001",
	" 6  9  12   000011110100",
	" 6 10  12   000011100100",
	" 6 11  12   000011011001",
	" 6 12  13   0000110000001",
	" 6 13  13   0000101101110",
	" 6 14  14   00001011001011",
	" 6 15  10   0000001010",
	" 7  0  10   0001100010",
	" 7  1   9   000110000",
	" 7  2  10   0001011011",
	" 7  3  10   0001011000",
	" 7  4  11   00010100101",
	" 7  5  11   00010011101",
	" 7  6  11   00010010100",
	" 7  7  12   000100000101",
	" 7  8  12   000011111000",
	" 7  9  13   0000110010111",
	" 7 10  13   0000110001101",
	" 7 11  13   0000101110100",
	" 7 12  13   0000101111100",
	" 7 13  15   000001101111001",
	" 7 14  15   000001101110100",
	" 7 15  10   0000001000",
	" 8  0  10   0001010101",
	" 8  1  10   0001010100",
	" 8  2  10   0001010001",
	" 8  3  11   00010011111",
	" 8  4  11   00010011100",
	" 8  5  11   00010001111",
	" 8  6  12   000100000100",
	" 8  7  12   000011111001",
	" 8  8  13   0000110101011",
	" 8  9  13   0000110010001",
	" 8 10  13   0000110001000",
	" 8 11  13   0000101111111",
	" 8 12  14   00001011010111",
	" 8 13  14   00001011001001",
	" 8 14  14   00001011000100",
	" 8 15  10   0000000111",
	" 9  0  11   00010011010",
	" 9  1  10   0001001100",
	" 9  2  10   0001001001",
	" 9  3  11   00010001101",
	" 9  4  11   00010000011",
	" 9  5  12   000100000000",
	" 9  6  12   000011110101",
	" 9  7  13   0000110101010",
	" 9  8  13   0000110010110",
	" 9  9  13   0000110001010",
	" 9 10  13   0000110000000",
	" 9 11  14   00001011011111",
	" 9 12  13   0000101100111",
	" 9 13  14   00001011000110",
	" 9 14  13   0000101100000",
	" 9 15  11   00000001011",
	"10  0  11   00010001011",
	"10  1  11   00010000001",
	"10  2  10   0001000011",
	"10  3  11   00001111101",
	"10  4  12   000011110111",
	"10  5  12   000011101001",
	"10  6  12   000011100101",
	"10  7  12   000011011011",
	"10  8  13   0000110001001",
	"10  9  14   00001011100111",
	"10 10  14   00001011100001",
	"10 11  14   00001011010000",
	"10 12  15   000001101110101",

	"10 13  15   000001101110010",
	"10 14  14   00000110110111",
	"10 15  10   0000000100",
	"11  0  12   000011110011",
	"11  1  11   00001111000",
	"11  2  11   00001110110",
	"11  3  11   00001110011",
	"11  4  12   000011100011",
	"11  5  12   000011011111",
	"11  6  13   0000110001100",
	"11  7  14   00001011101010",
	"11  8  14   00001011100110",
	"11  9  14   00001011100000",
	"11 10  14   00001011010001",
	"11 11  14   00001011001000",
	"11 12  14   00001011000010",
	"11 13  13   0000011011111",
	"11 14  14   00000110110100",
	"11 15  11   00000000110",
	"12  0  12   000011001010",
	"12  1  12   000011100000",
	"12  2  12   000011011110",
	"12  3  12   000011011010",
	"12  4  12   000011011000",
	"12  5  13   0000110000101",
	"12  6  13   0000110000010",
	"12  7  13   0000101111101",
	"12  8  13   0000101101100",
	"12  9  15   000001101111000",
	"12 10  14   00000110111011",
	"12 11  14   00001011000011",
	"12 12  14   00000110111000",
	"12 13  14   00000110110101",
	"12 14  16   0000011011000000",
	"12 15  11   00000000100",
	"13  0  14   00001011101011",
	"13  1  12   000011010011",
	"13  2  12   000011010010",
	"13  3  12   000011010000",
	"13  4  13   0000101110010",
	"13  5  13   0000101111011",
	"13  6  14   00001011011110",
	"13  7  14   00001011010011",
	"13  8  14   00001011001010",
	"13  9  16   0000011011000111",
	"13 10  15   000001101110011",
	"13 11  15   000001101101101",
	"13 12  15   000001101101100",
	"13 13  17   00000110110000011",
	"13 14  15   000001101100001",
	"13 15  11   00000000010",
	"14  0  13   0000101111001",
	"14  1  13   0000101110001",
	"14  2  11   00001100110",
	"14  3  12   000010111011",
	"14  4  14   00001011010110",
	"14  5  14   00001011010010",
	"14  6  13   0000101100110",
	"14  7  14   00001011000111",
	"14  8  14   00001011000101",
	"14  9  15   000001101100010",
	"14 10  16   0000011011000110",
	"14 11  15   000001101100111",
	"14 12  17   00000110110000010",
	"14 13  15   000001101100110",
	"14 14  14   00000110110010",
	"14 15  11   00000000000",
	"15  0   9   000001100",
	"15  1   8   00001010",
	"15  2   8   00000111",
	"15  3   9   000001011",
	"15  4   9   000001010",
	"15  5  10   0000010001",
	"15  6  10   0000001011",
	"15  7  10   0000001001",
	"15  8  11   00000001101",
	"15  9  11   00000001100",
	"15 10  11   00000001010",
	"15 11  11   00000000111",
	"15 12  11   00000000101",
	"15 13  11   00000000011",
	"15 14  11   00000000001",
	"15 15   8   00000011",
	"",
	".table 17 16 16 2",
	".reference 16",
	"",
	".table 18 16 16 3",
	".reference 16",
	"",
	".table 19 16 16 4",
	".reference 16",
	"",
	".table 20 16 16 6",
	".reference 16",
	"",
	".table 21 16 16 8",
	".reference 16",
	"",
	".table 22 16 16 10",
	".reference 16",
	"",
	".table 23 16 16 13",
	".reference 16",
	"",
	".table 24 16 16 4",
	" 0  0   4   1111",
	" 0  1   4   1101",
	" 0  2   6   101110",
	" 0  3   7   1010000",
	" 0  4   8   10010010",
	" 0  5   9   100000110",
	" 0  6   9   011111000",
	" 0  7  10   0110110010",
	" 0  8  10   0110101010",
	" 0  9  11   01010011101",
	" 0 10  11   01010001101",
	" 0 11  11   01010001001",
	" 0 12  11   01001101101",
	" 0 13  11   01000000101",
	" 0 14  12   010000001000",
	" 0 15   9   001011000",
	" 1  0   4   1110",
	" 1  1   4   1100",
	" 1  2   5   10101",
	" 1  3   6   100110",
	" 1  4   7   1000111",
	" 1  5   8   10000010",
	" 1  6   8   01111010",
	" 1  7   9   011011000",
	" 1  8   9   011010001",
	" 1  9   9   011000110",
	" 1 10  10   0101000111",
	" 1 11  10   0101011001",
	" 1 12  10   0100111111",
	" 1 13  10   0100101001",
	" 1 14  10   0100010111",
	" 1 15   8   00101010",
	" 2  0   6   101111",
	" 2  1   5   10110",
	" 2  2   6   101001",
	" 2  3   7   1001010",
	" 2  4   7   1000100",
	" 2  5   8   10000000",
	" 2  6   8   01111000",
	" 2  7   9   011011101",
	" 2  8   9   011001111",
	" 2  9   9   011000010",
	" 2 10   9   010110110",
	" 2 11  10   0101010100",
	" 2 12  10   0100111011",
	" 2 13  10   0100100111",
	" 2 14  11   01000011101",
	" 2 15   7   0010010",
	" 3  0   7   1010001",
	" 3  1   6   100111",
	" 3  2   7   1001011",
	" 3  3   7   1000110",
	" 3  4   8   10000110",
	" 3  5   8   01111101",
	" 3  6   8   01110100",
	" 3  7   9   011011100",
	" 3  8   9   011001100",
	" 3  9   9   010111110",
	" 3 10   9   010110010",
	" 3 11  10   0101000101",
	" 3 12  10   0100110111",
	" 3 13  10   0100100101",
	" 3 14  10   0100001111",
	" 3 15   7   0010000",
	" 4  0   8   10010011",
	" 4  1   7   1001000",
	" 4  2   7   1000101",
	" 4  3   8   10000111",
	" 4  4   8   01111111",
	" 4  5   8   01110110",
	" 4  6   8   01110000",
	" 4  7   9   011010010",
	" 4  8   9   011001000",
	" 4  9   9   010111100",
	" 4 10  10   0101100000",
	" 4 11  10   0101000011",
	" 4 12  10   0100110010",
	" 4 13  10   0100011101",
	" 4 14  11   01000011100",
	" 4 15   7   0001110",
	" 5  0   9   100000111",
	" 5  1   7   1000010",
	" 5  2   8   10000001",
	" 5  3   8   01111110",
	" 5  4   8   01110111",
	" 5  5   8   01110010",
	" 5  6   9   011010110",
	" 5  7   9   011001010",
	" 5  8   9   011000000",
	" 5  9   9   010110100",
	" 5 10  10   0101010101",
	" 5 11  10   0100111101",
	" 5 12  10   0100101101",
	" 5 13  10   0100011001",
	" 5 14  10   0100000110",
	" 5 15   7   0001100",
	" 6  0   9   011111001",
	" 6  1   8   01111011",
	" 6  2   8   01111001",
	" 6  3   8   01110101",
	" 6  4   8   01110001",
	" 6  5   9   011010111",
	" 6  6   9   011001110",
	" 6  7   9   011000011",
	" 6  8   9   010111001",
	" 6  9  10   0101011011",
	" 6 10  10   0101001010",
	" 6 11  10   0100110100",
	" 6 12  10   0100100011",
	" 6 13  10   0100010000",
	" 6 14  11   01000001000",
	" 6 15   7   0001010",
	" 7  0  10   0110110011",
	" 7  1   8   01110011",
	" 7  2   8   01101111",
	" 7  3   8   01101101",
	" 7  4   9   011010011",
	" 7  5   9   011001011",
	" 7  6   9   011000100",
	" 7  7   9   010111011",
	" 7  8  10   0101100001",
	" 7  9  10   0101001100",
	" 7 10  10   0100111001",
	" 7 11  10   0100101010",
	" 7 12  10   0100011011",
	" 7 13  11   01000010011",
	" 7 14  11   00101111101",
	" 7 15   8   00010001",
	" 8  0  10   0110101011",
	" 8  1   9   011010100",
	" 8  2   9   011010000",
	" 8  3   9   011001101",
	" 8  4   9   011001001",
	" 8  5   9   011000001",
	" 8  6   9   010111010",
	" 8  7   9   010110001",
	" 8  8   9   010101001",
	" 8  9  10   0101000000",
	" 8 10  10   0100101111",
	" 8 11  10   0100011110",
	" 8 12  10   0100001100",
	" 8 13  11   01000000010",
	" 8 14  11   00101111001",
	" 8 15   8   00010000",
	" 9  0  10   0101001111",
	" 9  1   9   011000111",
	" 9  2   9   011000101",
	" 9  3   9   010111111",
	" 9  4   9   010111101",
	" 9  5   9   010110101",
	" 9  6   9   010101110",
	" 9  7  10   0101001101",
	" 9  8  10   0101000001",
	" 9  9  10   0100110001",
	" 9 10  10   0100100001",
	" 9 11  10   0100010011",
	" 9 12  11   01000001001",
	" 9 13  11   00101111011",
	" 9 14  11   00101110011",
	" 9 15   8   00001011",
	"10  0  11   01010011100",
	"10  1   9   010111000",
	"10  2   9   010110111",
	"10  3   9   010110011",
	"10  4   9   010101111",
	"10  5  10   0101011000",
	"10  6  10   0101001011",
	"10  7  10   0100111010",
	"10  8  10   0100110000",
	"10  9  10   0100100010",
	"10 10  10   0100010101",
	"10 11  11   01000010010",
	"10 12  11   00101111111",
	"10 13  11   00101110101",
	"10 14  11   00101101110",
	"10 15   8   00001010",
	"11  0  11   01010001100",
	"11  1  10   0101011010",
	"11  2   9   010101011",
	"11  3   9   010101000",
	"11  4   9   010100100",
	"11  5  10   0100111110",
	"11  6  10   0100110101",
	"11  7  10   0100101011",
	"11  8  10   0100011111",
	"11  9  10   0100010100",
	"11 10  10   0100000111",
	"11 11  11   01000000001",
	"11 12  11   00101110111",
	"11 13  11   00101110000",
	"11 14  11   00101101010",
	"11 15   8   00000110",
	"12  0  11   01010001000",
	"12  1  10   0101000010",
	"12  2  10   0100111100",

	"12  3  10   0100111000",
	"12  4  10   0100110011",
	"12  5  10   0100101110",
	"12  6  10   0100100100",
	"12  7  10   0100011100",
	"12  8  10   0100001101",
	"12  9  10   0100000101",
	"12 10  11   01000000000",
	"12 11  11   00101111000",
	"12 12  11   00101110010",
	"12 13  11   00101101100",
	"12 14  11   00101100111",
	"12 15   8   00000100",
	"13  0  11   01001101100",
	"13  1  10   0100101100",
	"13  2  10   0100101000",
	"13  3  10   0100100110",
	"13  4  10   0100100000",
	"13  5  10   0100011010",
	"13  6  10   0100010001",
	"13  7  10   0100001010",
	"13  8  11   01000000011",
	"13  9  11   00101111100",
	"13 10  11   00101110110",
	"13 11  11   00101110001",
	"13 12  11   00101101101",
	"13 13  11   00101101001",
	"13 14  11   00101100101",
	"13 15   8   00000010",
	"14  0  12   010000001001",
	"14  1  10   0100011000",
	"14  2  10   0100010110",
	"14  3  10   0100010010",
	"14  4  10   0100001011",
	"14  5  10   0100001000",
	"14  6  10   0100000011",
	"14  7  11   00101111110",
	"14  8  11   00101111010",
	"14  9  11   00101110100",
	"14 10  11   00101101111",
	"14 11  11   00101101011",
	"14 12  11   00101101000",
	"14 13  11   00101100110",
	"14 14  11   00101100100",
	"14 15   8   00000000",
	"15  0   8   00101011",
	"15  1   7   0010100",
	"15  2   7   0010011",
	"15  3   7   0010001",
	"15  4   7   0001111",
	"15  5   7   0001101",
	"15  6   7   0001011",
	"15  7   7   0001001",
	"15  8   7   0000111",
	"15  9   7   0000110",
	"15 10   7   0000100",
	"15 11   8   00000111",
	"15 12   8   00000101",
	"15 13   8   00000011",
	"15 14   8   00000001",
	"15 15   4   0011",
	"",
	".table 25 16 16 5",
	".reference 24",
	"",
	".table 26 16 16 6",
	".reference 24",
	"",
	".table 27 16 16 7",
	".reference 24",
	"",
	".table 28 16 16 8",
	".reference 24",
	"",
	".table 29 16 16 9",
	".reference 24",
	"",
	".table 30 16 16 11",
	".reference 24",
	"",
	".table 31 16 16 13",
	".reference 24",
	"",
	".table 32  1 16 0",
	"  0  1   1",
	"  1  4   0101",
	"  2  4   0100",
	"  3  5   00101",
	"  4  4   0110",
	"  5  6   000101",
	"  6  5   00100",
	"  7  6   000100",
	"  8  4   0111",
	"  9  5   00011",
	" 10  5   00110",
	" 11  6   000000",
	" 12  5   00111",
	" 13  6   000010",
	" 14  6   000011",
	" 15  6   000001",
	"",
	".table 33  1 16 0",
	"  0  4   1111",
	"  1  4   1110",
	"  2  4   1101",
	"  3  4   1100",
	"  4  4   1011",
	"  5  4   1010",
	"  6  4   1001",
	"  7  4   1000",
	"  8  4   0111",
	"  9  4   0110",
	" 10  4   0101",
	" 11  4   0100",
	" 12  4   0011",
	" 13  4   0010",
	" 14  4   0001",
	" 15  4   0000",
	"",
	".end",
	""
};



