/*
			(c) Copyright 1998-2000 - Tord Jansson
			======================================

		This file is part of the BladeEnc MP3 Encoder, based on
		ISO's reference code for MPEG Layer 3 compression, and might
		contain smaller or larger sections that are directly taken
		from ISO's reference code.

		All changes to the ISO reference code herein are either
		copyrighted by Tord Jansson (tord.jansson@swipnet.se)
		or sublicensed to Tord Jansson by a third party.

	BladeEnc is free software; you can redistribute this file
	and/or modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	2000-03-06  Andr Piotrowski
*/

#ifndef LOOP_PVT_H
#define LOOP_PVT_H





/*  ========================================================================================  */
/*       smooth operator                                                          [Sade]      */
/*  ========================================================================================  */
/*
	There was a big fault in original preemphasis() / amp_scalefac_bands():
	You cant simply change the allowed minimal distortion without adapting the current
	distortion --- otherwise the comparison of these values is illegal!


	The following switch allows different levels of preemphasing:

	0:  This is closest to the old algorithm, but the just preemphased bands (upper 10
	    long bands) definitely wont be amplified additionally.
	    --- We believe, this is as faulty as the original...

	1:  If weve just preemphased the upper 10 bands, we dont amplify the lower 11 bands
	    immediately.

	2:	Like 1, but additionally preemphasis gets switched on automatically, if all scale
	    factors reached the values of the preemphasis table.

	3:  The preemphasis flag will be switched on automatically only [if all scale factors
	    reached the values of the preemphasis table].

	Try, which sounds best!
*/

#define		SMOOTH_OPERATOR			2





/*  ------------    dealing with the power table    ----------------------------------------  */

static	void get_the_power (void);                                            /* Snap! Attack */



/*  ------------    basic initialization routines    ---------------------------------------  */

static	void do_you_see_the_light (void);                                     /* Snap! Attack */

static	double while_the_earth_sleeps (void);               /* Deep Forest with Peter Gabriel */

static	void radioactivity (III_psy_ratio *ratio);                               /* Kraftwerk */

static	void kiss_that_frog (void);                                          /* Peter Gabriel */

static	void riding_on_a_dead_horse (void);                     /* Fury In The Slaughterhouse */



/*  ------------    the outer loop and its essential subroutines    ------------------------  */

static	int sooner_or_later                                                     /* Supertramp */
(
	int						max_bits,
	frame_params			*fr_ps
);

static	void silent_running (void);                                 /* Mike And The Mechanics */

static	int big_time (int iteration);                                        /* Peter Gabriel */

static	int missing (frame_params *fr_ps);                         /* Everything But The Girl */

static	int chart_breaker (void);                                             /* Massive Tne */



/*  ------------    quantizing routines    -------------------------------------------------  */

static	void quantize (void);

static	void partial_quantize (void);



/*  ------------    bit counting    --------------------------------------------------------  */

static	int count_bits (void);

static	int count_bits_short (void);

static	int count_bits_long (void);

static	void everything_counts                                                /* Depeche Mode */
(
	unsigned				start,
	unsigned				end,
	unsigned				max,
	unsigned				*table,
	unsigned				*bit_sum
);

static	void step_by_step                                                  /* Whitney Houston */
(
	unsigned				start_sfb,
	unsigned				end_sfb,
	unsigned				max,
	unsigned				*table,
	unsigned				*bit_sum
);



/*  ------------    Huffmania    -----------------------------------------------------------  */

static	void single_Huffman
(
	unsigned				start,
	unsigned				end,
/*	unsigned				table0, == 1 */
	unsigned				*choice,
	unsigned				*sum
);

static	void double_Huffman
(
	unsigned				start,
	unsigned				end,
	unsigned				table0,   /* 2, 5, 13 */
	unsigned				table1,   /* 3, 6, 15 */
	unsigned				*choice,
	unsigned				*sum
);

static	void triple_Huffman
(
	unsigned				start,
	unsigned				end,
	unsigned				table0,   /* 7, 10 */
	unsigned				table1,   /* 8, 11 */
	unsigned				table2,   /* 9, 12 */
	unsigned				*choice,
	unsigned				*sum
);

static	void triple_Huffman_2
(
	unsigned				start,
	unsigned				end,
/*	unsigned				table0,   == 13 */
/*	unsigned				table1,   == 15 */
/*	unsigned				table2,   == 24 */
	unsigned				*choice,
	unsigned				*sum
);

static	void double_Huffman_2   /* Escape tables */
(
	unsigned				start,
	unsigned				end,
	unsigned				table0,   /* 16... */
	unsigned				table1,   /* 24... */
	unsigned				*choice,
	unsigned				*sum
);



/*  ------------    the struggle continues    ----------------------------------------------  */

static	void tiny_single_Huffman
(
	unsigned				start,
	unsigned				end,
/*	unsigned				table0, == 1 */
	unsigned				*choice,
	unsigned				*sum
);

static	void tiny_double_Huffman
(
	unsigned				start,
	unsigned				end,
	unsigned				table0,   /* 2, 5, 13 */
	unsigned				table1,   /* 3, 6, 15 */
	unsigned				*choice,
	unsigned				*sum
);

static	void tiny_triple_Huffman
(
	unsigned				start,
	unsigned				end,
	unsigned				table0,   /* 7, 10 */
	unsigned				table1,   /* 8, 11 */
	unsigned				table2,   /* 9, 12 */
	unsigned				*choice,
	unsigned				*sum
);

static	void tiny_triple_Huffman_2
(
	unsigned				start,
	unsigned				end,
/*	unsigned				table0,   == 13 */
/*	unsigned				table1,   == 15 */
/*	unsigned				table2,   == 24 */
	unsigned				*choice,
	unsigned				*sum
);

static	void tiny_double_Huffman_2   /* Escape tables */
(
	unsigned				start,
	unsigned				end,
	unsigned				table0,   /* 16... */
	unsigned				table1,   /* 24... */
	unsigned				*choice,
	unsigned				*sum
);





#endif  /* LOOP_PVT_H */
