/*
			(c) Copyright 1999 - Tord Jansson
			=================================

		This file is part of the BladeEnc MP3 Encoder, based on
		ISO's reference code for MPEG Layer 3 compression.

		This file doesn't contain any of the ISO reference code and
		is copyright Tord Jansson (tord.jansson@swipnet.se).

	BladeEnc is free software; you can redistribute this file
	and/or modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

*/


#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"arglink.h"

extern	char *mystrupr(char * strng);


/*____ deleteArgLink() ______________________________________________________*/

void deleteArgLink( argLink * pLink )
{
	argLink * pDelete;
	while( pLink != NULL )
	{
		pDelete = pLink;
		pLink = pLink->psNext;
		free( pDelete );
	}
}


/*____ findStrInArgLink() ___________________________________________________*/

argLink * findStrInArgLink( argLink * pLink, char * pString )
{
	char	noncase[256];
	char	temp[256];

	strcpy( noncase, pString );
	mystrupr( noncase );


	while( pLink != NULL )
	{
		strcpy( temp, pLink->pString );
		mystrupr( temp );
		if( strcmp( noncase, temp ) == 0 )
			return	pLink;
		pLink = pLink->psNext;
	}

	return	NULL;
}


/*____ argv2ArgLink() _______________________________________________________*/

argLink * argv2ArgLink( int argc, char * argv[] )
{
	int		i;
	argLink	** wpPrev, * pLink;
	argLink * pFirst = NULL;

	wpPrev = &pFirst;

	for( i = 0 ; i < argc ; i++ )
	{
		pLink = (argLink *) malloc( sizeof(argLink) );
		pLink->pString = argv[i];
		pLink->psNext = NULL;
		* wpPrev = pLink;
		wpPrev = &pLink->psNext;
	}
	return	pFirst;
}


/*____ insertStringInArgLink() ______________________________________________*/

argLink * insertStringInArgLink( argLink ** wpPrev, char * pString )
{
	argLink	* pMyArg;

	pMyArg = (argLink *) malloc( sizeof(argLink) + strlen(pString) + 1);
	pMyArg->pString = ((char *)pMyArg) + sizeof(argLink);
	pMyArg->psNext = * wpPrev;
	* wpPrev = pMyArg;
	strcpy( pMyArg->pString, pString );
	return	pMyArg;
}

/*____ linkStringToArgLink() ________________________________________________*/

argLink * linkStringToArgLink( argLink ** wpPrev, char * pString )
{
	argLink	* pMyArg;

	pMyArg = (argLink *) malloc( sizeof(argLink) );
	pMyArg->pString = pString;
	pMyArg->psNext = * wpPrev;
	* wpPrev = pMyArg;
	return	pMyArg;
}





/*____ addFileContentToArgLink() ____________________________________________*/

int	addFileContentToArgLink( argLink ** wpPrev , char * pFilename )
{
	FILE	* fp;
	argLink * pMyArg;
	int		len;
	char	temp[1024];
	char	* pTmp, * pTmp2;
	int		nArg = 0;

	fp = fopen( pFilename, "r" );
	if( fp == NULL )
		return	-1;

	/* Take line after line */

	while( fgets( temp, 1024, fp ) != NULL )
	{
		/* Skip everything after a '#' */

		 pTmp = strchr( temp, '#' );
		 if( pTmp != NULL )
			 * pTmp = 0;

		/* grab the arguments from the line */

		pTmp = temp;
		len = strlen( temp );
		while( 1 )
		{
			while( * pTmp <= 32 && pTmp < temp + len )
				pTmp++;
			if( pTmp == temp + len )
				break;
			pTmp2 = pTmp;
			while( * pTmp2 > 32 )
				pTmp2++;


			pMyArg = (argLink *) malloc( sizeof( argLink ) + pTmp2 - pTmp + 1 );
			pMyArg->pString = ((char *)pMyArg) + sizeof( argLink );
			pMyArg->psNext = * wpPrev;
			*wpPrev = pMyArg;
			wpPrev = &pMyArg->psNext;
			nArg++;
			
			memcpy( pMyArg->pString, pTmp, pTmp2 - pTmp );
			pMyArg->pString[pTmp2 - pTmp] = 0;
			pTmp = pTmp2;
		}

	}
	fclose( fp );
	return	nArg;
}



