/*
			(c) Copyright 1998, 1999 - Tord Jansson
			=======================================

		This file is part of the BladeEnc MP3 Encoder, based on
		ISO's reference code for MPEG Layer 3 compression.

		This file doesn't contain any of the ISO reference code and
		is copyright Tord Jansson (tord.jansson@swipnet.se).

	BladeEnc is free software; you can redistribute this file
	and/or modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

*/

/*==== High level defines =====================================================*/


#define			WIN32_INTEL             0
#define			WIN32_ALPHA             1
#define			LINUX_I386              2
#define			LINUX_PPC               3
#define			LINUX_SPARC    			4
#define			LINUX_ALPHA				5
#define			SOLARIS                 6
#define			IBM_OS2                 7
#define			IRIX					8
#define			ATARI_TOS				9
#define			UNIXWARE7				10
#define			SCO5					11
#define			ULTRIX					12
#define			NETBSD					13
#define			OPENBSD					14
#define			HPUX					15
#define			MSDOS_DJGPP				16
#define			MAC_OS					17	/* To compile the Mac version you also need Petteri Kamppuri's wrapper */
#define			BEOS_PPC				18
#define			BEOS_X86				19

#ifndef	SYSTEM
#	define		SYSTEM		LINUX_I386		/* Set current system here, select */
#endif										/* from list above. */


/*#define			PRECISE_TIMER*/		/* Gives more accurate speed calculations, */
									/* just for debug purposes. Disable in release version! */
 
/*==== Low level defines ======================================================*/
 
/*
  LIST OF DEFINES
  ===============

  BYTEORDER	[byteorder]     Should either be set to BIG_ENDIAN or LITTLE_ENDIAN depending on the processor.
  INLINE    [prefix]        Defines the prefix for inline functions, normally _inline.
                             Skip this define if your compiler doesn't support inline functions.
  DRAG_DROP                 Set if Drag-n-Drop operations are supported. If defined, the hint for drag and drop
                             is displayed in the help text.
  PRIO                      Set if priority can be set with the -PRIO switch (UNIX_SYSTEM enables this automatically).
  MSWIN                     Set this for windows systems. Includes "windows.h" etc.
  WILDCARDS                 Set this if the program has to expand wildcards itself on your system.
  NO_ZERO_CALLOC            Set this to work around a bug when allocation 0 bytes memory with some compilers.
  DIRECTORY_SEPARATOR		Should either be '\\' or '/'.
  WAIT_KEY					Set this on systems where we as default want to wait for a keypress before quiting.
  UNIX_SYSTEM				Set this for UNIX-systems that are posix and (at least to some extent) bsd compliant
							 to enable stuff like config-file support, priority settings etc.
  PAUSE_25_LINES			Wait for keypress after 25 lines of output when listing important information.
*/


/*  Most systems allready have these two defines, but some doesn't 
    so we have to put them here, before they are used. */

#ifndef BIG_ENDIAN
#	define			BIG_ENDIAN				4321
#endif

#ifndef LITTLE_ENDIAN
#	define			LITTLE_ENDIAN			1234
#endif

 

/*_____ Windows 95/98/NT Intel defines ________________________________________*/

#if     SYSTEM == WIN32_INTEL

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			INLINE					_inline
#		define			DRAG_DROP
#		define			PRIO
#		define			MSWIN
#		define			WILDCARDS
#		define			DIRECTORY_SEPARATOR		'\\'
#		define			WAIT_KEY
#		define			PAUSE_25_LINES
#endif

/*_____ Windows NT DEC Alpha defines __________________________________________*/

#if SYSTEM == WIN32_ALPHA

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			INLINE					_inline
#		define			DRAG_DROP
#		define			PRIO
#		define			MSWIN
#		define			WILDCARDS
#		define			DIRECTORY_SEPARATOR		'\\'
#		define			WAIT_KEY
#		define			PAUSE_25_LINES
#endif


/*____ Linux i386 defines ___________________________________________________*/

#if SYSTEM == LINUX_I386

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			INLINE					inline
#		define			DIRECTORY_SEPARATOR		'/'
#		define			UNIX_SYSTEM
#endif

/*____ Linux Sparc defines __________________________________________________*/

#if SYSTEM == LINUX_SPARC

#		define			BYTEORDER				BIG_ENDIAN
#		define			INLINE					inline
#		define			DIRECTORY_SEPARATOR		'/'
#		define			UNIX_SYSTEM
#endif

/*____ LinuxPPC defines _____________________________________________________*/

#if SYSTEM == LINUX_PPC
				
#		define			BYTEORDER               BIG_ENDIAN
#		define			INLINE					inline
#		define			DIRECTORY_SEPARATOR     '/'
#		define			UNIX_SYSTEM
#endif

/*____ Linux Alpha defines __________________________________________________*/

#if SYSTEM == LINUX_ALPHA

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			DIRECTORY_SEPARATOR		'/'
#		define			UNIX_SYSTEM	
#endif


/*____ Solaris defines ______________________________________________________*/

#if SYSTEM == SOLARIS

#		define			BYTEORDER				BIG_ENDIAN
#		define			DIRECTORY_SEPARATOR		'/'
#		define			UNIX_SYSTEM
#endif


/*____ OS/2 _________________________________________________________________*/

#if SYSTEM == IBM_OS2

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			INLINE					inline
#		define			PRIO
#		define			WILDCARDS
#		define			DIRECTORY_SEPARATOR		'\\'
#		define			OS2
#		define			WAIT_KEY
#		define			PAUSE_25_LINES
#endif


/*____ IRIX defines _________________________________________________________*/

#if SYSTEM == IRIX

#		define			BYTEORDER				BIG_ENDIAN
#		define			DIRECTORY_SEPARATOR		'/'
#		define			UNIX_SYSTEM
#endif


/*____ Atari TOS ____________________________________________________________*/

#if SYSTEM == ATARI_TOS

#		define			BYTEORDER				BIG_ENDIAN
#		define			INLINE					inline
#		define			DIRECTORY_SEPARATOR		'\\'
#		define			TOS
#		define			PAUSE_25_LINES
 #endif


/*____ UNIXWARE7 ____________________________________________________________*/

#if SYSTEM == UNIXWARE7

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			DIRECTORY_SEPARATOR		'/'
#		define			UNIX_SYSTEM
#endif

/*____ SCO OpenServer 5.x ___________________________________________________*/

#if SYSTEM == SCO5

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			DIRECTORY_SEPARATOR		'/'
#		define			UNIX_SYSTEM
#endif

/*____ Ultrix defines ________________________________________________________*/

#if SYSTEM == ULTRIX

#		define			BYTEORDER				LITTLE_ENDIAN
#		define			DIRECTORY_SEPARATOR		'/'
#		define			HAVE_USHORT
#		define			HAVE_UINT
#		include			<sys/types.h>                  /* for uint and ushort */
#		define			UNIX_SYSTEM
#endif

/*____ NetBSD defines ________________________________________________________*/

#if SYSTEM == NETBSD

#		include			<machine/endian.h>
#		define			BYTEORDER				BYTE_ORDER
#		define			DIRECTORY_SEPARATOR		'/'
#		define			HAVE_USHORT
#		define			HAVE_UINT
#		define			UNIX_SYSTEM
#endif


/*____ OpenBSD defines ________________________________________________________*/

#if SYSTEM == OPENBSD
#		include			<machine/endian.h>
#		define			BYTEORDER				BYTE_ORDER
#		define			DIRECTORY_SEPARATOR		'/'
#		define			HAVE_USHORT
#		define			HAVE_UINT
#		define			UNIX_SYSTEM
#endif


/*____ HP/UX defines ________________________________________________________*/

#if SYSTEM == HPUX
#		define    		BYTEORDER				BIG_ENDIAN
#		define			DIRECTORY_SEPARATOR     '/'
#		define    		INLINE
#		define			HAVE_USHORT
#		define			HAVE_UINT
#		define			UNIX_SYSTEM
#endif


/*____ MSDOS_DJGPP _________________________________________________________*/

#if SYSTEM == MSDOS_DJGPP
#		define          BYTEORDER				LITTLE_ENDIAN
#		define          INLINE					inline
#		define			DIRECTORY_SEPARATOR		'\\'
#endif

/*____ MAC_OS ________________________________________________________________*/

#if SYSTEM == MAC_OS
#		define			BYTEORDER				BIG_ENDIAN
#		define			INLINE					inline
#		define			DIRECTORY_SEPARATOR		':'
#		define			NO_ZERO_CALLOC
#endif

/*____ BeOS PowerPC ___________________________________________________*/

#if SYSTEM == BEOS_PPC
#		define 			BYTEORDER				BIG_ENDIAN
#		define 			DIRECTORY_SEPARATOR		'/'
#		define 			INLINE					inline
#endif

/*____ BeOS x86 ___________________________________________________*/

#if SYSTEM == BEOS_X86
#		define 			BYTEORDER				LITTLE_ENDIAN
#		define 			DIRECTORY_SEPARATOR		'/'
#		define 			INLINE					inline
#endif


/*____ Some defines automatically gives other...*/

#ifdef UNIX_SYSTEM
#	ifndef	PRIO
#		define	PRIO
#	endif
#endif


/*____ To make sure that certain necessary defines are set... */

#ifndef INLINE
#		define INLINE
#endif

/*==== Other Global Definitions, placed here for convenience ==================*/


#ifndef FALSE
#	define         FALSE           0
#endif
#ifndef TRUE
#	define         TRUE            1
#endif

typedef		unsigned	char 	uchar;

#if !defined(SYS_TYPES_H) && !defined(_SYS_TYPES_H)
#	ifndef	HAVE_USHORT
		typedef		unsigned short	ushort;
#	endif
#	ifndef	HAVE_UINT
		typedef		unsigned int	uint;
#	endif
#endif


















