/*
			(c) Copyright 1998-2000 - Tord Jansson
			======================================

		This file is part of the BladeEnc MP3 Encoder, based on
		ISO's reference code for MPEG Layer 3 compression, and might
		contain smaller or larger sections that are directly taken
		from ISO's reference code.

		All changes to the ISO reference code herein are either
		copyrighted by Tord Jansson (tord.jansson@swipnet.se)
		or sublicensed to Tord Jansson by a third party.

	BladeEnc is free software; you can redistribute this file
	and/or modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	2000-02-15  Pirandot
*/


/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension
 *
 * $Id: loop-pvt.h,v 1.1 1996/02/14 04:04:23 rowlands Exp $
 *
 * Private interface declarations for loop.c
 *
 * $Log: loop-pvt.h,v $
 * Revision 1.1  1996/02/14 04:04:23  rowlands
 * Initial revision
 *
 * Received from Mike Coleman
 **********************************************************************/

#ifndef LOOP_PVT_H
#define LOOP_PVT_H

/*
  Revision History:

  Date        Programmer                Comment
  ==========  ========================= ===============================
  1995/10/01  mc@fivebats.com           created

*/


int outer_loop
(
	double					abs_xr[576],	/* magnitudes of the spectral values */
	int						max_bits,
	III_psy_xmin			*l3_xmin,		/* the allowed distortion of the scalefactor */
	int						abs_ix[576],	/* vector of quantized values ix(0..575) */
	frame_params			*fr_ps,
	III_scalefac_t			*scalefac,		/* scalefactors */
	int						gr,
	int						ch,
	III_side_info_t			*l3_side
);

int inner_loop
(
	double					*abs_xr,
	int						*abs_ix,
	int						max_bits,
	gr_info					*cod_info
);

int part2_length( III_scalefac_t *scalefac,
		  frame_params *fr_ps,
		  int gr,
		  int ch,
		  III_side_info_t *si );

int scale_bitcount( III_scalefac_t *scalefac,
                    gr_info *cod_info,
                    int gr,
                    int ch );

void calc_noise( double xr[576],
                 int ix[576],
                 gr_info *cod_info,
                 double xfsf[4][CBLIMIT] );

int loop_break( III_scalefac_t *scalefac,
                gr_info *cod_info,
                int gr,
                int ch );

void preemphasis( double xr[576],
                  double xfsf[4][CBLIMIT],
                  III_psy_xmin  *l3_xmin,
                  int gr,
                  int ch,
		  III_side_info_t *l3_side );

int amp_scalefac_bands( double xr[576],
                        double xfsf[4][CBLIMIT],
                        III_psy_xmin  *l3_xmin,
			III_side_info_t *l3_side,
                        III_scalefac_t *scalefac,
                        int gr,
                        int ch,
			int iteration );

void quantize_tj
(
	double					abs_xr[576],
	int						abs_ix[576],
	gr_info					*cod_info
);

int ix_max_tj
(
	int						abs_ix[576],
	unsigned int			begin,
	unsigned int			end
);

int count_bits
(
	int						abs_ix[576],
	gr_info					*cod_info
);

int new_choose_table_tj
(
	int						abs_ix[576],
	unsigned int			begin,
	unsigned int			end
);

int choose_table (unsigned int max);

int count_bit_tj
(
	int						abs_ix[576],
	unsigned int			start,
	unsigned int			end,
	unsigned int			table
);

int bin_search_StepSize
(
	int						desired_rate,
	double					start,
	int						*abs_ix,
	double					abs_xr[576],
	gr_info					*cod_info
);

#endif
