/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* ircomm.c
 */

#include <irda.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

static int verbosity;
static int nlcr;

/**********************************************************************
 * COMM control
 **********************************************************************/

static void input(void* handle)
{
  COMMClient* comm=(COMMClient*)handle;
  u_char buf[1024];
  int i,len=read(fileno(stdin),buf,sizeof buf);

  if(len>0) {
    if(nlcr) for(i=0;i<len;i++) if(buf[i]=='\n') buf[i]='\r';
    commCltWrite(comm,buf,len);
  }
}

static void commStatus(COMMClient* cc, int event)
{
  switch(event) {
  case COMM_CONNECTED:
    if(verbosity>0) log("comm connected\n");

    commCltSetParams(cc,57600,COMM_8N1);
    commCltSetDTE(cc,COMM_DTR|COMM_RTS);

    evtAddSource(fileno(stdin),input,cc);

    break;
  case COMM_DISCONNECTED:
    if(verbosity>0) log("comm disconnected\n");
    break;
  }
}

static void commData(COMMClient* c, void* buf, int len)
{
  fwrite(buf,1,len,stdout);
}

/**********************************************************************
 * LAP control
 **********************************************************************/

static void lapConnected(LAP* lap)
{
  COMMClient* comm;

  if(verbosity>0) log("LAP connected\n");
  comm=createCOMMClient(lap,COMM_ST_3WIRE|COMM_ST_9WIRE,COMM_PT_SERIAL,FALSE);
  if(!comm) {
    log("COMM connect failed\n");
    lapDisconnect(lap);
  }
  comm->status=commStatus;
  comm->data=commData;
}

static void lapDisconnected(LAP* lap)
{
  exit(0);
}

/**********************************************************************
 * Main function
 **********************************************************************/

static const char* description="Connect stdin or pty to IrDA COMM port";

static Option options[] = {
  { OPTION_BOOL, 'r', 0, "map \\n to \\r in input" },
};

int main(int argc, char** argv)
{
  doOptions(argc,argv,1,options,&verbosity,description);

  optLap->flags|=HINT_IRCOMM;
  optLapConnected=lapConnected;
  optLapDisconnected=lapDisconnected;

  if(options[0].val.b) nlcr=1;
  doConnect();
  evtLoop();

  return 0;
}
