/* bfbtester -- Brute Force Binary Tester
 *
 * Copyright 2000	Mike Heffner <spock@techfour.net>
 * Use it and abuse it, but send patches and/or money to me. =)
 */

#ifndef __DATATYPES_H__
#define __DATATYPES_H__

#include <sys/types.h>
#include <sys/time.h>

#include <pthread.h>

typedef struct _exec_data	EXEC_DATA;
struct _exec_data {

	pid_t		pid;
	int			status; /* as used with wait() and friends */
	
	int			sout[2];
	char	   *sout_buf;

	int			sin[2];
	char	   *sin_buf;
	
	char	  **args;
	char	   *cargs; /* string version */
	char	   *progpath;
	char	  **env;
	char	   *cenv;  /* string version */
	u_char	   	using_environ;	/* flag (TRUE) if we are using environ 
								 * (doesn't need to be free()'d)
								 */

	char		*chroot_dir; /* for tempfile monitoring */

	struct timeval	tm; /* start time */
	EXEC_DATA  *prev;
	EXEC_DATA  *next;

};

typedef struct _thread_data	THREAD_DATA;
struct _thread_data {

	pthread_mutex_t		*mut;
	pthread_t			run_thread;
	pthread_t			poll_thread;
	int					current_execs;
	int					max_execs;
	
};
	
#ifndef	FALSE
#define FALSE 0
#define TRUE (!FALSE)
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN	1024
#endif

#endif /* __DATATYPES_H__ */
