/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <gtk/gtk.h>
#include "throw.h"
#include "game.h"
#include "set.h"
#include "list.h"
#include "def.h"

/* set_draw: set the draw flag on 
 * each card in a list.
 */
void set_draw(GList *ptr, gboolean value)
{
	struct _card *data_ptr;
	
	for(; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		data_ptr->draw = value;
	}
}

void set_draw_face(GList *ptr, gboolean value)
{
	struct _card *data_ptr;
	
	for(; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		data_ptr->draw_face = value;
	}
}

void set_draw_face_x(GList *ptr, gboolean value, int family, int num)
{
	struct _card *data_ptr;
	
	for(; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		if( (data_ptr->family == family) 
		&& data_ptr->num == num)
		{
			data_ptr->draw_face = value;
		}
	}
}

void set_show_carre(GList *ptr, gboolean value, int x)
{
	struct _card *data_ptr;
	
	for(; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		if(data_ptr->num == x)
			data_ptr->draw_face = value;
	}
}

void set_player_hand_moveable(struct _prog *prog_data)
{
	GList *hand;
	GList *table = prog_data->waiting;
	
	int trumpfamily = prog_data->family;
	
	if(table != NULL)
	{
		int bestpoints = 0, bestfamily = -1;
		
		struct _card *first = game_get_best(&bestpoints, &bestfamily, trumpfamily, table);
		struct _card *tmp;
		
		if(first != NULL)
		{
			int i = 0;
			
			/* The current family to be played is 
			 * something else than the trump one */
			if(first->family != trumpfamily)
			{
				/* set all cards from this family 
				 * as moveable */
				for(hand = prog_data->players[2]; hand; hand = hand->next)
				{
					tmp = hand->data;
					if(tmp->family == first->family)
					{
						tmp->moveable = TRUE;
						i++;
					}
				}
				
			}
			/* The current family is the trump one 
			 * or we have no card of the first->family */
			if(first->family == trumpfamily || i == 0)
			{
				/* There is a trump card on the table 
				 * so we must play a higher one */
				if(bestfamily == trumpfamily && 
				(prog_data->menext%2 == 1 || first->family == trumpfamily))
				{
					for(hand = prog_data->players[2]; hand; hand = hand->next)
					{
						tmp = hand->data;
						if(tmp->family == trumpfamily 
						&& tmp->points > bestpoints)
						{
							tmp->moveable = TRUE;
							i++;
						}
					}
				}
				/* if we have no higher trump card 
				 * or if we have to play an other card 
				 * but don't have that family in our game, 
				 * in all case we must play any of 
				 * our trump cards  */
				if(i == 0 && (prog_data->menext%2 == 1 || 
					first->family == trumpfamily))
				{
					for(hand = prog_data->players[2]; hand; hand = hand->next)
					{
						tmp = hand->data;
						if(tmp->family == trumpfamily)
						{
							tmp->moveable = TRUE;
							i++;
						}
					}
					
				}
				/* Heve we have no trump card at all. 
				 * We can play anything. */
				if(i == 0)
					set_moveable(prog_data->players[2], TRUE);
			}
		}
	}
	
}

/* set_moveable: set the moveable flag 
 * on each card in a list.
 */
void set_moveable(GList *ptr, gboolean value)
{
	struct _card *data_ptr;
	
	for(; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		data_ptr->moveable = value;
	}
}

/* set_status: change state of 
 * each card in a list.
 */
void set_status(GList *ptr, enum estatus s)
{
	struct _card *data_ptr;
	
	for(; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		data_ptr->status = s;
	}
}

/* set_notmaster_points: take 
 * care of setting points for 
 * a card which is not in the 
 * trump family.
 */
int set_notmaster_points(int num)
{
	int value = 0;
	
	switch(num)
	{
		case 0:
		value = 110;
		break;
		
		case 6:
		case 7:
		case 8:
		value = num+1;
		break;
		
		case 9:
		value = 100;
		break;
		
		case 10:
		value = 20;
		break;
		
		case 11:
		value = 30;
		break;
		
		
		case 12:
		value = 40;
		break;
	}
	
	return(value);
}

/* set_master_points: for each card, 
 * the value of the points changes. 
 * That will take care to set the 
 * correct value for a card in the 
 * trump color.
 */
int set_master_points(int num)
{
	int value = 0;
	
	switch(num)
	{
		case 0:
		value = 110;
		break;
		
		case 6:
		case 7:
		value = num+1;
		break;

		case 8:
		value = 140;
		break;
		
		case 9:
		value = 100;
		break;
		
		case 10:
		value = 200;
		break;
		
		case 11:
		value = 30;
		break;
		
		case 12:
		value = 40;
		break;
	}
	
	return(value);
}

/* set_individual_list: set points to the 
 * cards in the list. 
 */
void set_individual_list(GList *lst, int family)
{
	struct _card *data;
	
	while(lst)
	{
		data = (struct _card*)lst->data;
		
		if(data->family == family)
		{
			data->points = set_master_points(data->num);
		}
		else
		{
			data->points = set_notmaster_points(data->num);
		}
		
		lst = lst->next;
	}
}

/* set_points: set the value of every 
 * available card in this game. This 
 * will just go through every player 
 * list.
 */
void set_points(struct _prog *prog_data)
{
	int i;
	
	for(i = 0; i < 4; i++)
	{
		set_individual_list(prog_data->players[i], 
			prog_data->family);
		
	}
}

