/********************************************************************
 * Copyright (C) Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of Beesoft Differ.
 *
 * Beesoft Differ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * Beesoft Differ is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beesoft Differ; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project      : Beesoft Differ
 * File         : QBtPointsButton.cpp
 * Author       : Piotr Pszczolkowski
 * Contact      : piotr@beesoft.org
 * Creation date: 04.02.2008
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "QBtPointsButton.h"

/*------- local constants:
-------------------------------------------------------------------*/
const QString QBtPointsButton::POINTS = " ... ";


//*******************************************************************
// QBtPointsButton                                       CONSTRUCTOR
//*******************************************************************
QBtPointsButton::QBtPointsButton( QWidget* const in_parent )
: QPushButton( POINTS, in_parent )
{}
// end of QBtPointsButton

//*******************************************************************
// showEvent                                       PRIVATE inherited
//*******************************************************************
void QBtPointsButton::showEvent( QShowEvent* const in_event )
{
   const QWidget* const parent_widget = dynamic_cast< QWidget* >( parent() );
   if( parent_widget ) {
      const int w = parent_widget->fontMetrics().width( POINTS ) << 1;
      setMinimumWidth( w );
      setMaximumWidth( w );
   }
   QPushButton::showEvent( in_event );
}
// end of showEvent
