#ifndef INCLUDED_QBtConfig_h
#define INCLUDED_QBtConfig_h
/********************************************************************
 * Copyright (C) Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of Beesoft Differ.
 *
 * Beesoft Differ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * Beesoft Differ is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beesoft Differ; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project      : Beesoft Differ
 * File         : QBtConfig.cpp
 * Author       : Piotr Pszczolkowski
 * Contact      : piotr@beesoft.org
 * Creation date: 19.02.2008
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include <QObject>
#include <QColor>
#include <QFont>
#include <QBrush>

/*------- class declaration:
-------------------------------------------------------------------*/
class QBtConfig : public QObject
{
   Q_OBJECT
   
// ******* CONSTRUCTION / DESTRUCTION *******
private:
   QBtConfig();
   QBtConfig( const QBtConfig& );
   QBtConfig& operator=( const QBtConfig& );
public:
   ~QBtConfig();

// ******* CONSTANTS *******
public:
   static const QString MAIN_WINDOW_GROUP;
   static const QString POS_KEY;
   static const QString SIZE_KEY;
   static const QString STATE_KEY;
   static const QString FPATH_HISTORY_SIZE_KEY;
   static const QString LFT_FPATH_HISTORY_KEY;
   static const QString RGT_FPATH_HISTORY_KEY;
   //--------------------------------------------
   static const QString BROWSER_GROUP;
   static const QString BKG_COLOR_KEY;
   static const QString FNT_COLOR_KEY;
   static const QString FNT_FONT_KEY;
   static const QString CHG_COLOR_KEY;
   static const QString ADD_COLOR_KEY;
   static const QString DEL_COLOR_KEY;
   //--------------------------------------------
   static const QString DIFF_GROUP;
   static const QString CASE_KEY;
   static const QString TAB_EXP_KEY;
   static const QString WSPACE_AMOUNT_KEY;
   static const QString WSPACE_ALL_KEY;
   static const QString BLANK_LINES_KEY;
   static const QString AS_TEXT_KEY;

private:
   static const int     DEFAULT_FPATH_HISTORY_SIZE;
   static const QColor  DEFAULT_BKG_COLOR;
   static const QColor  DEFAULT_FNT_COLOR;
   static const QString DEFAULT_FONT_STRING;
   static const QColor  DEFAULT_DEL_COLOR;
   static const QColor  DEFAULT_ADD_COLOR;
   static const QColor  DEFAULT_CHG_COLOR;

   
// ******* MEMBERS *******
private:
   int    fpath_history_size_;
   QColor bkg_color_;
   QFont  font_;
   QColor font_color_;
   QColor chg_color_;
   QColor add_color_;
   QColor del_color_;
   bool   diff_case_;
   bool   diff_tab_exp_;
   bool   diff_wspace_amount_;
   bool   diff_wspace_all_;
   bool   diff_blank_lines_;
   bool   diff_as_text_;
   QBrush bkg_brush_;
   QBrush chg_brush_;
   QBrush add_brush_;
   QBrush del_brush_;
   
// ******* METHODS *******
public:
   static QBtConfig* const instance();
   
   void          update();
   void          save_data();
   void          fpath_history_size ( const int in_value ) { fpath_history_size_ = in_value; }
   int           fpath_history_size () const { return fpath_history_size_; }
   void          font( const QFont& in_value ) { font_ = in_value; }
   const QFont&  font() const { return font_; }
   void          font_color( const QColor& in_value ) { font_color_ = in_value; }
   const QColor  font_color() const { return font_color_; }
   //------- bkg_color ------------------------------------
   void          bkg_color( const QColor& in_value ) {
                     bkg_color_ = in_value;
                     bkg_brush_.setColor( bkg_color_ );
                 }
   void          bkg_color( const QString& in_value ) {
                     bkg_color_.setNamedColor( in_value );
                     bkg_brush_.setColor( bkg_color_ );
                 }
   const QColor& bkg_color() const { return bkg_color_; }

   //------- chg_color ------------------------------------
   void          chg_color( const QColor& in_value ) { 
                     chg_color_ = in_value;
                     chg_brush_.setColor( chg_color_ );
                 }
   void          chg_color( const QString& in_value ) {
                     chg_color_.setNamedColor( in_value );
                     chg_brush_.setColor( chg_color_ );
                 }
   const QColor& chg_color() const { return chg_color_; }
   //------- add_color ------------------------------------
   void          add_color( const QColor& in_value ) {
                     add_color_ = in_value;
                     add_brush_.setColor( add_color_ );
                 }
   void          add_color( const QString& in_value ) {
                     add_color_.setNamedColor( in_value );
                     add_brush_.setColor( add_color_ );
                 }
   const QColor& add_color() const { return add_color_; }
   //------- del_color ------------------------------------
   void          del_color( const QColor& in_value ) {
                     del_color_ = in_value;
                     del_brush_.setColor( del_color_ );
                 }
   void          del_color( const QString& in_value ) {
                     del_color_.setNamedColor( in_value );
                     del_brush_.setColor( del_color_ );
                 }
   const QColor& del_color() const { return del_color_; }
   //------- brushe ---------------------------------------
   const QBrush& bkg_brush() const { return bkg_brush_; }
   const QBrush& chg_brush() const { return chg_brush_; }
   const QBrush& add_brush() const { return add_brush_; }
   const QBrush& del_brush() const { return del_brush_; }
   
   void diff_case( const bool in_value ) { diff_case_ = in_value; }
   bool diff_case() const { return diff_case_; }
   void diff_tab_exp( const bool in_value ) { diff_tab_exp_ = in_value; }
   bool diff_tab_exp() const { return diff_tab_exp_; }
   void diff_wspace_amount( const bool in_value ) { diff_wspace_amount_ = in_value; }
   bool diff_wspace_amount() const { return diff_wspace_amount_; }
   void diff_wspace_all( const bool in_value ) { diff_wspace_all_ = in_value; }
   bool diff_wspace_all() const { return diff_wspace_all_; }
   void diff_blank_lines( const bool in_value ) { diff_blank_lines_ = in_value; }
   bool diff_blank_lines() const { return diff_blank_lines_; }
   void diff_as_text( const bool in_value ) { diff_as_text_ = in_value; }
   bool diff_as_text() const { return diff_as_text_; }

private:
   void read_data();
};

#endif // INCLUDED_QBtConfig_h
