#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

/* error() - output error messages */

void error(char *token,char *expected,char *keyword)
{
  printf("Parse Error: Expected '%s' and got '%s' in '%s' on line %d\n",expected,token,keyword,line);
}

void unsupported(char *keyword)
{
  printf("Not Supported: '%s' on line %d.\n            -- asp2php attemps work around it.\n",keyword,line);
}

void comment_out(char *tmp_token)
{
char token[TOKENSIZE];
int tokentype;

  fprintf(out,"// %s",tmp_token);
  while(1)
  {
    tokentype=gettoken(token);
    if (tokentype==0 || tokentype==5)
    { fprintf(out,"\n"); break; }
    fprintf(out," %s",token);
  }
}

/* push() - pushback a token (for looking ahead) */

void push(char *token,int tokentype)
{
  strcpy(tokenpush,token);
  tokentypepush=tokentype;
}

void push2(char *token,int tokentype)
{
  strcpy(tokenpush2,token);
  tokentypepush2=tokentype;
}

/* isnum() - check and see if current string is a number */
/* PHP 3.0 and lower didn't have an isnum type function
   close enough to asp this adds one into the output source
   if needed */

int isnum(char *s)
{
int l,t;

  l=strlen(s);

  for(t=0; t<l; t++)
  { if (s[t]<'0' || s[t]>'9') return 0; }

  return 1;
}

/* strcasestr - case insensitive version of strstr */

char *strcasestr(char *hejstack, char *needle)
{
int hejlen,neelen;
int t;

  hejlen=strlen(hejstack);
  neelen=strlen(needle);

  for(t=0; t<=hejlen-neelen; t++)
  {
    if (strncasecmp(&hejstack[t],needle,neelen)==0)
    { return &hejstack[t]; }
  }

  return (char *)0;
}

/* Decide the case of an asp variable and change */

void strcase(char *s)
{
int l,r;

  if (casesense==0) return;

  l=strlen(s);

  for(r=0; r<l; r++)
  {

    if (casesense==1)
    { s[r]=tolower(s[r]); }
      else
    { s[r]=toupper(s[r]); }
  }
}

int is_asp_filename(char *filename)
{
int t;

  for (t=0; t<aspextensions_ptr; t++)
  {
    if (strlen(filename)>strlen(aspextensions[t]))
    {
      if (strcasecmp(filename+(strlen(filename)-strlen(aspextensions[t])),aspextensions[t])==0)
      { return 1; }
    }
  }

  return 0;
}

int extcmp(char *filename, char *extension)
{
  if (strlen(filename)>strlen(extension))
  {
    if (strcasecmp(filename+(strlen(filename)-strlen(extension)),extension)==0)
    { return 1; }
  }

  return 0;
}

void change_extension(char *filename, char *extension)
{
int t,r;

  t=strlen(filename);

  for (r=t; r>=0; r--)
  {
    if (filename[r]=='.')
    {
      strcpy(filename+r,extension);
      return;
    }
  }
}

/* autoindent() - this sets up proper clean Kohnian style
   programming indenting in the outputted php code */

int autoindent()
{
int r;
char spaces[1024];

  /* if (column!=0) return 0; */
  strcpy(spaces,"");

  for (r=0; r<indent; r++)
  { strcat(spaces,"  "); }

  fprintf(out,"%s",spaces);

  return 0;
}

void add_indent(char *newtoken)
{
int r;

  for (r=0; r<indent; r++)
  { strcat(newtoken,"  "); }
}

void strtolower(char *s)
{
int r;

  r=0;
  while(1)
  {
    if (s[r]==0) break;
    s[r]=tolower(s[r]);
    r++;
  }

}

void insert_isnum()
{
  fprintf(out,"\nfunction IsNumeric($n)\n{\n");
  fprintf(out,"  $p=trim($n);\n  $l=strlen($p);\n\n");
  fprintf(out,"  for ($t=0; $t<$l; $t++)\n");
  fprintf(out,"  {\n    $c=substr($p,$t,1);\n");
  fprintf(out,"    if ($c<'0' || $c>'9')\n");
  fprintf(out,"    { if ($c!='.') return 0; }\n");
  fprintf(out,"  }\n\n  return 1;\n}\n");

  add_isnum=0;
}

/* getobject() - figure out what kind of object the
   next token is and place it in the literal pool */

int getobject(char *token)
{
int t;

  for (t=0; t<objectsptr; t++)
  { if (strcasecmp(token,objects[t])==0) break; }

  if (t==objectsptr) return 0;

  if (strcasestr(objectstype[t],"ADODB.Connection")!=0) return 1;
  if (strcasestr(objectstype[t],"ADODB.Execute")!=0) return 2;
  if (strcasestr(objectstype[t],"ADODB.Command")!=0) return 3;
  if (strcasestr(objectstype[t],"ADODB.RecordSet")!=0) return 2;
  if (strcasestr(objectstype[t],"Scripting.FileSystem")!=0) return 5;
  if (strcasestr(objectstype[t],"JMail.SMTPMail")!=0) return 6;
  if (strcasestr(objectstype[t],"CDONTS.NewMail")!=0) return 7;

  return 0;
}

/* fixw2k changes occurances of .asp to .php3 and
   .htm to .html */

int fixw2k(char *token)
{
int l,sl,t;

  sl=strlen(token)-4;

  for (l=1; l<sl; l++)
  {
    if (token[l]=='.')
    {
      if ((token[l+1]=='a' || token[l+1]=='A') &&
         ((token[l+2]=='s' || token[l+2]=='S') &&
         (token[l+3]=='p' || token[l+3]=='P')))
      {
	if (!((token[l+4]>='a' && token[l+4]<='z') ||
	(token[l+4]>='A' && token[l+4]<='Z')))
        {
          token[l+1]='p';
          token[l+2]='h';
          token[l+3]='p';

          if (php!=0)
          {
            for (t=sl+4; t>l+3; t--)
            { token[t+1]=token[t]; }
            if (php==3)
            { token[l+4]='3'; }
              else
            { token[l+4]='4'; }
	    sl++;
	  }
        }
      }
	else
      if ((token[l+1]=='h' || token[l+1]=='H') &&
         ((token[l+2]=='t' || token[l+2]=='T') &&
         (token[l+3]=='m' || token[l+3]=='M')))
      {
	if (!((token[l+4]>='a' && token[l+4]<='z') ||
	(token[l+4]>='A' && token[l+4]<='Z')))
        {
          if (html==1)
          {
            for (t=sl+4; t>l+3; t--)
            { token[t+1]=token[t]; }
            token[l+4]='l';
            sl++;
          }
        }
      }
    }
  }

  return 0;
}

int is_endscript()
{
char token[1024];
int tokentype;
char molecule[4096];

  strcpy(molecule,"<");
  tokentype=gettoken(token);
  strcat(molecule,token);
  tokentype=gettoken(token);
  strcat(molecule,token);
  tokentype=gettoken(token);
  strcat(molecule,token);

  if (strcasecmp("</script>",molecule)==0)
  { return 1; }

  return 0;
}

void eval_funct_or_molecule(char *newtoken)
{
char token[TOKENSIZE];
int tokentype;

  tokentype=gettoken(token);
  push(token,tokentype);
  strcpy(newtoken,"");

  if (strcmp(token,"(")==0)
  { eval_funct(newtoken); }
    else
  { eval_molecule(newtoken); }
}

