
/* General */ 
extern void push(char *token, int tokentype); 
extern void push2(char *token, int tokentype); 
extern void error(char *token,char *expected, char *keyword); 
extern void unsupported(char *keyword); 
extern void comment_out(char *tmp_token); 
extern int isnum(char *s);
extern void strcase(char *s);
extern void strtolower(char *s);
extern char *strcasestr(char *hejstack, char *needle);
extern void insert_session();
extern void insert_isnum();
extern int getobject(char *token);
extern int autoindent();
extern int gettoken();
extern int is_asp_filename(char *filename);
extern void change_extension(char *filename, char *extension);
extern int extcmp(char *filename, char *extension);
extern void add_indent(char *newtoken);
void eval_funct_or_molecule(char *newtoken);

extern int iskeyword(char *token);
extern int is_endscript();
extern int parse();
extern int parse_funct(int isfunct);
extern int parse_body(int iflag);
extern int parse_server(char *newtoken);
extern int parse_request(char *newtoken);
extern int parse_response();
extern int parse_set(char *newtoken);
extern int parse_command_set(char *newtoken,char *variable);
extern int parse_command(char *newtoken,char *variable);
extern int parse_rem();
extern int parse_at();
extern int parse_dim();
extern int parse_randomize();

/* HTML */

extern void parse_tag();
extern int copyhtml();
extern int fixw2k(char *token);
extern int copyhtml();
extern void parse_include(char *tag);
extern int getattribute(char *tag, char *att, char *value);

/* Token evaluation */

extern int eval_element(char *newtoken, int tokentype, char *token);
extern int eval_funct(char *newtoken);
extern int eval_token(int tokentype,char *token);
extern int isfunction(char *token);
extern int eval_molecule(char *newtoken);
extern int eval_expression(char *oldtoken);

/* DataBase */

extern int db_open(char *newtoken, char *variable);
extern int db_execute(char *newtoken, char *variable);
extern int parse_adodb_rs(char *newtoken,char *variable);
extern int parse_adodb_rs_mysql(char *newtoken,char *variable);
extern int parse_adodb_rs_odbc(char *newtoken,char *variable);
extern int parse_adodb_rs_oracle(char *newtoken,char *variable);
extern int parse_adodb_rs_pg(char *newtoken,char *variable);
extern int parse_adodb_rs_sybase(char *newtoken,char *variable);
extern int parse_adodb_connection(char *newtoken,char *variable);
extern int parse_adodb_connection_mysql(char *newtoken,char *variable);
extern int parse_adodb_connection_odbc(char *newtoken,char *variable);
extern int parse_adodb_connection_oracle(char *newtoken,char *variable);
extern int parse_adodb_connection_pg(char *newtoken,char *variable);
extern int parse_adodb_connection_sybase(char *newtoken,char *variable);
extern int getvar(char *answer, char *token, char *variable);

/* Sessions */

extern void start_session();
extern int parse_session();
extern int parse_session_properties(char *newtoken);
extern int session_registered(char *molecule);


/* Loops */

extern int parse_do_loop();
extern int parse_do();
extern int parse_while();
extern int parse_for();

/* Conditionals */

extern int parse_if();
extern int parse_select();
extern int parse_condition();

/* Mail */

extern int parse_mail(char *newtoken, char *temptoken);
extern int parse_new_mail(char *newtoken, char *temptoken);

/* FileSystem */

extern int parse_filesystem();


