#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"


/* checks to see if the current token is a known
   defined function */

int isfunction(char *token)
{
int t=0;

  for (t=0; t<functptr; t++)
  { if (strcasecmp(funct[t],token)==0) return 1; }

  return 0;
}

int parse_funct(int isfunct)
{
char token[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c;

  infunct=isfunct; 

  tokentype=gettoken(token);
  fprintf(out,"function %s",token);

  tokentype=gettoken(token);
  push(token,tokentype);

  newtoken[0]=0;

  if (strcmp(token,"(")==0)
  { eval_funct(newtoken); fprintf(out,"(%s)",newtoken); }
    else
  { fprintf(out,"()"); }

  fprintf(out,"\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  tokentype=gettoken(token);

  if (isfunct==1)
  {
    if (strcasecmp(token,"function")!=0)
    { error(token,"function","function"); }
  }
    else
  if (isfunct==2)
  {
    if (strcasecmp(token,"sub")!=0)
    { error(token,"sub","Sub"); }
  }
  infunct=0;

  return 0;
}

int eval_funct(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
int parencount=1;
char molecule[LINELENGTH];

  tokentype=gettoken(token);
  if (strcmp("(",token)!=0)
  { error(token,"(","eval_funct"); return 0; }

  while((tokentype=gettoken(token))!=0)
  {
    if (strcmp("(",token)==0)
    { parencount++; strcat(newtoken,"("); }
      else
    if (strcmp(")",token)==0)
    {
      parencount--;
      if (parencount!=0)
      { strcat(newtoken,")"); }
        else
      { break; }
    }
      else
    if (strcmp(",",token)==0)
    { strcat(newtoken,","); }
      else
    {
      eval_element(molecule,tokentype,token);
      strcat(newtoken,molecule);
    }
  }

  return 0;
}



