/* reference David Hanson, "C Interfaces and Implementations" */

#ifndef LIST_INCLUDED
#define LIST_INCLUDED

struct list_s {
	struct list_s *next;
	void *data;
};

typedef struct list_s list_t;

extern list_t *l_append(list_t *list, list_t *tail);
extern list_t *l_copy(list_t *list);
extern list_t *l_list(void *x, ...);
extern list_t *l_pop(list_t *list, void **x);
extern list_t *l_delete(list_t *list, list_t *victim);
extern list_t *l_push(list_t *list, void *x);
extern list_t *l_reverse(list_t *list);
extern int     l_length(list_t *list);
extern list_t *l_find(list_t *list, void *key, 
			int compare(list_t *, const void *));
extern void    l_free(list_t **list);
extern void  **l_2array(list_t *list, void *end);
extern void    l_map(list_t *list, 
		     void apply(void **x, void *cl),
		     void *cl);

#endif
