#ifndef TQBF_INCLUDED
#define TQBF_INCLUDED 1

#define NETWORKING_CODE

#include <sys/types.h>
#include <sys/wait.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <setjmp.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <assert.h>

#ifdef NETWORKING_CODE
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#endif

char *strim(char *string);
char *strspacecompress(char *string);
char *strimquote(char *string);
void chop(char *string);
char *basename(char *fullname, char seperator);
void *NEW(const int size);
void reap_child(int signal);
char *tfgets(char *buf, int size, FILE *fp);
struct sockaddr_in *makeaddress(char *address);
void setport(char *port, struct sockaddr_in *sip);
int makeconnect(struct sockaddr_in *sip);
int jday(int month, int day, int year);
u_short in_cksum(u_short *, int);
unsigned long resolve(char *address);

#endif

