#include "libtqbf.h"

#ifndef NUL
#define NUL_DEFINED
#define NUL '\0'
#endif

/*------------------------------------------------------------------------*/

/* handle timeouts for these routines */

jmp_buf Timeout;
void timeout(int signal) {
	longjmp(Timeout, 1);
	/* notreached */
}

/*------------------------------------------------------------------------*/

#include <assert.h>

char *
strsc(char *string) {
	int x = 0;
	int y = 0;

	assert(string);	

	if(!strlen(string))
		return(string);

	while(string[x]) {
		if(isspace(string[x])) {
			if(y && string[x + 1]) 
				string[y++] = ' ';
		
			while(isspace(string[x]))
				x++;
		} else 
			string[y++] = string[x++];
	}

				
	string[y] = '\0';
	return(string);
}

/*------------------------------------------------------------------------*/

/* zorch leading and trailing tabs, spaces, and newlines */

char *
strim(char *string) {
	int i = 0;
	char *cp;

	assert(string);

	if(!strlen(string))
		return(string);

	for(i = 0; isspace(string[i]); i++);
	/* do nothing */

	if(i) strcpy(string, string + i);

	cp = string + strlen(string);
	while((cp--) != string && isspace(*cp)) 
		*cp = NUL;	

	return(string);
}

/*------------------------------------------------------------------------*/

/* reduce X * whitespace to whitespace (including newline) */

char *
strspacecompress(char *string) {
	int x = 0;
	int y = 0;

	assert(string);	

	if(!strlen(string))
		return(string);

	while(string[x]) {
		if(isspace(string[x])) {
			if(y && string[x + 1]) 
				string[y++] = ' ';
		
			while(isspace(string[x]))
				x++;
		} else 
			string[y++] = string[x++];
	}

				
	string[y] = NUL;
	return(string);
}

/*------------------------------------------------------------------------*/

/* strip leading and trailing quotes */

char * 
strimquote(char *string) {
	assert(string);

	string = strim(string);

	if(*string == '\"') {
		string++;
		if(string[strlen(string) - 1] == '\"')
			string[strlen(string) - 1] = NUL;
	}

	return(string);
}

/*------------------------------------------------------------------------*/

/* cut last whitespace / newline character from string */

void
chop(char *string) {
	assert(string);

	if(isspace(string[strlen(string) - 1]))
		string[strlen(string) - 1] = NUL;

	return;
}

/*------------------------------------------------------------------------*/

/* get the "filename" part of a fully qualified path */

char *basename(char *fullname, char seperator) {
	char *cp;

	assert(fullname);

	if(!seperator) 
		seperator = '/';

	cp = strrchr(fullname, seperator);

	return cp ? cp + 1 : fullname;
}	

/*------------------------------------------------------------------------*/

/* silly malloc wrapper */

void *NEW(const int size) {
	void *ptr = (void *) calloc(1, size);
	if(!ptr) {
		fprintf(stderr, "malloc: allocation failed\n");
		assert(ptr);
	}

	return(ptr);
}

/*------------------------------------------------------------------------*/

/* silly waitpid wrapper */

#ifndef WAIT_ALLPROCS 
#define WAP_DEFINED 
#define WAIT_ALLPROCS 0
#endif

void reap_child(int signal) {
	while(wait3(&signal, WNOHANG, NULL) != -1)
		/* continue reaping */ ;

	return;
}

#ifdef WAP_DEFINED
#undef WAP_DEFINED
#undef WAIT_ALLPROCS
#endif

/*------------------------------------------------------------------------*/

/* fgets, with a timeout */

#ifndef READ_TIMEOUT 
#define RT_DEFINED
#define READ_TIMEOUT 60
#endif

char *tfgets(char *buf, int size, FILE *fp) {
	char *cp;
	int i = 5;

	if(!buf) 
		buf = (char *) NEW(size + 1);

	if(setjmp(Timeout)) {
		errno = ETIMEDOUT;
		return(NULL);
	}

	signal(SIGALRM, timeout);
	alarm((unsigned)READ_TIMEOUT);
	
	do {
		cp = fgets(buf, size, fp);
		i--;
	} while(errno == EINTR && i);

	if(!cp && errno == EINTR)
		errno = ETIMEDOUT;

	alarm((unsigned) 0);
	return(cp);
}
	
#ifdef RT_DEFINED
#undef RT_DEFINED
#undef READ_TIMEOUT
#endif
	
/*------------------------------------------------------------------------*/

#ifdef NETWORKING_CODE

/*------------------------------------------------------------------------*/

/* resolve a hostname into an unsigned long */

struct sockaddr_in *
makeaddress(char *address) {
	struct sockaddr_in *sip;
	struct hostent *hptr;

	sip = (struct sockaddr_in *) NEW(sizeof(struct sockaddr_in));
	
	if((sip->sin_addr.s_addr = inet_addr(address)) == INADDR_NONE) {
		hptr = gethostbyname(address);
		if(!hptr) {
			free(sip);
			return(NULL);
		} else 
			memcpy(&sip->sin_addr, hptr->h_addr,
							hptr->h_length);
	}

	sip->sin_family = PF_INET;
	return(sip);
}
	
/*------------------------------------------------------------------------*/

/* just to avoid sockaddr_in unpleasantness... */

void
setport(char *port, struct sockaddr_in *sip) {
	struct servent *sp;

	sp = getservbyname(port, "tcp");
	if(!sp) {
		int i = atoi(port);
		sip->sin_port = htons(i);
		return;
	}
 
	sip->sin_port = sp->s_port;
	return;
}

/*------------------------------------------------------------------------*/

#ifndef CONN_TIMEOUT 
#define CT_DEFINED
#define CONN_TIMEOUT 60
#endif

/* return a connected socket... */

int makeconnect(struct sockaddr_in *sip) {
	int sockfd;

	if((sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) 
		return(-1);

	/* catch timeout */
	if(setjmp(Timeout)) {
		close(sockfd);
		errno = ETIMEDOUT;
		return(-3);
	}

	signal(SIGALRM, timeout);
	alarm((unsigned) CONN_TIMEOUT);
	if((connect(sockfd, (struct sockaddr *)sip, sizeof(*sip))) < 0) {
		/* save errno */
		int save_errno = errno;

		alarm((unsigned) 0);
		close(sockfd);

		errno = save_errno;

		if(errno == EINTR) 
			errno = ETIMEDOUT;
		
		return(-2);
	}

	return(sockfd);
}

#ifdef CT_DEFINED 
#undef CT_DEFINED
#undef CONN_TIMEOUT
#endif

/*------------------------------------------------------------------------*/

u_long resolve(char *address) {
	struct hostent *hp;
	unsigned long a;

	a = inet_addr(address);
	if(a == INADDR_NONE) {
		hp = gethostbyname(address);
		if(!hp)
			return(INADDR_NONE);
	
		memcpy(&a, hp->h_addr, 4);
	}

	return(a);
}

#endif NETWORKING_CODE

/*------------------------------------------------------------------------*/

/* Tracy's Julian date routine */ 

int jday (int month, int day, int year) {
	int c, ya, jd;

	int brit_jd = 2361222;

	if (month > 2) 
		month -= 3;
	else 
		month += 9, year--;
	
	c = (int) (year/100);
	ya = year - (100 * c);

	jd = (int) ((146097 * c) / 4) + 
		(int)((1461 * ya) / 4) +
		(int)((153 * month + 2) / 5) +
		day + 1721119;

	return(jd);
}

/*------------------------------------------------------------------------*/

/* clear global defined constants */

#ifdef NUL_DEFINED
#undef NUL_DEFINED
#undef NUL
#endif
