/* 1997 Thomas Ptacek, EnterAct, L.L.C. */

#include "arpcatch.h"

u_long arp_reqip(u_char *packet) {
	struct arphdr *ah;
	u_long ia;

	ah = (struct arphdr *) packet;

	/* ARP hardware type must be Ethernet */

	if(ntohs(ah->ar_hrd) != ARPHRD_ETHER)
		return(INADDR_NONE);

	/* ARP protocol must be IP */

	if(ntohs(ah->ar_pro) != ETHERTYPE_IP)
		return(INADDR_NONE);

	/* Verify these facts based on the size of their
	 * address fields.
	 */

	if(ah->ar_hln != ETHERADDR_FIXEDSZ)
		return(INADDR_NONE);

	if(ah->ar_pln != IPADDR_FIXEDSZ)
		return(INADDR_NONE);

	/* Ignore anything that isn't a request */

	if(ntohs(ah->ar_op) != ARPOP_REQUEST)
		return(INADDR_NONE);

	/* dereference the requested IP address */

	ia = (*(unsigned long *)(packet + 
				 sizeof(struct arphdr) + 	
				 ah->ar_hln +
				 ah->ar_pln +
				 ah->ar_hln));

	return(ia);
}

int arp_send(int fd,
	     u_long *srci, u_long *dsti, 
	     struct ether_addr *srca, 
	     struct ether_addr *dsta) {

	/* don't rebuild anything we need later on */

	static int i = 0;
	static u_char buffer[64];
	
	/* cache requested addresses */

	static struct ether_addr 	ea_c;
	static unsigned long 		ia_c;

	struct in_addr ia;

	/* initialize the packet once */

	if(!i) {
		struct ether_header eh;
		struct arphdr ah;

		/* tabula rasa */

		memset(&eh, 0, sizeof(eh));
		memset(&ah, 0, sizeof(ah));
		memset(buffer, 0, sizeof(buffer));
		memset(&ea_c, 0, sizeof(ea_c));
		memset(&ia_c, 0, sizeof(ia_c));

		/* ARP header invariants */

		ah.ar_op 	= htons(ARPOP_REPLY);
		ah.ar_hrd	= htons(ARPHRD_ETHER);
		ah.ar_pro	= htons(ETHERTYPE_IP);
		ah.ar_hln	= ETHERADDR_FIXEDSZ;
		ah.ar_pln	= IPADDR_FIXEDSZ;

		/* ethernet header invariant */

		eh.ether_type	= htons(ETHERTYPE_ARP);

		/* concatenate */

		memcpy(buffer, &eh, sizeof(eh));
		memcpy(buffer + ETHERHEADER_FIXEDSZ, &ah, sizeof(ah));	

		i++;
	}

	/* UGH */

	ia.s_addr = *srci;
	ia.s_addr = *dsti;

	/* ethernet header */

	memcpy(buffer + ETHER_DST, dsta, ETHERADDR_FIXEDSZ);
	memcpy(buffer + ETHER_SRC, srca, ETHERADDR_FIXEDSZ);

	memcpy(buffer + ARP_SHARD, srca,  sizeof(*dsta));
	memcpy(buffer + ARP_THARD, dsta,  sizeof(*srca));

	memcpy(buffer + ARP_SNET, srci,  sizeof(u_long));
	memcpy(buffer + ARP_TNET, dsti,  sizeof(u_long));

	if(write(fd, buffer, ETHERARP_FIXEDSZ) < 0) 
		return(-1);

	return(0);
}
