/*
 * Copyright 2001-2002 pilot <pilot@monkey.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>

#include "arirang.h"

void
osdetect(char *scanhost)
{
	int             sock;
	struct sockaddr_in http;
	struct hostent *he;


	char            osfinger[100];
	char            headBuff[6700];

	char           *ptr, *ptr2, *buffer_pointer, *cutbuf;



	if ((he = gethostbyname(NETCRAFT)) == NULL) {
		perror("gethostbyname");
		exit(1);
	}
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}
	http.sin_family = AF_INET;
	http.sin_port = htons(80);
	http.sin_addr = *((struct in_addr *) he->h_addr);
	bzero(&(http.sin_zero), 8);

	if (connect(sock, (struct sockaddr *) & http, sizeof(struct sockaddr)) == -1) {
		perror("connect");
		exit(1);
	}
	snprintf(osfinger, sizeof(osfinger), "GET %s%s HTTP/1.0\n\n", NETCRAFT_FINGER, scanhost);
	send(sock, osfinger, strlen(osfinger), 0);
	recv(sock, headBuff, sizeof(headBuff), MSG_WAITALL);

	ptr = strstr(headBuff, "running <b>");

	if (ptr == NULL) {
		fprintf(stderr, "unable to retrieve OS type\n");
	} else {
		ptr2 = strstr(ptr, "</b>.");
		*ptr2 = '\0';
		buffer_pointer = strdup(ptr);
		*ptr2 = '.';


		cutbuf = strtok(buffer_pointer, HTML_FILTER);
		fprintf(stdout, "Operating System Guess: %s ", scanhost);
		while (cutbuf != NULL) {
			fprintf(stdout, "%s", cutbuf);
			cutbuf = strtok(NULL, HTML_FILTER);

		}
		printf("\n\n");
		free(buffer_pointer);
	}

	close(sock);

}
