/*
 * Copyright 2000-2001 pilot <pilot@monkey.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include "screen.h"
#include "version.h"


void
scrview(void)
{
        system(PATH_CLEAR);
        fprintf(stderr,
        "\033[1;36m===============================================================================\033[0m\n"
        "\033[0;34m   Don't tell your webserver free from attack \033[0m\033[0;35m   arirang %s\033[0m %s\033[0m\n"
        "                                                 2000-2001 by pilot    \n"
        "                                                 powered by twwwscan\n"
        "\033[1;36m=============================================================================== \033[0m\n"
         ,VERSION,RELEASE_DATE);
}

void
usage(void)
{
        scrview();	
        fprintf(stderr,
        "usage        : arirang [-GO] [-p] [-hfs] [-e] [-r] [-v] [-P]                \n"
        "<finger>     : -O  webserver operating system finger print use netcraft     \n"
        "               -G  grab Server in HTTP HEADER                               \n"
        "<port>       : -p  webserver running port 				     \n"
        "<scan type>  : -h  one host scan					     \n"
        "             : -f  scan hosts list file                                     \n"
        "             : -s  wide network scan  start ip 			     \n"
        "             : -e  wide network scan  end   ip				     \n" 
        "<scan rule>  : -r  arirang scan rule databases(.uxe)                        \n"
        "<virtual>    : -v  virtual host scan and http 1.1                           \n"
        "<process>    : -P  max process count(default wide,file 30,normal 0)         \n"
        "<examples>                                                                  \n" 
        "grab server  : arirang -G -h drill.hackerslab.org                           \n"
        "os detect    : arirang -O -h 203.239.110.20                                 \n"
        "server port  : arirang -G -p 8080 -h yourhost                               \n"
        "virtual      : arirang -G -h virtual_host -r test.uxe -v                    \n"
        "scan hosts   : arirang -G -f scanlist_file                                  \n"
        "wide         : arirang -G -s 192.168.1.1 -e 192.168.2.255                   \n"     
        "scan rule    : arirang -O -h drill.hackerslab.org -r unix.uxe               \n"
        "fast scan    : arirang -G -h drill.hackerslab.org -r unix.uxe -P 20         \n" 
        "             : arirang -G -f scanlist_file -r unicode.uxe -P 10             \n"
        "             : arirang -G -s 192.168.1.1 -e 192.168.2.255 -r unix.uxe     \n\n"
        "contact      : pilot@monkey.org    http://www.monkey.org/~pilot           \n\n"
        "thanks to r0ar,a_a_a,apl,BK,chute,parasol,bitrider,                         \n"
        "Dug Song(monkey.org),UNYUN(Shadow Penguin Security),Roelof(www.sensepost.com)\n"
        "David(A.K.A AnOnYmUs),OpenBSD friends(dhartmei,fgsch,ActivatE,obecian,Lupines)\n\n"
        "tested on OpenBSD 2.8,2.9,FreeBSD 4.3,Linux Kernel 2.4.2,Solaris 5.7 Sparc\n\n"
           );
        exit(1);
}


